/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.dismantle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.dismantle.DismantleManager;
import studio.magemonkey.divinity.modules.list.dismantle.event.PlayerDismantleItemEvent;
import studio.magemonkey.divinity.modules.list.dismantle.event.PlayerPreDismantleItemEvent;

class DismantleGUI
extends NGUI<Divinity> {
    protected DismantleManager dismantleManager;
    protected int[] itemSlots;
    protected int[] resultSlots;

    public DismantleGUI(@NotNull DismantleManager dismantleManager) {
        super((CodexPlugin)((Divinity)dismantleManager.plugin), dismantleManager.getJYML(), "gui.");
        this.dismantleManager = dismantleManager;
        JYML cfg = dismantleManager.getJYML();
        String path = "gui.";
        this.itemSlots = cfg.getIntArray(path + "item-slots");
        this.resultSlots = cfg.getIntArray(path + "result-slots");
        GuiClick click = (p, type, e) -> {
            if (type == ContentType.ACCEPT) {
                Inventory inv = e.getInventory();
                HashMap<ItemStack, DismantleManager.OutputContainer> result = new HashMap<ItemStack, DismantleManager.OutputContainer>();
                double cost = 0.0;
                for (int slot : this.itemSlots) {
                    DismantleManager.OutputContainer oCont;
                    ItemStack target = inv.getItem(slot);
                    if (target == null || (oCont = dismantleManager.getResult(target)) == null) continue;
                    cost += oCont.getCost() * (double)target.getAmount();
                    result.put(target, oCont);
                }
                if (result.isEmpty()) {
                    return;
                }
                PlayerPreDismantleItemEvent event = new PlayerPreDismantleItemEvent(p, cost, result);
                ((Divinity)this.plugin).getPluginManager().callEvent((Event)event);
                cost = event.getCost();
                if (!dismantleManager.payForDismantle(p, cost)) {
                    event.setCancelled(true);
                }
                if (event.isCancelled()) {
                    dismantleManager.actionsError.process((Entity)p);
                    return;
                }
                for (Map.Entry entry : result.entrySet()) {
                    ItemStack target = (ItemStack)entry.getKey();
                    DismantleManager.OutputContainer c = (DismantleManager.OutputContainer)entry.getValue();
                    for (int i = 0; i < target.getAmount(); ++i) {
                        for (DismantleManager.OutputItem src : c.getItems()) {
                            src.give(p);
                        }
                    }
                }
                for (Object slot : (Object)this.itemSlots) {
                    inv.setItem((int)slot, null);
                }
                PlayerDismantleItemEvent event2 = new PlayerDismantleItemEvent(p, cost, result);
                ((Divinity)this.plugin).getPluginManager().callEvent((Event)event2);
                p.closeInventory();
            } else if (type == ContentType.EXIT) {
                p.closeInventory();
            }
        };
        for (String itemId : cfg.getSection(path + "content")) {
            GuiItem guiItem = cfg.getGuiItem(path + "content." + itemId, ContentType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
    }

    protected void onReady(@NotNull Player player, @NotNull Inventory inv, int page) {
        this.update(inv);
        super.onReady(player, inv, page);
    }

    protected boolean ignoreNullClick() {
        return false;
    }

    protected boolean cancelClick(int slot) {
        return !ArrayUtils.contains((int[])this.itemSlots, (int)slot);
    }

    protected boolean cancelPlayerClick() {
        return false;
    }

    public void click(@NotNull Player player, @Nullable ItemStack item, int slot, InventoryClickEvent e) {
        if (slot >= this.getSize() && item != null && !this.dismantleManager.isDismantleable(item)) {
            e.setCancelled(true);
            return;
        }
        if (!this.cancelClick(slot) || slot > this.getSize() && e.isShiftClick()) {
            ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.update(e.getInventory()));
        }
        super.click(player, item, slot, e);
    }

    public void onClose(@NotNull Player player, InventoryCloseEvent e) {
        Inventory inv = e.getInventory();
        for (int slot : this.itemSlots) {
            ItemStack target = inv.getItem(slot);
            if (target == null) continue;
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{target});
        }
    }

    private void update(@NotNull Inventory inv) {
        double cost = 0.0;
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        for (int slot : this.itemSlots) {
            DismantleManager.OutputContainer oCont;
            ItemStack itemStack = inv.getItem(slot);
            if (itemStack == null || (oCont = this.dismantleManager.getResult(itemStack)) == null) continue;
            cost += oCont.getCost() * (double)itemStack.getAmount();
            for (int i = 0; i < itemStack.getAmount(); ++i) {
                for (DismantleManager.OutputItem src : oCont.getItems()) {
                    ItemStack preview = src.getPreview();
                    if (preview == null) continue;
                    ItemStack pCopy = new ItemStack(preview);
                    int amount = pCopy.getAmount();
                    pCopy.setAmount(1);
                    if (result.containsKey(pCopy)) {
                        amount += ((Integer)result.get(pCopy)).intValue();
                    }
                    result.put(pCopy, amount);
                }
            }
        }
        String sCost = NumberUT.format((double)cost);
        for (int i = 0; i < this.resultSlots.length; ++i) {
            inv.setItem(this.resultSlots[i], null);
        }
        for (GuiItem guiItem : this.getContent().values()) {
            List lore;
            ItemStack item = guiItem.getItem();
            for (int slot : guiItem.getSlots()) {
                if (!ArrayUtils.contains((int[])this.resultSlots, (int)slot)) continue;
                inv.setItem(slot, item);
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta == null) continue;
            if (itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(itemMeta.getDisplayName().replace("%cost%", sCost));
            }
            if ((lore = itemMeta.getLore()) != null) {
                lore.replaceAll(str -> str.replace("%cost%", sCost));
                itemMeta.setLore(lore);
            }
            item.setItemMeta(itemMeta);
            for (int i : guiItem.getSlots()) {
                inv.setItem(i, item);
            }
        }
        int j = 0;
        for (Map.Entry e : result.entrySet()) {
            int[] parts;
            int n = (Integer)e.getValue();
            for (int amountPart : parts = NumberUT.splitIntoParts((int)n, (int)((int)Math.ceil((double)n / 64.0)))) {
                if (j >= this.resultSlots.length) {
                    return;
                }
                ItemStack preview = new ItemStack((ItemStack)e.getKey());
                preview.setAmount(amountPart);
                inv.setItem(this.resultSlots[j++], preview);
            }
        }
    }
}

