/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.IAbstractSkill;

public class AddSkillCmd
extends MCmd<ClassManager> {
    public AddSkillCmd(@NotNull ClassManager module) {
        super(module, new String[]{"addskill"}, "quantumrpg.classes.cmd.addskill");
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_AddSkill_Desc.getMsg();
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_AddSkill_Usage.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return PlayerUT.getPlayerNames();
        }
        if (i == 2) {
            return new ArrayList<String>(((ClassManager)this.module).getSkillIds());
        }
        if (i == 3) {
            return Arrays.asList("-1", "1", "2", "3");
        }
        if (i == 4) {
            return Arrays.asList("true", "false");
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        Player player;
        if (args.length < 4) {
            this.printUsage(sender);
            return;
        }
        String playerName = args[1];
        String skillId = args[2];
        int lvl = this.getNumI(sender, args[3], 1);
        boolean force = true;
        if (args.length >= 5) {
            force = Boolean.parseBoolean(args[4]);
        }
        if ((player = ((Divinity)this.plugin).getServer().getPlayer(playerName)) == null) {
            this.errPlayer(sender);
            return;
        }
        IAbstractSkill skill = ((ClassManager)this.module).getSkillById(skillId);
        if (skill == null) {
            ((Divinity)this.plugin).lang().Classes_Cmd_AddSkill_Error_NoSkill.send(sender);
            return;
        }
        ((ClassManager)this.module).addSkill(player, skill, lvl, force);
        ((Divinity)this.plugin).lang().Classes_Cmd_AddSkill_Done.replace("%skill%", (Object)skill.getName()).replace("%name%", (Object)player.getName()).send(sender);
    }
}

