/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.hooks.external.WorldGuardHK;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.external.mythicmobs.AbstractMythicMobsHK;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.event.PlayerClassExpGainEvent;
import studio.magemonkey.divinity.modules.list.classes.event.PlayerClassLevelChangeEvent;
import studio.magemonkey.divinity.modules.list.classes.object.ExpObject;
import studio.magemonkey.divinity.modules.list.classes.object.ExpSource;
import studio.magemonkey.divinity.stats.EntityStats;

public class LevelingManager
extends IListener<Divinity>
implements Loadable {
    private final ClassManager classManager;
    private JYML cfg;
    private Map<String, Integer> lvlWorlds;
    private Set<String> expWorldList;
    private boolean lvlIsWorldBlack;
    private Set<String> lvlRegionBlack;
    private boolean lvlIsRegionWhite;
    private boolean expUseTables;
    private Set<String> expReasonBlack;
    private Map<String, ExpObject> expSrcVanilla;
    private Map<String, ExpObject> expSrcMythic;
    private boolean expBossBarEnabled;
    private String expBossBarTitle;
    private BarColor expBossBarColor;
    private BarStyle expBossBarStyle;
    private Map<Player, BossBar> expBossBarCache;
    private int expLossDeathPercent;
    private boolean expLossAllowNegative;
    private boolean expBalDecEnabled;
    private int expBalDecInterval;
    private int expBalDecMaxTimes;
    private int expBalDecPercent;
    private boolean expBalIncEnabled;
    private int expBalIncInterval;
    private int expBalIncMaxTimes;
    private int expBalIncPercent;
    private AbstractMythicMobsHK mmHook;
    private static final String ENTITY_NO_EXP_SPAWN = "QRPG_NO_DROP_EXP";

    LevelingManager(@NotNull ClassManager classManager) {
        super((JavaPlugin)((Divinity)classManager.plugin));
        this.classManager = classManager;
    }

    public void setup() {
        try {
            this.cfg = JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)(this.classManager.getPath() + "leveling.yml"));
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load leveling config (" + this.classManager.getPath() + "leveling.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        this.mmHook = (AbstractMythicMobsHK)((Divinity)this.plugin).getHook(AbstractMythicMobsHK.class);
        this.lvlWorlds = new HashMap<String, Integer>();
        for (String wName : this.cfg.getSection("world-levels")) {
            int lvl = this.cfg.getInt("world-levels." + wName);
            if (lvl <= 0) continue;
            this.lvlWorlds.put(wName, lvl);
        }
        this.expWorldList = this.cfg.getStringSet("world-whitelist.list");
        this.lvlIsWorldBlack = this.cfg.getBoolean("world-whitelist.reverse");
        this.lvlRegionBlack = this.cfg.getStringSet("region-blacklist.list");
        this.lvlIsRegionWhite = this.cfg.getBoolean("region-blacklist.reverse");
        String path = "exp.";
        this.expUseTables = this.cfg.getBoolean(path + "use-tables");
        path = "exp.boss-bar.";
        this.expBossBarEnabled = this.cfg.getBoolean(path + "enabled");
        if (this.expBossBarEnabled) {
            this.expBossBarTitle = StringUT.color((String)this.cfg.getString(path + "title", ""));
            this.expBossBarColor = (BarColor)CollectionsUT.getEnum((String)this.cfg.getString(path + "color", "YELLOW"), BarColor.class);
            this.expBossBarStyle = (BarStyle)CollectionsUT.getEnum((String)this.cfg.getString(path + "style", "SOLID"), BarStyle.class);
            this.expBossBarCache = new WeakHashMap<Player, BossBar>();
        }
        path = "exp.sources.";
        this.expReasonBlack = this.cfg.getStringSet(path + "prevent-from");
        if (this.expUseTables) {
            double chance;
            int max;
            int min;
            String path2;
            this.expSrcVanilla = new HashMap<String, ExpObject>();
            for (String sId : this.cfg.getSection(path + "vanilla-mobs")) {
                path2 = path + "vanilla-mobs." + sId + ".";
                min = this.cfg.getInt(path2 + "min");
                max = this.cfg.getInt(path2 + "max");
                chance = this.cfg.getDouble(path2 + "chance");
                this.expSrcVanilla.put(sId.toLowerCase(), new ExpObject(min, max, chance));
            }
            if (this.mmHook != null) {
                this.expSrcMythic = new HashMap<String, ExpObject>();
                for (String sId : this.cfg.getSection(path + "mythic-mobs")) {
                    path2 = path + "mythic-mobs." + sId + ".";
                    min = this.cfg.getInt(path2 + "min");
                    max = this.cfg.getInt(path2 + "max");
                    chance = this.cfg.getDouble(path2 + "chance");
                    this.expSrcMythic.put(sId.toLowerCase(), new ExpObject(min, max, chance));
                }
            }
        }
        if (this.cfg.getBoolean((path = "exp.loss.") + "on-death.enabled")) {
            this.expLossDeathPercent = this.cfg.getInt(path + "on-death.percent");
            this.expLossAllowNegative = this.cfg.getBoolean(path + "allow-negative");
        }
        path = "exp.balance.decrease-for-low-lvl-mobs.";
        this.expBalDecEnabled = this.cfg.getBoolean(path + "enabled");
        this.expBalDecInterval = this.cfg.getInt(path + "every");
        this.expBalDecMaxTimes = this.cfg.getInt(path + "max-times");
        this.expBalDecPercent = this.cfg.getInt(path + "percent");
        path = "exp.balance.increase-for-high-lvl-mobs.";
        this.expBalIncEnabled = this.cfg.getBoolean(path + "enabled");
        this.expBalIncInterval = this.cfg.getInt(path + "every");
        this.expBalIncMaxTimes = this.cfg.getInt(path + "max-times");
        this.expBalIncPercent = this.cfg.getInt(path + "percent");
        this.registerListeners();
    }

    public void shutdown() {
        this.unregisterListeners();
        if (this.expSrcVanilla != null) {
            this.expSrcVanilla.clear();
            this.expSrcVanilla = null;
        }
        if (this.expSrcMythic != null) {
            this.expSrcMythic.clear();
            this.expSrcMythic = null;
        }
        if (this.expBossBarCache != null) {
            this.expBossBarCache.forEach((p, bar) -> bar.removeAll());
            this.expBossBarCache.clear();
            this.expBossBarCache = null;
        }
        this.cfg = null;
    }

    public void updateExpBossBar(@NotNull Player player) {
        if (!this.expBossBarEnabled) {
            return;
        }
        BossBar bar = this.expBossBarCache.computeIfAbsent(player, b -> ((Divinity)this.plugin).getServer().createBossBar("", this.expBossBarColor, this.expBossBarStyle, new BarFlag[0]));
        UserClassData data = this.classManager.getUserData(player);
        int expHas = data == null ? 0 : data.getExp();
        int expMax = data == null ? 0 : data.getExpToUp(true);
        int level = data == null ? 0 : data.getLevel();
        String title = this.expBossBarTitle.replace("%exp%", String.valueOf(expHas)).replace("%exp-max%", String.valueOf(expMax)).replace("%level%", String.valueOf(level));
        if (Hooks.hasPlugin((String)"PlaceholderAPI")) {
            title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
        }
        double progress = expMax > 0 ? (double)expHas / (double)expMax : 0.0;
        bar.setTitle(title);
        bar.setProgress(progress);
        bar.setVisible(true);
        if (!bar.getPlayers().contains(player)) {
            bar.addPlayer(player);
        }
    }

    public boolean canDropExp(@NotNull Entity entity) {
        boolean isListedWorld = this.expWorldList.contains(entity.getWorld().getName());
        if (isListedWorld == this.lvlIsWorldBlack) {
            return false;
        }
        WorldGuardHK worldGuard = ((Divinity)this.plugin).getWorldGuard();
        if (worldGuard != null) {
            boolean isListedReg = this.lvlRegionBlack.contains(worldGuard.getRegion(entity));
            return isListedReg == this.lvlIsRegionWhite;
        }
        return true;
    }

    public int getExpFromTable(@NotNull Entity from) {
        boolean mythic = this.mmHook != null && this.mmHook.isMythicMob(from);
        String type = mythic ? this.mmHook.getMythicNameByEntity(from) : from.getType().name();
        Map<String, ExpObject> expMap = mythic ? this.expSrcMythic : this.expSrcVanilla;
        ExpObject expObject = expMap.getOrDefault(type.toLowerCase(), expMap.getOrDefault("default".toLowerCase(), null));
        return expObject == null ? 0 : expObject.getExp();
    }

    private double balanceExp(@NotNull Player player, @NotNull Entity from, double exp) {
        return exp * this.getExpPercentByLevel(player, from);
    }

    public void addExp(@NotNull Player player, @NotNull Entity from) {
        double amount = this.balanceExp(player, from, this.getExpFromTable(from));
        String src = EntityStats.getEntityName(from);
        this.addExp(player, (int)amount, src, ExpSource.MOB_KILL);
    }

    public void addExp(Player player, int amount, String src, ExpSource srcExp) {
        if (!this.expLossAllowNegative && (double)amount < 0.0) {
            return;
        }
        if (amount == 0) {
            return;
        }
        UserClassData cData = this.classManager.getUserData(player);
        if (cData == null) {
            return;
        }
        if (amount > 0) {
            double expBonus = 0.0;
            amount = (int)((double)amount * (1.0 + expBonus / 100.0));
        }
        PlayerClassExpGainEvent e = new PlayerClassExpGainEvent(player, cData, amount, src, srcExp);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        int lvlHas = cData.getLevel();
        amount = e.getExp();
        cData.addExp(amount);
        if (amount >= 0) {
            ((Divinity)this.plugin).lang().Classes_Leveling_Exp_Get.replace("%exp%", (Object)amount).replace("%src%", (Object)src).send((CommandSender)player);
        } else {
            ((Divinity)this.plugin).lang().Classes_Leveling_Exp_Lost.replace("%exp%", (Object)Math.abs(amount)).replace("%src%", (Object)src).send((CommandSender)player);
        }
        int lvlNew = cData.getLevel();
        if (lvlHas != lvlNew) {
            PlayerClassLevelChangeEvent e2 = new PlayerClassLevelChangeEvent(player, cData, amount);
            ((Divinity)this.plugin).getPluginManager().callEvent((Event)e2);
            if (lvlNew > lvlHas) {
                ((Divinity)this.plugin).lang().Classes_Leveling_Level_Up.replace("%lvl%", (Object)String.valueOf(lvlNew)).send((CommandSender)player);
                RPGClass rpgClass = cData.getPlayerClass();
                int aPoints = rpgClass.getAspectPointsPerLevel() * (lvlNew - lvlHas);
                int sPoints = rpgClass.getSkillPointsPerLevel() * (lvlNew - lvlHas);
                ((Divinity)this.plugin).lang().Classes_Leveling_Points_Aspect_Get.replace("%amount%", (Object)String.valueOf(aPoints)).send((CommandSender)player);
                ((Divinity)this.plugin).lang().Classes_Leveling_Points_Skill_Get.replace("%amount%", (Object)String.valueOf(sPoints)).send((CommandSender)player);
                for (int lvlAct = lvlHas + 1; lvlAct < lvlNew + 1; ++lvlAct) {
                    rpgClass.executeLevelActions(player, lvlAct);
                }
            } else {
                ((Divinity)this.plugin).lang().Classes_Leveling_Level_Down.replace("%lvl%", (Object)String.valueOf(lvlNew)).send((CommandSender)player);
            }
            this.classManager.updateClassData(player);
        }
        this.updateExpBossBar(player);
    }

    private double getEntityLevel(@NotNull Entity entity) {
        return Math.max(1.0, EngineCfg.HOOK_MOB_LEVEL_PLUGIN.getMobLevel(entity));
    }

    private double getExpPercentByLevel(@NotNull Player player, @NotNull Entity entity) {
        double userLvl;
        UserClassData cData = this.classManager.getUserData(player);
        if (cData == null) {
            return 1.0;
        }
        double mobLvl = this.getEntityLevel(entity);
        if (mobLvl < (userLvl = (double)cData.getLevel()) && this.expBalDecEnabled) {
            double max = this.expBalDecMaxTimes * this.expBalDecPercent;
            double reduceExp = Math.min(max, (userLvl - mobLvl) / (double)this.expBalDecInterval * (double)this.expBalDecPercent);
            return Math.max(0.0, 1.0 - reduceExp / 100.0);
        }
        if (mobLvl > userLvl && this.expBalIncEnabled) {
            double max = this.expBalIncMaxTimes * this.expBalIncPercent;
            double incExp = Math.min(max, (mobLvl - userLvl) / (double)this.expBalIncInterval * (double)this.expBalIncPercent);
            return 1.0 + incExp / 100.0;
        }
        return 1.0;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExpLevelWorldChange(PlayerTeleportEvent e) {
        if (this.lvlWorlds.isEmpty()) {
            return;
        }
        Player player = e.getPlayer();
        if (Hooks.isNPC((Entity)player)) {
            return;
        }
        Location to = e.getTo();
        if (to == null) {
            return;
        }
        World world = to.getWorld();
        if (world == null || world.equals((Object)player.getWorld())) {
            return;
        }
        int minLvl = this.lvlWorlds.getOrDefault(world.getName(), 0);
        if (minLvl <= 0) {
            return;
        }
        UserClassData cData = this.classManager.getUserData(player);
        if (cData == null) {
            e.setCancelled(true);
            ((Divinity)this.plugin).lang().Classes_Error_NoClass.send((CommandSender)player);
            return;
        }
        if (cData.getLevel() < minLvl) {
            e.setCancelled(true);
            ((Divinity)this.plugin).lang().Classes_Error_Level_World.replace("%level%", (Object)minLvl).send((CommandSender)player);
            return;
        }
    }

    @EventHandler
    public void onExpLevelUpDown(PlayerClassLevelChangeEvent e) {
        Player player = e.getPlayer();
        UserClassData cData = e.getClassData();
        if (cData.isTimeToChildClass()) {
            ((Divinity)this.plugin).lang().Classes_Leveling_Child_Available.send((CommandSender)player);
            if (!this.classManager.selectPopChildTime || this.classManager.isRemindDisabled(player)) {
                return;
            }
            this.classManager.openSelectionGUI(player, false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExpMobSpawn(CreatureSpawnEvent e) {
        String res = e.getSpawnReason().name();
        if (this.expReasonBlack.contains(res)) {
            LivingEntity entity = e.getEntity();
            entity.setMetadata(ENTITY_NO_EXP_SPAWN, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"yes"));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onExpPlayerDeath(PlayerDeathEvent e) {
        if ((double)this.expLossDeathPercent <= 0.0) {
            return;
        }
        Player player = e.getEntity();
        if (!this.canDropExp((Entity)player)) {
            return;
        }
        UserClassData cData = this.classManager.getUserData(player);
        if (cData == null) {
            return;
        }
        double expHas = Math.abs(cData.getExp());
        double expLoss = expHas * ((double)this.expLossDeathPercent / 100.0);
        if (expLoss <= 0.0) {
            return;
        }
        if (expLoss > expHas) {
            expLoss = expHas;
        }
        this.addExp(player, (int)(-expLoss), player.getName(), ExpSource.DEATH);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpMobDeath(EntityDeathEvent e) {
        LivingEntity dead = e.getEntity();
        if (dead.hasMetadata(ENTITY_NO_EXP_SPAWN)) {
            return;
        }
        if (!this.canDropExp((Entity)dead)) {
            return;
        }
        Player killer = dead.getKiller();
        if (killer == null) {
            return;
        }
        if (this.expUseTables) {
            this.addExp(killer, (Entity)dead);
        } else {
            double exp = this.balanceExp(killer, (Entity)dead, e.getDroppedExp());
            this.addExp(killer, (int)exp, EntityStats.getEntityName((Entity)dead), ExpSource.MOB_KILL);
        }
    }
}

