/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.eval.Evaluator;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.RatedItem;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemLevelRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemModuleRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemTierRequirement;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemTypeRequirement;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.divinity.stats.tiers.Tiered;
import studio.magemonkey.divinity.utils.LoreUT;

public abstract class LeveledItem
extends ModuleItem
implements Tiered {
    protected Tier tier;
    protected int levelMin;
    protected int levelMax;
    protected TreeMap<Integer, String[]> targetItemLevels;
    protected String[] targetItemTypes;
    protected String[] targetItemModules;
    protected String targetTier;

    @Deprecated
    public LeveledItem(@NotNull Divinity plugin, String path, QModuleDrop<?> module) throws InvalidConfigurationException {
        super(plugin, path, module);
    }

    public LeveledItem(@NotNull Divinity plugin, @NotNull JYML cfg, @NotNull QModuleDrop<?> module) {
        super(plugin, cfg, module);
        this.updateConfig(cfg);
        this.validateTier(cfg);
        this.name = this.getTier().format(this.name);
        this.processLore(cfg, module);
        int levelMin = cfg.getInt("level.min", 1);
        int levelMax = cfg.getInt("level.max", 1);
        this.levelMin = Math.min(levelMin, levelMax);
        this.levelMax = Math.max(levelMin, levelMax);
        this.targetItemLevels = new TreeMap();
        for (String rLvl : cfg.getSection("target-requirements.level")) {
            String raw;
            int itemLvl = StringUT.getInteger((String)rLvl, (int)-1);
            if (itemLvl <= 0 || (raw = cfg.getString("target-requirements.level." + rLvl)) == null || raw.isEmpty()) continue;
            this.targetItemLevels.put(itemLvl, raw.split(":"));
        }
        List types = cfg.getStringList("target-requirements.type");
        types.replaceAll(String::toLowerCase);
        if (!types.contains("*")) {
            this.targetItemTypes = types.toArray(new String[types.size()]);
        }
        List modules = cfg.getStringList("target-requirements.module");
        modules.replaceAll(String::toLowerCase);
        if (!modules.contains("*")) {
            this.targetItemModules = modules.toArray(new String[modules.size()]);
        }
        this.targetTier = cfg.getString("target-requirements.tier", "");
        cfg.saveChanges();
    }

    private void validateTier(JYML cfg) {
        this.tier = Config.getTier(cfg.getString("tier", "default"));
        if (this.tier == null) {
            throw new IllegalArgumentException("Invalid Tier provided! Module Item must have valid Tier!");
        }
    }

    @Override
    protected String applyLoreReplacements(String lore) {
        return this.getTier().format(lore);
    }

    @Override
    protected void processLore(@NotNull JYML cfg, @NotNull QModuleDrop<?> module) {
        this.validateTier(cfg);
        super.processLore(cfg, module);
    }

    @Override
    protected void save(@NotNull JYML cfg) {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    @NotNull
    public QModuleDrop<?> getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public final ItemStack create() {
        return this.create(-1);
    }

    private void updateConfig(@NotNull JYML cfg) {
        cfg.addMissing("tier", (Object)"default");
        cfg.addMissing("level.min", (Object)1);
        cfg.addMissing("level.max", (Object)1);
        if (!cfg.contains("target-requirements")) {
            cfg.addMissing("target-requirements.type", Arrays.asList("*"));
            cfg.addMissing("target-requirements.level.1", (Object)0);
            cfg.addMissing("target-requirements.module", Arrays.asList("*"));
            if (this instanceof SocketItem) {
                cfg.addMissing("target-requirements.socket", (Object)"default");
            }
        }
        cfg.saveChanges();
    }

    @Override
    @NotNull
    public Tier getTier() {
        return this.tier;
    }

    public int getMinLevel() {
        return this.levelMin;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    protected final int[] getTargetLevelRequirement(int itemLvl) {
        Map.Entry<Integer, String[]> e = this.targetItemLevels.floorEntry(itemLvl);
        if (e == null) {
            return null;
        }
        String[] both = e.getValue();
        int[] values = this.doMathExpression(itemLvl, both);
        if (values[0] <= 0) {
            if (values[1] > 0) {
                values[0] = 1;
            } else {
                return null;
            }
        }
        return values;
    }

    protected final int[] doMathExpression(int itemLvl, @NotNull String[] both) {
        int[] values = new int[2];
        for (int i = 0; i < both.length; ++i) {
            String str = both[i].replace("%ITEM_LEVEL%", String.valueOf(itemLvl)).trim();
            String[] intSplit = str.split("~");
            double val1 = Evaluator.eval((String)intSplit[0], (int)1);
            double val2 = intSplit.length >= 2 ? Evaluator.eval((String)intSplit[1], (int)1) : val1;
            double min = Math.min(val1, val2);
            double max = Math.max(val1, val2);
            values[i] = (int)Rnd.getDouble((double)min, (double)max);
        }
        if (values[1] <= 0) {
            values[1] = values[0];
        }
        return values;
    }

    @NotNull
    public ItemStack create(int lvl) {
        return this.build(this.validateLevel(lvl));
    }

    @NotNull
    protected ItemStack build(int lvl) {
        return this.build(null, lvl);
    }

    @NotNull
    protected ItemStack build(@Nullable ItemStack item, int lvl) {
        item = item == null ? super.build() : super.build(item);
        ItemStats.setId(item, this.getId());
        ItemStats.setModule(item, this.getModule().getId());
        ItemStats.setLevel(item, this.validateLevel(lvl));
        if (!(this instanceof RatedItem)) {
            this.replacePlaceholders(item);
        }
        return item;
    }

    protected final int validateLevel(int lvl) {
        if (lvl == -1) {
            lvl = Rnd.get((int)this.getMinLevel(), (int)this.getMaxLevel());
        } else if (lvl > this.getMaxLevel()) {
            lvl = this.getMaxLevel();
        } else if (lvl < this.getMinLevel()) {
            lvl = this.getMinLevel();
        }
        return lvl;
    }

    protected void replacePlaceholders(@NotNull ItemStack item) {
        ItemTierRequirement tierRequirement;
        Tier tier;
        ItemModuleRequirement reqMod;
        ItemTypeRequirement reqType;
        ItemLevelRequirement reqLevel;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        int level = ItemStats.getLevel(item);
        int sucRate = ItemStats.getSocketRate(item);
        String sLevel = String.valueOf(level);
        String sLevelRom = NumberUT.toRoman((int)level);
        String sSucRate = String.valueOf(sucRate);
        String name = meta.getDisplayName().replace("%ITEM_SUCCESS_RATE%", sSucRate).replace("%ITEM_LEVEL_ROMAN%", sLevelRom).replace("%ITEM_LEVEL%", sLevel);
        meta.setDisplayName(name);
        List metaLore = meta.getLore();
        List lore = metaLore != null ? metaLore : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = ((String)lore.get(i)).replace("%ITEM_SUCCESS_RATE%", sSucRate).replace("%ITEM_LEVEL_ROMAN%", sLevelRom).replace("%ITEM_LEVEL%", sLevel);
            lore.set(i, StringUT.color((String)line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        int[] reqLevels = this.getTargetLevelRequirement(level);
        if (reqLevels != null && (reqLevel = ItemRequirements.getItemRequirement(ItemLevelRequirement.class)) != null && reqLevel.hasPlaceholder(item)) {
            reqLevel.add(item, reqLevels, -1);
        }
        if (!ArrayUtils.isEmpty((Object[])this.targetItemTypes) && (reqType = ItemRequirements.getItemRequirement(ItemTypeRequirement.class)) != null && reqType.hasPlaceholder(item)) {
            reqType.add(item, this.targetItemTypes, -1);
        }
        if (!ArrayUtils.isEmpty((Object[])this.targetItemModules) && (reqMod = ItemRequirements.getItemRequirement(ItemModuleRequirement.class)) != null && reqMod.hasPlaceholder(item)) {
            reqMod.add(item, this.targetItemModules, -1);
        }
        if (this.targetTier != null && !this.targetTier.isEmpty() && (tier = Config.getTier(this.targetTier)) != null && (tierRequirement = ItemRequirements.getItemRequirement(ItemTierRequirement.class)) != null && tierRequirement.hasPlaceholder(item)) {
            tierRequirement.add(item, this.targetTier, -1);
        }
        LoreUT.replacePlaceholder(item, "%TARGET_LEVEL%", null);
        LoreUT.replacePlaceholder(item, "%TARGET_TYPE%", null);
        LoreUT.replacePlaceholder(item, "%TARGET_MODULE%", null);
        LoreUT.replacePlaceholder(item, "%TARGET_TIER%", null);
    }
}

