/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external.mimic;

import java.util.Objects;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.endlesscode.mimic.level.BukkitLevelSystem;
import ru.endlesscode.mimic.level.ExpLevelConverter;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.hooks.external.mimic.DivinityExpLevelConverter;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;

public class DivinityLevelSystem
extends BukkitLevelSystem {
    private static final String ID = "divinity";
    private final ClassManager classManager = DivinityAPI.getModuleManager().getClassManager();

    public DivinityLevelSystem(@NotNull Player player) {
        super(player);
    }

    @NotNull
    public ExpLevelConverter getConverter() {
        return new DivinityExpLevelConverter(this.getPlayer());
    }

    public int getLevel() {
        return this.getClassData().getLevel();
    }

    public void setLevel(int level) {
        this.getClassData().setLevel(level);
    }

    public double getExp() {
        return this.getClassData().getExp();
    }

    public void setExp(double exp) {
        double allowedExp = Math.min(Math.max(0.0, exp), this.getExpToNextLevel());
        this.getClassData().setExp((int)Math.round(allowedExp));
    }

    public double getExpToNextLevel() {
        return this.getClassData().getExpToUp(false);
    }

    public double getTotalExpToNextLevel() {
        return this.getClassData().getExpToUp(true);
    }

    public void takeExp(double expAmount) {
        this.giveExp(-Math.min(expAmount, this.getTotalExp()));
    }

    public void giveExp(double expAmount) {
        this.getClassData().addExp((int)Math.round(expAmount));
    }

    private UserClassData getClassData() {
        return Objects.requireNonNull(this.classManager.getUserData(this.getPlayer()));
    }

    public static class Provider
    implements BukkitLevelSystem.Provider {
        @NotNull
        public BukkitLevelSystem getSystem(@NotNull Player player) {
            return new DivinityLevelSystem(player);
        }
    }
}

