/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.data.api.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import studio.magemonkey.divinity.modules.list.classes.ComboManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserSkillData;

public class SkillDataSerializer
implements JsonSerializer<UserSkillData>,
JsonDeserializer<UserSkillData> {
    public JsonElement serialize(UserSkillData data, Type type, JsonSerializationContext contex) {
        JsonObject o = new JsonObject();
        o.addProperty("id", data.getId());
        o.addProperty("lvl", (Number)data.getLevel());
        o.add("combo", contex.serialize((Object)data.getCombo()));
        return o;
    }

    public UserSkillData deserialize(JsonElement json, Type type, JsonDeserializationContext contex) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        String id = o.get("id").getAsString();
        int lvl = o.get("lvl").getAsInt();
        ComboManager.ComboKey[] combo = new ComboManager.ComboKey[ComboManager.ComboKey.values().length];
        JsonElement eCombo = o.get("combo");
        if (eCombo != null) {
            JsonArray jCombo = eCombo.getAsJsonArray();
            combo = new ComboManager.ComboKey[jCombo.size()];
            int i = 0;
            for (JsonElement e : jCombo) {
                combo[i++] = (ComboManager.ComboKey)((Object)contex.deserialize(e, ComboManager.ComboKey.class));
            }
        }
        return new UserSkillData(id, lvl, combo);
    }
}

