/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.codex.util.TimeUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.manager.effects.buffs.SavedBuff;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class BuffCommand
extends ISubCommand<Divinity> {
    public BuffCommand(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, new String[]{"buff"}, "quantumrpg.admin");
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Command_Buff_Desc.getMsg();
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Command_Buff_Usage.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (!Arrays.asList(args).contains("-r")) {
            list.add("-r");
        } else {
            ArrayList<String> temp = new ArrayList<String>(Arrays.asList(args));
            temp.remove("-r");
            args = temp.toArray(new String[0]);
            --i;
        }
        if (i == 1) {
            list.addAll(PlayerUT.getPlayerNames());
        } else if (i == 2) {
            list.addAll(Arrays.asList("damage", "defense", "stat"));
        } else if (i == 3) {
            if (args[2].equalsIgnoreCase("damage")) {
                ItemStats.getDamages().forEach(d -> list.add(d.getId()));
            } else if (args[2].equalsIgnoreCase("defense")) {
                ItemStats.getDefenses().forEach(d -> list.add(d.getId()));
            } else if (args[2].equalsIgnoreCase("stat")) {
                ItemStats.getStats().forEach(d -> list.add(d.getId()));
            }
        } else if (i == 4) {
            list.addAll(Arrays.asList("<amount>", "10", "25%"));
        } else if (i == 5) {
            list.addAll(Arrays.asList("<duration>", "60", "300"));
        }
        return list;
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        TypedStat.Type statType;
        Player player;
        if (args.length != 6 && args.length != 7) {
            this.printUsage(sender);
            return;
        }
        boolean replace = false;
        if (Arrays.asList(args).contains("-r")) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
            list.remove("-r");
            args = list.toArray(new String[0]);
            replace = true;
        }
        if ((player = ((Divinity)this.plugin).getServer().getPlayer(args[1])) == null) {
            this.errPlayer(sender);
            return;
        }
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            this.errPlayer(sender);
            return;
        }
        Set<SavedBuff> userBuffs = null;
        String type = args[2];
        String statId = args[3];
        boolean isModifier = args[4].endsWith("%");
        double amount = this.getNumD(sender, args[4].replace("%", ""), 0.0);
        int seconds = this.getNumI(sender, args[5], 0);
        if (seconds == 0) {
            return;
        }
        ItemLoreStat stat = null;
        if (type.equalsIgnoreCase("damage")) {
            stat = ItemStats.getDamageById(statId);
            userBuffs = user.getActiveProfile().getDamageBuffs();
        } else if (type.equalsIgnoreCase("defense")) {
            stat = ItemStats.getDefenseById(statId);
            userBuffs = user.getActiveProfile().getDefenseBuffs();
        } else if (type.equalsIgnoreCase("stat") && (statType = TypedStat.Type.getByName(statId)) != null) {
            stat = (ItemLoreStat)((Object)ItemStats.getStat(statType));
            userBuffs = user.getActiveProfile().getItemStatBuffs();
        }
        if (stat == null || userBuffs == null) {
            sender.sendMessage("Invalid stat id!");
            return;
        }
        if (replace) {
            userBuffs.removeIf(buff -> buff.getStatId().equals(statId));
        }
        SavedBuff buff2 = new SavedBuff(stat, amount, isModifier, seconds);
        userBuffs.add(buff2);
        ((Divinity)this.plugin).lang().Command_Buff_Done.replace("%time%", (Object)TimeUT.formatTime((long)((long)seconds * 1000L))).replace("%stat%", (Object)stat.getName()).replace("%amount%", (Object)args[4]).replace("%player%", (Object)player.getName()).send(sender);
        ((Divinity)this.plugin).lang().Command_Buff_Get.replace("%time%", (Object)TimeUT.formatTime((long)((long)seconds * 1000L))).replace("%stat%", (Object)stat.getName()).replace("%amount%", (Object)args[4]).send((CommandSender)player);
    }
}

