/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.api.event;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import lombok.Generated;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.events.ICancellableEvent;
import studio.magemonkey.divinity.manager.damage.DamageMeta;
import studio.magemonkey.divinity.modules.list.arrows.ArrowManager;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public abstract class DivinityDamageEvent
extends ICancellableEvent {
    protected LivingEntity victim;
    protected LivingEntity damager;
    protected Projectile projectile;
    protected Map<DamageAttribute, Double> damageMap;
    protected Map<DefenseAttribute, Double> defenseMap;
    protected Map<TypedStat.Type, Double> damagerItemStatsMap;
    protected DamageMeta meta;
    protected EntityDamageEvent eventOrig;
    protected boolean cancelled = false;
    protected boolean exempt = false;

    public DivinityDamageEvent(@NotNull LivingEntity zertva, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
        this(zertva, null, eventOrig, meta);
    }

    public DivinityDamageEvent(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
        this(zertva, damager, null, eventOrig, meta);
    }

    public DivinityDamageEvent(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
        this.victim = zertva;
        this.damager = damager;
        this.projectile = projectile;
        this.damageMap = new HashMap<DamageAttribute, Double>();
        this.defenseMap = new HashMap<DefenseAttribute, Double>();
        this.damagerItemStatsMap = new HashMap<TypedStat.Type, Double>();
        this.meta = meta;
        this.eventOrig = eventOrig;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
        this.eventOrig.setCancelled(this.isCancelled());
    }

    @NotNull
    public final EntityDamageEvent.DamageCause getCause() {
        return this.getOriginalEvent().getCause();
    }

    @NotNull
    public EntityDamageEvent getOriginalEvent() {
        return this.eventOrig;
    }

    @NotNull
    public LivingEntity getVictim() {
        return this.victim;
    }

    @Nullable
    public LivingEntity getDamager() {
        return this.damager;
    }

    @NotNull
    public DamageMeta getDamageMeta() {
        return this.meta;
    }

    @NotNull
    public Map<DamageAttribute, Double> getDamageMap() {
        return this.damageMap;
    }

    public void computeDamage(@NotNull DoubleUnaryOperator operator) {
        this.computeDamage(this.damageMap.keySet(), operator);
    }

    public void computeDamage(@NotNull DamageAttribute damage, @NotNull DoubleUnaryOperator operator) {
        this.computeDamage(Sets.newHashSet((Object[])new DamageAttribute[]{damage}), operator);
    }

    public void computeDamage(@NotNull Collection<DamageAttribute> damages, @NotNull DoubleUnaryOperator operator) {
        damages.forEach(dmgApp -> this.damageMap.compute((DamageAttribute)dmgApp, (dmgApp2, dmg) -> operator.applyAsDouble(this.damageMap.computeIfAbsent((DamageAttribute)dmgApp, dmg2 -> 0.0))));
        this.damageMap.values().removeIf(dmg -> dmg == 0.0);
    }

    @NotNull
    public Map<DefenseAttribute, Double> getDefenseMap() {
        return this.defenseMap;
    }

    public void computeDefense(@NotNull DoubleUnaryOperator operator) {
        this.computeDefense(this.defenseMap.keySet(), operator);
    }

    public void computeDefense(@NotNull DefenseAttribute defense, @NotNull DoubleUnaryOperator operator) {
        this.computeDefense(Sets.newHashSet((Object[])new DefenseAttribute[]{defense}), operator);
    }

    public void computeDefense(@NotNull Collection<DefenseAttribute> defenses, @NotNull DoubleUnaryOperator operator) {
        defenses.forEach(defApp -> this.defenseMap.compute((DefenseAttribute)defApp, (defKey, defVal) -> operator.applyAsDouble(this.defenseMap.computeIfAbsent((DefenseAttribute)defApp, defVal2 -> 0.0))));
        this.defenseMap.values().removeIf(dmg -> dmg == 0.0);
    }

    @NotNull
    public Map<TypedStat.Type, Double> getDamagerItemStatsMap() {
        return this.damagerItemStatsMap;
    }

    public double getDamagerItemStat(@NotNull TypedStat.Type type) {
        return this.getDamagerItemStatsMap().getOrDefault((Object)type, 0.0);
    }

    @Nullable
    public ItemStack getWeapon() {
        return this.getDamageMeta().getWeapon();
    }

    @Nullable
    public Projectile getProjectile() {
        return this.projectile;
    }

    @Nullable
    public ArrowManager.QArrow getArrow() {
        return this.getDamageMeta().getArrow();
    }

    public final boolean isProjectile() {
        return this.getProjectile() != null;
    }

    @NotNull
    public final EntityStats getVictimStats() {
        return EntityStats.get(this.getVictim());
    }

    @Nullable
    public final EntityStats getDamagerStats() {
        if (this.getDamager() == null) {
            return null;
        }
        return EntityStats.get(this.damager);
    }

    @Generated
    public boolean isExempt() {
        return this.exempt;
    }

    @Generated
    public void setExempt(boolean exempt) {
        this.exempt = exempt;
    }

    public static class Exit
    extends DivinityDamageEvent {
        public Exit(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
            super(zertva, damager, projectile, eventOrig, meta);
        }
    }

    public static class Dodge
    extends DivinityDamageEvent {
        public Dodge(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
            super(zertva, damager, projectile, eventOrig, meta);
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    public static class Pre
    extends DivinityDamageEvent {
        public Pre(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta) {
            super(zertva, damager, projectile, eventOrig, meta);
        }
    }

    public static class BeforeScale
    extends DivinityDamageEvent {
        public BeforeScale(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull Map<DamageAttribute, Double> damageMap, @NotNull Map<DefenseAttribute, Double> defenseMap, @NotNull Map<TypedStat.Type, Double> statsMap, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta, boolean exempt) {
            super(zertva, damager, projectile, eventOrig, meta);
            this.damageMap = damageMap;
            this.defenseMap = defenseMap;
            this.damagerItemStatsMap = statsMap;
            this.exempt = exempt;
        }
    }

    public static class Start
    extends DivinityDamageEvent {
        public Start(@NotNull LivingEntity zertva, @Nullable LivingEntity damager, @Nullable Projectile projectile, @NotNull Map<DamageAttribute, Double> damageMap, @NotNull Map<DefenseAttribute, Double> defenseMap, @NotNull Map<TypedStat.Type, Double> statsMap, @NotNull EntityDamageEvent eventOrig, @NotNull DamageMeta meta, boolean exempt) {
            super(zertva, damager, projectile, eventOrig, meta);
            this.damageMap = damageMap;
            this.defenseMap = defenseMap;
            this.damagerItemStatsMap = statsMap;
            this.exempt = exempt;
        }
    }
}

