/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.utils.LoreUT;

public abstract class DuplicableItemLoreStat<Z>
extends ItemLoreStat<Z> {
    public DuplicableItemLoreStat(@NotNull String id, @NotNull String name, @NotNull String format, @NotNull String placeholder, @NotNull String uniqueTag, @NotNull PersistentDataType<?, Z> dataType) {
        super(id, name, format, placeholder, uniqueTag, dataType);
    }

    @NotNull
    protected final List<NamespacedKey> getKeys(int index) {
        ArrayList<NamespacedKey> indexedKeys = new ArrayList<NamespacedKey>();
        for (NamespacedKey key : this.keys) {
            indexedKeys.add(NamespacedKey.fromString((String)(key.toString() + index)));
        }
        return indexedKeys;
    }

    @NotNull
    protected final NamespacedKey getKey(int index) {
        return Objects.requireNonNull(NamespacedKey.fromString((String)(((NamespacedKey)this.keys.get(0)).toString() + index)));
    }

    @Override
    public boolean add(@NotNull ItemStack item, @NotNull Z value, int line) {
        return this.add(item, value, -1, line);
    }

    public boolean add(@NotNull ItemStack item, @NotNull Z value, int index, int line) {
        String format;
        PersistentDataContainer container;
        ItemMeta meta;
        if (index < 0 && value instanceof StatBonus) {
            StatBonus statBonus = (StatBonus)value;
            if (statBonus.isBaseStat() && (meta = item.getItemMeta()) != null) {
                container = meta.getPersistentDataContainer();
                for (NamespacedKey key : this.keys) {
                    if (!container.has(key, PersistentDataType.DOUBLE) && !container.has(key, DataUT.DOUBLE_ARRAY)) continue;
                    line = ItemUT.getLoreIndex((ItemStack)item, (String)key.getKey());
                    index = 0;
                    container.remove(key);
                    item.setItemMeta(meta);
                    break;
                }
            }
            if (index < 0) {
                int size = this.getAmount(item);
                for (int i = 0; i < size; ++i) {
                    StatBonus existing = (StatBonus)this.getRaw(item, i);
                    if (existing == null || !Objects.equals(existing.getCondition(), statBonus.getCondition())) continue;
                    index = i;
                    break;
                }
            }
        }
        if (index < 0) {
            index = this.getAmount(item);
        }
        if (line < 0) {
            line = this.getLoreIndex(item, index);
        }
        item = this.preparePlaceholder(item, index, line);
        item = this.remove(item, index, true);
        String string = format = this instanceof DynamicStat ? ((DynamicStat)((Object)this)).getFormat(null, item, value) : this.getFormat(item, value);
        if (format.isEmpty()) {
            LoreUT.replacePlaceholder(item, this.getPlaceholder(), null);
            for (NamespacedKey key : this.keys) {
                ItemUT.delLoreTag((ItemStack)item, (String)(key.getKey() + index));
            }
        } else {
            LoreUT.replacePlaceholder(item, this.getPlaceholder(), format);
            meta = item.getItemMeta();
            if (meta == null) {
                return false;
            }
            container = meta.getPersistentDataContainer();
            container.set(this.getKey(index), this.dataType, value);
            item.setItemMeta(meta);
            ItemUT.addLoreTag((ItemStack)item, (String)this.getMetaId(item, index), (String)format);
        }
        ItemStats.updateVanillaAttributes(item, null);
        return !format.isEmpty();
    }

    @NotNull
    public final ItemStack remove(@NotNull ItemStack item, int index, boolean onlyTag) {
        List lore;
        int pos;
        ItemMeta meta;
        if (index < 0) {
            index = this.getAmount(item) - 1;
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        if (!onlyTag && (pos = this.getLoreIndex(item, index)) >= 0 && (lore = meta.getLore()) != null) {
            lore.remove(pos);
            meta.setLore(lore);
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.getKeys(index)) {
            if (!container.has(key, this.dataType)) continue;
            container.remove(key);
        }
        item.setItemMeta(meta);
        for (NamespacedKey key : this.keys) {
            ItemUT.delLoreTag((ItemStack)item, (String)(key.getKey() + index));
        }
        if (!onlyTag) {
            this.reorderTags(item);
        }
        return item;
    }

    private final void reorderTags(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        ArrayList valuesLeft = new ArrayList();
        container.getKeys().stream().filter(namespacedKey -> {
            for (NamespacedKey key : this.keys) {
                if (!namespacedKey.toString().startsWith(key.toString()) || !container.has(namespacedKey, this.dataType)) continue;
                return true;
            }
            return false;
        }).forEach(namespacedKey -> {
            Object val = container.get(namespacedKey, this.dataType);
            if (val != null) {
                valuesLeft.add(val);
            }
        });
        for (int newIndex = 0; newIndex < valuesLeft.size(); ++newIndex) {
            container.set(this.getKey(newIndex), this.dataType, valuesLeft.get(newIndex));
        }
        item.setItemMeta(meta);
    }

    @Nullable
    public final Z getRaw(ItemStack item, int index) {
        return this.getRaw(item.getItemMeta(), index);
    }

    @Nullable
    public final Z getRaw(ItemMeta meta, int index) {
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.getKeys(index)) {
            if (!container.has(key, this.dataType)) continue;
            return (Z)container.get(key, this.dataType);
        }
        return null;
    }

    @NotNull
    public final List<Z> getAllRaw(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return List.of();
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.getKeys().stream().filter(namespacedKey -> {
            for (NamespacedKey key : this.keys) {
                if (!namespacedKey.toString().startsWith(key.toString()) || !container.has(namespacedKey, this.dataType)) continue;
                return true;
            }
            return false;
        }).map(key -> container.get(key, this.dataType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public final int getAmount(@NotNull ItemStack item) {
        return this.getAmount(item.getItemMeta());
    }

    public final int getAmount(ItemMeta meta) {
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (int)container.getKeys().stream().filter(namespacedKey -> {
            for (NamespacedKey key : this.keys) {
                if (!namespacedKey.toString().startsWith(key.toString()) || !container.has(namespacedKey, this.dataType)) continue;
                return true;
            }
            return false;
        }).count();
    }

    public final int getLoreIndex(@NotNull ItemStack item, int index) {
        if (index < 0) {
            return -1;
        }
        int count = 0;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return -1;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return -1;
        }
        for (int i = 0; i < lore.size(); ++i) {
            NamespacedKey key;
            int found = 0;
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext() && (found = ItemUT.getLoreIndex((ItemStack)item, (String)((key = (NamespacedKey)iterator.next()).getKey() + i))) < 0 && (found = ItemUT.getLoreIndex((ItemStack)item, (String)key.getKey())) < 0) {
            }
            if (found < 0 || index != count++) continue;
            return found;
        }
        return -1;
    }

    @NotNull
    protected final ItemStack preparePlaceholder(@NotNull ItemStack item, int index, int line) {
        if (!this.hasPlaceholder(item)) {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            int pos = this.getLoreIndex(item, index);
            LoreUT.addOrReplace(lore, pos, line, this.getPlaceholder());
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }
}

