/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.meta.NBTAttribute;
import studio.magemonkey.codex.compat.Compat;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.util.EntityUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.event.EntityStatsBonusUpdateEvent;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.damage.DamageMeta;
import studio.magemonkey.divinity.manager.effects.IEffect;
import studio.magemonkey.divinity.manager.effects.IEffectType;
import studio.magemonkey.divinity.manager.effects.IExpirableEffect;
import studio.magemonkey.divinity.manager.effects.IPeriodicEffect;
import studio.magemonkey.divinity.manager.effects.main.AdjustStatEffect;
import studio.magemonkey.divinity.manager.effects.main.ResistEffect;
import studio.magemonkey.divinity.modules.list.arrows.ArrowManager;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.essences.EssencesManager;
import studio.magemonkey.divinity.modules.list.runes.RuneManager;
import studio.magemonkey.divinity.modules.list.sets.SetManager;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.utils.ItemUtils;

public class EntityStats {
    private static final Map<String, EntityStats> STATS = Collections.synchronizedMap(new HashMap());
    private static final TypedStat.Type[] ATTRIBUTE_BONUS_STATS = new TypedStat.Type[]{TypedStat.Type.MAX_HEALTH, TypedStat.Type.ATTACK_SPEED, TypedStat.Type.MOVEMENT_SPEED};
    private static final NBTAttribute[] ATTRIBUTE_BONUS_NBT = new NBTAttribute[]{NBTAttribute.MAX_HEALTH, NBTAttribute.ATTACK_SPEED, NBTAttribute.MOVEMENT_SPEED};
    private static final double DEFAULT_ATTACK_POWER = 1.0;
    private final Divinity plugin;
    private final Player player;
    private final boolean isNPC;
    private final EntityEquipment equipment;
    private final List<ItemStack> inventory;
    private final Map<PotionEffectType, PotionEffect> permaEffects;
    private final Map<ItemLoreStat<?>, List<BiFunction<Boolean, Double, Double>>> bonuses;
    private final Set<IEffect> effects;
    private LivingEntity entity;
    private DamageMeta damageMeta;
    private ArrowManager.QArrow arrowBonus;
    private int arrowLevel;
    private double atkPower;
    private boolean aoeIgnore;

    EntityStats(Divinity plugin, @NotNull LivingEntity entity) {
        this.plugin = plugin;
        this.entity = entity;
        this.player = this.entity instanceof Player ? (Player)this.entity : null;
        this.isNPC = Hooks.isNPC((Entity)this.entity);
        this.permaEffects = Collections.synchronizedMap(new HashMap());
        this.equipment = entity.getEquipment();
        this.inventory = Collections.synchronizedList(new ArrayList());
        this.effects = Collections.synchronizedSet(new HashSet());
        this.bonuses = new HashMap();
        this.arrowBonus = null;
        this.arrowLevel = 0;
        this.atkPower = 1.0;
        this.aoeIgnore = false;
        if (this.isPlayer() && EngineCfg.COMBAT_REDUCE_PLAYER_HEALTH_BAR) {
            this.player.setHealthScaled(true);
            this.player.setHealthScale(20.0);
        }
    }

    public static void purge(@NotNull LivingEntity entity) {
        String uuid = entity.getUniqueId().toString();
        STATS.remove(uuid);
    }

    @NotNull
    public static synchronized Collection<EntityStats> getAll() {
        STATS.values().removeIf(stats -> !stats.entity.isValid() || stats.entity.isDead());
        return STATS.values();
    }

    @NotNull
    public static EntityStats get(@NotNull LivingEntity entity) {
        String uuid = entity.getUniqueId().toString();
        EntityStats eStats = STATS.computeIfAbsent(uuid, stats -> new EntityStats(Divinity.getInstance(), entity));
        eStats.updateHolder(entity);
        return eStats;
    }

    @NotNull
    public static String getEntityName(@NotNull Entity entity) {
        String cName;
        Projectile pp;
        ProjectileSource ps;
        String name = Divinity.getInstance().lang().getEnum((Enum)entity.getType());
        if (entity instanceof Projectile && (ps = (pp = (Projectile)entity).getShooter()) instanceof LivingEntity) {
            entity = (LivingEntity)ps;
        }
        if (entity instanceof Player) {
            name = entity.getName();
        } else if (entity instanceof LivingEntity && (cName = entity.getCustomName()) != null) {
            name = cName;
        }
        return name;
    }

    public static double getEntityMaxHealth(@NotNull LivingEntity entity) {
        AttributeInstance ai = entity.getAttribute(VersionManager.getNms().getAttribute("MAX_HEALTH"));
        if (ai == null) {
            return 0.0;
        }
        return ai.getValue();
    }

    public void handleDeath() {
        if (this.isPlayer()) {
            for (IEffect e : new HashSet<IEffect>(this.effects)) {
                if (!e.resetOnDeath()) continue;
                this.removeEffect(e);
            }
            this.inventory.clear();
            this.permaEffects.clear();
            this.bonuses.clear();
            this.damageMeta = null;
            this.aoeIgnore = false;
            this.updateBonusAttributes();
        } else {
            this.purge();
        }
    }

    public void purge() {
        EntityStats.purge(this.entity);
    }

    @Nullable
    public DamageMeta getLastDamageMeta() {
        return this.damageMeta;
    }

    public void setLastDamageMeta(@Nullable DamageMeta meta) {
        this.damageMeta = meta;
    }

    private void updateHolder(@NotNull LivingEntity valid) {
        if (this.entity == null || !this.entity.equals((Object)valid)) {
            this.entity = valid;
        }
    }

    public final boolean isPlayer() {
        return this.player != null;
    }

    public final boolean isNPC() {
        return this.isNPC;
    }

    public double getAttackPower() {
        return this.isNPC() ? 1.0 : this.atkPower;
    }

    public void setAttackPower(double modifier) {
        this.atkPower = modifier;
    }

    public double getAttackPowerModifier() {
        double power = this.getAttackPower();
        if (power < 1.0) {
            double mod = EngineCfg.COMBAT_DAMAGE_MODIFIER_FOR_COOLDOWN;
            return mod != 1.0 ? mod : power;
        }
        return power;
    }

    public void updateAttackPower() {
        if (this.isPlayer() && !this.isNPC()) {
            this.setAttackPower(this.player.getAttackCooldown());
        }
    }

    public boolean isIgnoreAOE() {
        return this.aoeIgnore;
    }

    public void setIgnoreAOE(boolean aoeIgnore) {
        this.aoeIgnore = aoeIgnore;
    }

    public void addEffect(@NotNull IEffect effect) {
        this.effects.add(effect);
        this.updateBonusAttributes();
    }

    public void removeEffect(@NotNull IEffect effect) {
        effect.clear();
        this.effects.remove(effect);
    }

    public boolean hasEffect(@NotNull IEffectType type) {
        return this.getActiveEffects(true).stream().anyMatch(effect -> effect.isType(type));
    }

    public double getEffectResist(@NotNull IEffectType type, boolean safe) {
        return this.getActiveEffects(true).stream().filter(effect -> effect instanceof ResistEffect).mapToDouble(effect -> {
            double resist = ((ResistEffect)effect).getResist(type);
            if (resist != 0.0) {
                effect.trigger(safe);
            }
            return resist;
        }).sum();
    }

    @NotNull
    public synchronized Set<IEffect> getActiveEffects(boolean update) {
        HashSet<IEffect> set = new HashSet<IEffect>();
        HashSet<IEffect> toRemove = new HashSet<IEffect>();
        for (IEffect e : new HashSet<IEffect>(this.effects)) {
            IPeriodicEffect per;
            IExpirableEffect exp;
            if (e.isExpired()) {
                toRemove.add(e);
                continue;
            }
            if (e instanceof IExpirableEffect && (exp = (IExpirableEffect)e) instanceof IPeriodicEffect && !(per = (IPeriodicEffect)exp).isReady()) continue;
            set.add(e);
        }
        toRemove.forEach(this::removeEffect);
        if (update) {
            this.updateBonusAttributes();
        }
        return set;
    }

    public void triggerEffects() {
        this.getActiveEffects(true).forEach(effect -> effect.trigger(false));
    }

    public void triggerVisualEffects() {
        EssencesManager essencesManager = this.plugin.getModuleCache().getEssenceManager();
        if (essencesManager == null) {
            return;
        }
        for (ItemStack item : this.getEquipment()) {
            for (Map.Entry ee : essencesManager.getItemSockets(item)) {
                EssencesManager.Essence essence = (EssencesManager.Essence)ee.getKey();
                essence.getEffect().play(this.entity, ee.getValue());
            }
        }
    }

    public void triggerPotionEffects() {
        SetManager sets;
        this.permaEffects.clear();
        RuneManager runes = this.plugin.getModuleCache().getRuneManager();
        if (runes != null) {
            runes.addRuneEffects(this.entity);
        }
        if ((sets = this.plugin.getModuleCache().getSetManager()) != null) {
            sets.addSetPotionEffects(this.entity);
        }
        for (PotionEffect pe : this.getPermaPotionEffects()) {
            PotionEffectType type = pe.getType();
            PotionEffect has = this.entity.getPotionEffect(type);
            if (has != null && (has.getAmplifier() > pe.getAmplifier() || has.getAmplifier() == pe.getAmplifier() && has.getDuration() > pe.getDuration())) continue;
            this.entity.addPotionEffect(pe);
        }
    }

    @NotNull
    public synchronized Set<PotionEffect> getPermaPotionEffects() {
        return new HashSet<PotionEffect>(this.permaEffects.values());
    }

    public synchronized void addPermaPotionEffect(@NotNull PotionEffect effect) {
        PotionEffect pe2;
        PotionEffectType key = effect.getType();
        int lvl = effect.getAmplifier();
        if (this.permaEffects.containsKey(key) && lvl <= (pe2 = this.permaEffects.get(key)).getAmplifier()) {
            return;
        }
        this.permaEffects.put(key, effect);
    }

    public void removePermaPotionEffect(@NotNull PotionEffectType key) {
        this.permaEffects.remove(key);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        if (this.equipment == null) {
            return new ItemStack(Material.AIR);
        }
        return this.equipment.getItemInMainHand();
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        if (this.equipment == null) {
            return new ItemStack(Material.AIR);
        }
        return this.equipment.getItemInOffHand();
    }

    @NotNull
    public List<ItemStack> getArmor() {
        List<ItemStack> equip = this.getEquipment();
        ItemStack[] hands = new ItemStack[]{this.getItemInMainHand(), this.getItemInOffHand()};
        equip.removeIf(item -> item.isSimilar(hands[0]) || item.isSimilar(hands[1]));
        return equip;
    }

    @NotNull
    public synchronized List<ItemStack> getEquipment() {
        return new ArrayList<ItemStack>(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        ItemStack[] armor = new ItemStack[]{};
        if (this.equipment != null) {
            armor = this.equipment.getArmorContents();
        }
        Arrays.stream(armor).filter(item -> item != null && !ItemUT.isAir((ItemStack)item)).forEach(this.inventory::add);
        ItemStack main = this.getItemInMainHand();
        ItemStack off = this.getItemInOffHand();
        if (!(ItemUT.isAir((ItemStack)main) || ItemUtils.isArmor(main) && main.getType() != Material.SHIELD)) {
            this.inventory.add(main);
        }
        if (EngineCfg.ATTRIBUTES_EFFECTIVE_IN_OFFHAND || off.getType() == Material.SHIELD) {
            this.inventory.add(off);
        }
        if (this.isPlayer()) {
            this.inventory.removeIf(item -> item == null || !ItemUtils.canUse(item, this.player, false));
        }
    }

    public void updateAll() {
        if (!EngineCfg.ATTRIBUTES_EFFECTIVE_FOR_MOBS && !this.isPlayer()) {
            return;
        }
        this.updateInventory();
        this.updateBonus();
    }

    private void addBonus(@NotNull BonusMap bMap) {
        bMap.getBonuses().forEach((stat, func) -> this.bonuses.computeIfAbsent((ItemLoreStat<?>)stat, list -> new ArrayList()).add(func));
    }

    @NotNull
    public List<BiFunction<Boolean, Double, Double>> getBonuses(@NotNull ItemLoreStat<?> stat) {
        DivinityUser user;
        BiFunction<Boolean, Double, Double> arrowBif;
        BonusMap arrowBonus;
        ArrayList<BiFunction<Boolean, Double, Double>> bonuses = new ArrayList<BiFunction<Boolean, Double, Double>>(this.bonuses.computeIfAbsent(stat, list -> new ArrayList()));
        BonusMap bonusMap = arrowBonus = this.arrowBonus != null ? this.arrowBonus.getBonusMap(this.arrowLevel) : null;
        if (arrowBonus != null && (arrowBif = arrowBonus.getBonus(stat)) != null) {
            bonuses.add(arrowBif);
        }
        if (this.isPlayer() && !this.isNPC() && (user = (DivinityUser)this.plugin.getUserManager().getOrLoadUser(this.player)) != null) {
            UserProfile prof = user.getActiveProfile();
            bonuses.add(prof.getBuff(stat));
        }
        return bonuses;
    }

    private void updateBonus() {
        ClassManager m;
        this.bonuses.clear();
        SetManager set = this.plugin.getModuleCache().getSetManager();
        if (set != null) {
            set.getActiveSetBonuses(this.entity).forEach(this::addBonus);
        }
        if ((m = this.plugin.getModuleCache().getClassManager()) != null && this.isPlayer()) {
            m.getClassEntityStatsBonuses(this.player).forEach(this::addBonus);
        }
        this.updateBonusAttributes();
        double maxHealth = EntityStats.getEntityMaxHealth(this.entity);
        if (this.entity.getHealth() > maxHealth) {
            this.entity.setHealth(maxHealth);
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            EntityStatsBonusUpdateEvent statsEvent = new EntityStatsBonusUpdateEvent(this.entity, this);
            this.plugin.getPluginManager().callEvent((Event)statsEvent);
        });
    }

    private void purgeAttributeBonuses() {
        for (NBTAttribute nbt : ATTRIBUTE_BONUS_NBT) {
            AttributeInstance attr = this.entity.getAttribute(nbt.getAttribute());
            if (attr == null) continue;
            attr.getModifiers().stream().filter(mod -> {
                UUID uuid;
                try {
                    uuid = mod.getUniqueId();
                }
                catch (Exception e) {
                    String attKey = VersionManager.getCompat().getAttributeKey(mod);
                    try {
                        uuid = UUID.fromString(attKey.replace("minecraft:", ""));
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                }
                return uuid.equals(Compat.ATTRIBUTE_BONUS_UUID);
            }).collect(Collectors.toList()).forEach(arg_0 -> ((AttributeInstance)attr).removeModifier(arg_0));
        }
    }

    private void updateBonusAttributes() {
        for (int i = 0; i < ATTRIBUTE_BONUS_STATS.length; ++i) {
            TypedStat.Type statType = ATTRIBUTE_BONUS_STATS[i];
            NBTAttribute nbt = ATTRIBUTE_BONUS_NBT[i];
            TypedStat typedStat = ItemStats.getStat(statType);
            if (!(typedStat instanceof SimpleStat)) continue;
            SimpleStat stat = (SimpleStat)typedStat;
            List<BiFunction<Boolean, Double, Double>> bonuses = this.getBonuses(stat);
            double attBase = EntityUT.getAttributeBase((LivingEntity)this.entity, (Attribute)nbt.getAttribute());
            double value = BonusCalculator.SIMPLE_BONUS.apply(attBase, bonuses);
            value = this.getEffectBonus(stat, false).applyAsDouble(value);
            this.applyBonusAttribute(nbt, value);
        }
    }

    private void applyBonusAttribute(@NotNull NBTAttribute att, double value) {
        AttributeInstance attInst = this.entity.getAttribute(att.getAttribute());
        if (attInst == null) {
            return;
        }
        if (att == NBTAttribute.MOVEMENT_SPEED) {
            value = 0.1 * (1.0 + value / 100.0) - 0.1;
        } else if (att == NBTAttribute.ATTACK_SPEED) {
            value = value / 1000.0 * 4.0;
        }
        for (AttributeModifier attMod : new HashSet(attInst.getModifiers())) {
            UUID uuid = null;
            try {
                uuid = attMod.getUniqueId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String attKey = VersionManager.getCompat().getAttributeKey(attMod);
            String targetKey = VersionManager.getCompat().getAttributeKey(att);
            if (!Compat.ATTRIBUTE_BONUS_UUID.equals(uuid) && !targetKey.equals(attKey)) continue;
            if (attMod.getAmount() == value) {
                return;
            }
            attInst.removeModifier(attMod);
            break;
        }
        if (value == 0.0) {
            return;
        }
        AttributeModifier am = VersionManager.getCompat().createAttributeModifier(att, value, AttributeModifier.Operation.ADD_NUMBER);
        attInst.addModifier(am);
    }

    @NotNull
    private synchronized DoubleUnaryOperator getEffectBonus(@NotNull ItemLoreStat<?> stat, boolean safe) {
        DoubleUnaryOperator operator = value -> value;
        for (IEffect effect : this.getActiveEffects(false)) {
            AdjustStatEffect adjust;
            DoubleUnaryOperator operatorEffect;
            if (!(effect instanceof AdjustStatEffect) || (operatorEffect = (adjust = (AdjustStatEffect)effect).getAdjust(stat, safe)) == null) continue;
            operator = operator.andThen(operatorEffect);
        }
        return operator;
    }

    public void setArrowBonus(@Nullable ArrowManager.QArrow arrow, int level) {
        this.arrowBonus = arrow;
        this.arrowLevel = level;
    }

    public double getDamage() {
        return this.getDamageTypes(true).values().stream().mapToDouble(d -> d).sum();
    }

    public double getDamageByType(@NotNull DamageAttribute type) {
        return this.getDamageTypes(true).getOrDefault(type, 0.0);
    }

    public double getDefenseByType(@NotNull DefenseAttribute type) {
        return this.getDefenseTypes(true).getOrDefault(type, 0.0);
    }

    @NotNull
    public Map<DamageAttribute, Double> getDamageTypes(boolean safe) {
        if (!EngineCfg.ATTRIBUTES_EFFECTIVE_FOR_MOBS && !this.isPlayer()) {
            return Collections.emptyMap();
        }
        HashMap<DamageAttribute, Double> map = new HashMap<DamageAttribute, Double>();
        Biome bio = this.entity.getLocation().getBlock().getBiome();
        List<ItemStack> equip = this.getEquipment();
        for (DamageAttribute dmgAtt : ItemStats.getDamages()) {
            ArrayList<BiFunction<Boolean, double[], double[]>> bonuses = new ArrayList<BiFunction<Boolean, double[], double[]>>();
            for (ItemStack itemStack : equip) {
                bonuses.addAll(dmgAtt.get(itemStack, this.player));
            }
            for (BiFunction biFunction : this.getBonuses(dmgAtt)) {
                bonuses.add((isPercent, input) -> {
                    double[] dArray;
                    if (((double[])input).length == 2) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = (Double)bonus.apply(isPercent, input[0]);
                        dArray = dArray2;
                        dArray2[1] = (Double)bonus.apply(isPercent, input[1]);
                    } else {
                        double[] dArray3 = new double[1];
                        dArray = dArray3;
                        dArray3[0] = (Double)bonus.apply(isPercent, input[0]);
                    }
                    return dArray;
                });
            }
            double[] range = BonusCalculator.RANGE_FULL.apply(new double[]{0.0, 0.0}, bonuses);
            double d = Rnd.getDouble((double)range[0], (double)range[1]);
            d *= dmgAtt.getDamageModifierByBiome(bio);
            d = this.getEffectBonus(dmgAtt, safe).applyAsDouble(d);
            if (!(d > 0.0)) continue;
            map.put(dmgAtt, d);
        }
        return map;
    }

    @NotNull
    public Map<DefenseAttribute, Double> getDefenseTypes(boolean safe) {
        if (!EngineCfg.ATTRIBUTES_EFFECTIVE_FOR_MOBS && !this.isPlayer()) {
            return Collections.emptyMap();
        }
        List<ItemStack> equip = this.getEquipment();
        HashMap<DefenseAttribute, Double> map = new HashMap<DefenseAttribute, Double>();
        for (DefenseAttribute dt : ItemStats.getDefenses()) {
            AttributeInstance attribute;
            ArrayList<BiFunction<Boolean, Double, Double>> bonuses = new ArrayList<BiFunction<Boolean, Double, Double>>();
            for (ItemStack item : equip) {
                bonuses.addAll(dt.get(item, this.player));
            }
            bonuses.addAll(this.getBonuses(dt));
            if (dt.isDefault() && (attribute = this.entity.getAttribute(VersionManager.getNms().getAttribute("ARMOR"))) != null) {
                bonuses.add((isPercent, input) -> isPercent != false ? input : input + attribute.getBaseValue());
            }
            double value = BonusCalculator.SIMPLE_FULL.apply(0.0, bonuses);
            value = this.getEffectBonus(dt, safe).applyAsDouble(value);
            if (!(value > 0.0)) continue;
            map.put(dt, value);
        }
        return map;
    }

    public Map<TypedStat.Type, Double> getItemStats(boolean safe) {
        if (!EngineCfg.ATTRIBUTES_EFFECTIVE_FOR_MOBS && !this.isPlayer()) {
            return Collections.emptyMap();
        }
        HashMap<TypedStat.Type, Double> map = new HashMap<TypedStat.Type, Double>();
        for (TypedStat.Type type : TypedStat.Type.values()) {
            double value = this.getItemStat(type, safe);
            if (!(value > 0.0)) continue;
            map.put(type, value);
        }
        return map;
    }

    public double getItemStat(@NotNull TypedStat.Type type, boolean safe) {
        AttributeInstance attribute;
        if (!EngineCfg.ATTRIBUTES_EFFECTIVE_FOR_MOBS && !this.isPlayer() || !type.isGlobal()) {
            return 0.0;
        }
        SimpleStat stat = (SimpleStat)ItemStats.getStat(type);
        if (stat == null) {
            return 0.0;
        }
        List<ItemStack> equip = this.getEquipment();
        ArrayList<BiFunction<Boolean, Double, Double>> bonuses = new ArrayList<BiFunction<Boolean, Double, Double>>();
        for (ItemStack item : equip) {
            if (item == null || item.getType().isAir()) continue;
            bonuses.addAll(stat.get(item, this.player));
        }
        bonuses.addAll(this.getBonuses(stat));
        if (type == TypedStat.Type.ARMOR_TOUGHNESS && (attribute = this.entity.getAttribute(VersionManager.getNms().getAttribute("ARMOR_TOUGHNESS"))) != null) {
            bonuses.add((isPercent, input) -> isPercent != false ? input : input + attribute.getValue());
        }
        double value = BonusCalculator.SIMPLE_FULL.apply(type == TypedStat.Type.CRITICAL_DAMAGE ? 1.0 : 0.0, bonuses);
        value = this.getEffectBonus(stat, safe).applyAsDouble(value);
        if (stat.getCapability() >= 0.0 && value > stat.getCapability()) {
            value = stat.getCapability();
        }
        return value;
    }

    public double getEnchantProtectFactor(@NotNull Enchantment en) {
        int epfPer = 1;
        if (en == NamespaceResolver.getEnchantment((String[])new String[]{"FIRE_PROTECTION", "PROTECTION_FIRE"}) || en == NamespaceResolver.getEnchantment((String[])new String[]{"BLAST_PROTECTION", "PROTECTION_EXPLOSION"}) || en == NamespaceResolver.getEnchantment((String[])new String[]{"PROJECTILE_PROTECTION", "PROTECTION_PROJECTILE"})) {
            epfPer = 2;
        } else if (en == NamespaceResolver.getEnchantment((String[])new String[]{"FEATHER_FALLING", "PROTECTION_FALL"})) {
            epfPer = 3;
        }
        double epf = 0.0;
        for (ItemStack i : this.getEquipment()) {
            int lvl = i.getEnchantmentLevel(en);
            epf += (double)(lvl * epfPer);
        }
        return Math.min(20.0, epf);
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }
}

