/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.soulbound.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.soulbound.SoulboundManager;
import studio.magemonkey.divinity.stats.items.requirements.user.UntradeableRequirement;

public class SoulboundUntradeCmd
extends MCmd<SoulboundManager> {
    private UntradeableRequirement reqUntrade;

    public SoulboundUntradeCmd(@NotNull SoulboundManager m, @NotNull UntradeableRequirement reqUntrade) {
        super(m, new String[]{"untradeable"}, "quantumrpg.soulbound.cmd.untradeable");
        this.reqUntrade = reqUntrade;
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Soulbound_Cmd_Untradeable_Usage.getMsg();
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Soulbound_Cmd_Untradeable_Desc.getMsg();
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return Arrays.asList("add", "remove");
        }
        if (i == 2 && args[0].equalsIgnoreCase("add")) {
            return Arrays.asList("[pos]");
        }
        return super.getTab(player, i, args);
    }

    public boolean playersOnly() {
        return true;
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length < 2 || args.length > 3) {
            this.printUsage(sender);
            return;
        }
        if (!args[1].equalsIgnoreCase("add") && !args[1].equalsIgnoreCase("remove")) {
            this.printUsage(sender);
            return;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (ItemUT.isAir((ItemStack)item)) {
            ((Divinity)this.plugin).lang().Error_NoItem.send((CommandSender)player);
            return;
        }
        int pos = args.length == 3 ? StringUT.getInteger((String)args[2], (int)-1) : -1;
        boolean add = args[1].equalsIgnoreCase("add");
        if (add) {
            this.reqUntrade.add(item, pos);
        } else {
            this.reqUntrade.remove(item);
        }
        ((Divinity)this.plugin).lang().Soulbound_Cmd_Untradeable_Done.replace("%state%", (Object)((Divinity)this.plugin).lang().getBool(add)).send((CommandSender)player);
    }
}

