/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings.TrimmingListGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings.TrimmingMaterialGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings.TrimmingPatternsGUI;

public class TrimmingGUI
extends AbstractEditorGUI {
    private final TrimmingListGUI.TrimmingEntry entry;

    public TrimmingGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, TrimmingListGUI.TrimmingEntry entry) {
        super(player, 1, "Editor/" + EditorGUI.ItemType.ARMOR_TRIMINGS.getTitle(), itemGenerator);
        this.entry = entry;
    }

    public void setContents() {
        String name = this.entry.getArmorTrim().getMaterial() == null ? "Any" : this.entry.getArmorTrim().getMaterial().getKey().getKey();
        this.setSlot(0, new Slot(TrimmingGUI.createItem(TrimmingGUI.fromMaterial(this.entry.getArmorTrim().getMaterial()), "&eTrim Material", "&bCurrent: &a" + name.substring(0, 1).toUpperCase() + name.substring(1), "&eModify")){

            public void onLeftClick() {
                TrimmingGUI.this.openSubMenu(new TrimmingMaterialGUI(TrimmingGUI.this.player, TrimmingGUI.this.itemGenerator, TrimmingGUI.this.entry));
            }
        });
        name = this.entry.getArmorTrim().getPattern() == null ? "Any" : this.entry.getArmorTrim().getPattern().getKey().getKey();
        this.setSlot(1, new Slot(TrimmingGUI.createItem(TrimmingGUI.fromPattern(this.entry.getArmorTrim().getPattern()), "&eTrim Pattern", "&bCurrent: &a" + name.substring(0, 1).toUpperCase() + name.substring(1), "&eModify")){

            public void onLeftClick() {
                TrimmingGUI.this.openSubMenu(new TrimmingPatternsGUI(TrimmingGUI.this.player, TrimmingGUI.this.itemGenerator, TrimmingGUI.this.entry));
            }
        });
        this.setSlot(2, new Slot(TrimmingGUI.createItem(Material.DROPPER, "&eWeight", "&bCurrent: &a" + this.entry.getWeight(), "&eSet")){

            public void onLeftClick() {
                TrimmingGUI.this.sendSetMessage("weight for this trim", String.valueOf(TrimmingGUI.this.entry.getWeight()), s -> {
                    TrimmingGUI.this.entry.setWeight(Double.parseDouble(s));
                    TrimmingGUI.this.itemGenerator.getConfig().set(TrimmingListGUI.getPath(TrimmingGUI.this.entry.getArmorTrim()), (Object)TrimmingGUI.this.entry.getWeight());
                    TrimmingGUI.this.saveAndReopen();
                });
            }
        });
    }

    public static Material fromMaterial(TrimMaterial trimMaterial) {
        if (trimMaterial == TrimMaterial.QUARTZ) {
            return Material.QUARTZ;
        }
        if (trimMaterial == TrimMaterial.IRON) {
            return Material.IRON_INGOT;
        }
        if (trimMaterial == TrimMaterial.NETHERITE) {
            return Material.NETHERITE_INGOT;
        }
        if (trimMaterial == TrimMaterial.REDSTONE) {
            return Material.REDSTONE;
        }
        if (trimMaterial == TrimMaterial.COPPER) {
            return Material.COPPER_INGOT;
        }
        if (trimMaterial == TrimMaterial.GOLD) {
            return Material.GOLD_INGOT;
        }
        if (trimMaterial == TrimMaterial.EMERALD) {
            return Material.EMERALD;
        }
        if (trimMaterial == TrimMaterial.DIAMOND) {
            return Material.DIAMOND;
        }
        if (trimMaterial == TrimMaterial.LAPIS) {
            return Material.LAPIS_LAZULI;
        }
        if (trimMaterial == TrimMaterial.AMETHYST) {
            return Material.AMETHYST_SHARD;
        }
        if (trimMaterial == null) {
            return Material.CRAFTING_TABLE;
        }
        return Material.STONE;
    }

    public static Material fromPattern(TrimPattern trimPattern) {
        if (trimPattern == null) {
            return Material.CRAFTING_TABLE;
        }
        try {
            return Material.valueOf((String)(trimPattern.getKey().getKey().toUpperCase() + Material.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE.name().substring("sentry".length())));
        }
        catch (IllegalArgumentException e) {
            return Material.STONE;
        }
    }
}

