/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats.MainStatsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats.StatGUI;

public class StatListGUI
extends AbstractEditorGUI {
    private final EditorGUI.ItemType itemType;

    public StatListGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, EditorGUI.ItemType itemType) {
        super(player, 6, "Editor/" + itemType.getTitle(), itemGenerator);
        this.itemType = itemType;
    }

    public void setContents() {
        JYML cfg = this.itemGenerator.getConfig();
        ArrayList list = new ArrayList();
        ConfigurationSection section = cfg.getConfigurationSection(MainStatsGUI.ItemType.LIST.getPath(this.itemType));
        if (section != null) {
            list.addAll(section.getKeys(false));
        }
        this.slots.clear();
        int from = this.getPage() * 45;
        int to = Math.min(from + 45, list.size());
        int i = 0;
        for (int j = from; j < to; ++j) {
            final String entry = (String)list.get(j);
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            ItemStack itemStack = null;
            switch (this.itemType) {
                case DAMAGE_TYPES: {
                    itemStack = new ItemStack(Material.IRON_SWORD);
                    break;
                }
                case DEFENSE_TYPES: {
                    itemStack = new ItemStack(Material.IRON_CHESTPLATE);
                    break;
                }
                case FABLED_ATTRIBUTES: {
                    FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
                    if (fabledHook == null) break;
                    itemStack = fabledHook.getAttributeIndicator(entry);
                    break;
                }
            }
            if (itemStack == null) {
                itemStack = new ItemStack(Material.PAPER);
            }
            String path = MainStatsGUI.ItemType.LIST.getPath(this.itemType) + "." + entry + ".";
            String roundDisplay = this.itemType == EditorGUI.ItemType.FABLED_ATTRIBUTES ? "" : "&bRound: &a" + cfg.getBoolean(path + "round", false);
            StatListGUI.createItem(itemStack, "&e" + entry, "&bCurrent:", "&bChance: &a" + cfg.getDouble(path + "chance"), "&bScale by level: &a" + cfg.getDouble(path + "scale-by-level"), "&bMinimum value: &a" + cfg.getDouble(path + "min"), "&bMaximum value: &a" + cfg.getDouble(path + "max"), "&bFlat range: &a" + cfg.getBoolean(path + "flat-range"), roundDisplay, "", "&eModify");
            this.setSlot(i, new Slot(itemStack){

                public void onLeftClick() {
                    StatListGUI.this.openSubMenu(new StatGUI(StatListGUI.this.player, StatListGUI.this.itemGenerator, StatListGUI.this.itemType, MainStatsGUI.ItemType.LIST.getPath(StatListGUI.this.itemType) + "." + entry));
                }
            });
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

