/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.LoreGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats.StatListGUI;

public class MainStatsGUI
extends AbstractEditorGUI {
    private final EditorGUI.ItemType itemType;

    public MainStatsGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, EditorGUI.ItemType itemType) {
        super(player, 1, "Editor/" + itemType.getTitle(), itemGenerator);
        this.itemType = itemType;
    }

    public void setContents() {
        Material material;
        this.setSlot(0, new Slot(MainStatsGUI.createItem(Material.BROWN_MUSHROOM, "&eMinimum " + this.itemType.getTitle(), "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MINIMUM.getPath(this.itemType)), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                String path = ItemType.MINIMUM.getPath(MainStatsGUI.this.itemType);
                MainStatsGUI.this.itemGenerator.getConfig().set(path, (Object)Math.max(0, MainStatsGUI.this.itemGenerator.getConfig().getInt(path) - 1));
                MainStatsGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                String path = ItemType.MINIMUM.getPath(MainStatsGUI.this.itemType);
                MainStatsGUI.this.itemGenerator.getConfig().set(path, (Object)Math.max(0, MainStatsGUI.this.itemGenerator.getConfig().getInt(path) + 1));
                MainStatsGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                MainStatsGUI.this.sendSetMessage(ItemType.MINIMUM.getPath() + " " + MainStatsGUI.this.itemType.getTitle(), String.valueOf(MainStatsGUI.this.itemGenerator.getConfig().getInt(ItemType.MINIMUM.getPath(MainStatsGUI.this.itemType))), s -> {
                    int minimum = Integer.parseInt(s);
                    if (minimum < 0) {
                        throw new IllegalArgumentException();
                    }
                    MainStatsGUI.this.itemGenerator.getConfig().set(ItemType.MINIMUM.getPath(MainStatsGUI.this.itemType), (Object)minimum);
                    MainStatsGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                MainStatsGUI.this.itemGenerator.getConfig().set(ItemType.MINIMUM.getPath(MainStatsGUI.this.itemType), (Object)0);
                MainStatsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(MainStatsGUI.createItem(Material.RED_MUSHROOM, "&eMaximum " + this.itemType.getTitle(), "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MAXIMUM.getPath(this.itemType)), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                String path = ItemType.MAXIMUM.getPath(MainStatsGUI.this.itemType);
                MainStatsGUI.this.itemGenerator.getConfig().set(path, (Object)Math.max(0, MainStatsGUI.this.itemGenerator.getConfig().getInt(path) - 1));
                MainStatsGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                String path = ItemType.MAXIMUM.getPath(MainStatsGUI.this.itemType);
                MainStatsGUI.this.itemGenerator.getConfig().set(path, (Object)Math.max(0, MainStatsGUI.this.itemGenerator.getConfig().getInt(path) + 1));
                MainStatsGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                MainStatsGUI.this.sendSetMessage(ItemType.MAXIMUM.getPath() + " " + MainStatsGUI.this.itemType.getTitle(), String.valueOf(MainStatsGUI.this.itemGenerator.getConfig().getInt(ItemType.MAXIMUM.getPath(MainStatsGUI.this.itemType))), s -> {
                    int maximum = Integer.parseInt(s);
                    if (maximum < 0) {
                        throw new IllegalArgumentException();
                    }
                    MainStatsGUI.this.itemGenerator.getConfig().set(ItemType.MAXIMUM.getPath(MainStatsGUI.this.itemType), (Object)maximum);
                    MainStatsGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                MainStatsGUI.this.itemGenerator.getConfig().set(ItemType.MAXIMUM.getPath(MainStatsGUI.this.itemType), (Object)0);
                MainStatsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(2, new Slot(MainStatsGUI.createItem(Material.WRITABLE_BOOK, "&eLore format", (List<String>)StringUT.replace((String)"%current%", (List)this.itemGenerator.getConfig().getStringList(ItemType.LORE.getPath(this.itemType)), (String[])new String[]{"&bCurrent:", "&a----------", "&f%current%", "&a----------", "&6Left-Click: &eModify", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                MainStatsGUI.this.openSubMenu(new LoreGUI(MainStatsGUI.this.player, MainStatsGUI.this.title + " lore", MainStatsGUI.this.itemGenerator, ItemType.LORE.getPath(MainStatsGUI.this.itemType)));
            }

            public void onRightClick() {
                MainStatsGUI.this.setDefault(ItemType.LORE.getPath(MainStatsGUI.this.itemType));
                MainStatsGUI.this.saveAndReopen();
            }
        });
        switch (this.itemType) {
            case DAMAGE_TYPES: {
                material = Material.IRON_SWORD;
                break;
            }
            case DEFENSE_TYPES: {
                material = Material.IRON_CHESTPLATE;
                break;
            }
            case FABLED_ATTRIBUTES: {
                material = Material.BOOK;
                break;
            }
            default: {
                material = Material.PAPER;
            }
        }
        this.setSlot(3, new Slot(MainStatsGUI.createItem(material, "&eList of " + this.itemType.getTitle(), "&eModify")){

            public void onLeftClick() {
                MainStatsGUI.this.openSubMenu(new StatListGUI(MainStatsGUI.this.player, MainStatsGUI.this.itemGenerator, MainStatsGUI.this.itemType));
            }
        });
    }

    public static enum ItemType {
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        LORE("lore-format"),
        LIST("list");

        private final String path;

        private ItemType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getPath(EditorGUI.ItemType itemType) {
            return itemType.getPath() + "." + this.path;
        }
    }
}

