/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor;

import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;

public class ItemFlagsGUI
extends AbstractEditorGUI {
    private static final String PATH = EditorGUI.ItemType.ITEM_FLAGS.getPath();

    public ItemFlagsGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.ITEM_FLAGS.getTitle(), itemGenerator);
    }

    public void setContents() {
        int i = 0;
        for (ItemFlag flag : ItemFlag.values()) {
            Material material;
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            switch (flag) {
                case HIDE_ENCHANTS: {
                    material = Material.ENCHANTED_BOOK;
                    break;
                }
                case HIDE_ATTRIBUTES: {
                    material = Material.OAK_SIGN;
                    break;
                }
                case HIDE_UNBREAKABLE: {
                    material = Material.ANVIL;
                    break;
                }
                case HIDE_DESTROYS: {
                    material = Material.DIAMOND_PICKAXE;
                    break;
                }
                case HIDE_PLACED_ON: {
                    material = Material.OAK_PLANKS;
                    break;
                }
                case HIDE_DYE: {
                    material = Material.MAGENTA_DYE;
                    break;
                }
                default: {
                    material = Material.STONE;
                }
            }
            if (flag.name().equals("HIDE_POTION_EFFECTS") || flag.name().equals("HIDE_ADDITIONAL_TOOLTIP")) {
                material = Material.POTION;
            }
            final String name = flag.name().toLowerCase();
            this.setSlot(i, new Slot(ItemFlagsGUI.createItem(material, "&e" + name, "&bCurrent: &a" + this.itemGenerator.getHandle().getFlags().contains(flag), "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

                public void onLeftClick() {
                    HashSet<String> itemFlags = new HashSet<String>(ItemFlagsGUI.this.itemGenerator.getConfig().getStringList(PATH));
                    if (itemFlags.contains("*")) {
                        itemFlags.remove("*");
                        for (ItemFlag itemFlag : ItemFlag.values()) {
                            itemFlags.add(itemFlag.name().toLowerCase());
                        }
                    }
                    if (itemFlags.contains(name)) {
                        itemFlags.remove(name);
                    } else {
                        itemFlags.add(name);
                    }
                    boolean all = true;
                    for (ItemFlag itemFlag : ItemFlag.values()) {
                        if (itemFlags.contains(itemFlag.name().toLowerCase())) continue;
                        all = false;
                        break;
                    }
                    if (all) {
                        itemFlags.clear();
                        itemFlags.add("*");
                    }
                    ItemFlagsGUI.this.itemGenerator.getConfig().set(PATH, new ArrayList(itemFlags));
                    ItemFlagsGUI.this.saveAndReopen();
                }

                public void onDrop() {
                    HashSet defaultFlags = new HashSet(ItemGeneratorManager.commonItemGenerator.getStringList(PATH));
                    HashSet<String> itemFlags = new HashSet<String>(ItemFlagsGUI.this.itemGenerator.getConfig().getStringList(PATH));
                    if (itemFlags.contains("*")) {
                        itemFlags.remove("*");
                        for (ItemFlag itemFlag : ItemFlag.values()) {
                            itemFlags.add(itemFlag.name().toLowerCase());
                        }
                    }
                    if (defaultFlags.contains(name) || defaultFlags.contains("*")) {
                        itemFlags.add(name);
                    } else {
                        itemFlags.remove(name);
                    }
                    boolean all = true;
                    for (ItemFlag itemFlag : ItemFlag.values()) {
                        if (itemFlags.contains(itemFlag.name().toLowerCase())) continue;
                        all = false;
                        break;
                    }
                    if (all) {
                        itemFlags.clear();
                        itemFlags.add("*");
                    }
                    ItemFlagsGUI.this.itemGenerator.getConfig().set(PATH, new ArrayList(itemFlags));
                    ItemFlagsGUI.this.saveAndReopen();
                }
            });
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

