/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;

public class AmmoTypesGUI
extends AbstractEditorGUI {
    public AmmoTypesGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.AMMO_TYPES.getTitle(), itemGenerator);
    }

    public void setContents() {
        int i = 0;
        for (AmmoAttribute ammo : ItemStats.getAmmos()) {
            Material material;
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            switch (ammo.getType()) {
                case SNOWBALL: {
                    material = Material.SNOWBALL;
                    break;
                }
                case EGG: {
                    material = Material.EGG;
                    break;
                }
                case FIREBALL: {
                    material = Material.FIRE_CHARGE;
                    break;
                }
                case WITHER_SKULL: {
                    material = Material.WITHER_SKELETON_SKULL;
                    break;
                }
                case SHULKER_BULLET: {
                    material = Material.SHULKER_SHELL;
                    break;
                }
                case LLAMA_SPIT: {
                    material = Material.LLAMA_SPAWN_EGG;
                    break;
                }
                case ENDER_PEARL: {
                    material = Material.ENDER_PEARL;
                    break;
                }
                case EXP_POTION: {
                    material = Material.EXPERIENCE_BOTTLE;
                    break;
                }
                default: {
                    material = Material.ARROW;
                }
            }
            final String id = ammo.getId().toUpperCase();
            this.setSlot(i, new Slot(AmmoTypesGUI.createItem(material, "&e" + ammo.getName(), "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(EditorGUI.ItemType.AMMO_TYPES.getPath() + "." + id, 0.0), "&6Left-Click: &eSet", "&6Right-Click: &eRemove")){

                public void onLeftClick() {
                    AmmoTypesGUI.this.sendSetMessage(id, String.valueOf(AmmoTypesGUI.this.itemGenerator.getConfig().getDouble(EditorGUI.ItemType.AMMO_TYPES.getPath() + "." + id, 0.0)), s -> {
                        double chance = Double.parseDouble(s);
                        if (chance == 0.0) {
                            AmmoTypesGUI.this.itemGenerator.getConfig().remove(EditorGUI.ItemType.AMMO_TYPES.getPath() + "." + id);
                        } else if (chance > 0.0) {
                            AmmoTypesGUI.this.itemGenerator.getConfig().set(EditorGUI.ItemType.AMMO_TYPES.getPath() + "." + id, (Object)chance);
                        } else {
                            throw new IllegalArgumentException();
                        }
                        AmmoTypesGUI.this.saveAndReopen();
                    });
                }

                public void onRightClick() {
                    AmmoTypesGUI.this.itemGenerator.getConfig().remove(EditorGUI.ItemType.AMMO_TYPES.getPath() + "." + id);
                    AmmoTypesGUI.this.saveAndReopen();
                }
            });
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

