/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.command;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;

public class EditCommand
extends MCmd<ItemGeneratorManager> {
    public EditCommand(@NotNull ItemGeneratorManager module) {
        super(module, new String[]{"edit"}, "quantumrpg.admin");
    }

    @NotNull
    public String usage() {
        return "<id>";
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().ItemGenerator_Cmd_Editor_Desc.getMsg();
    }

    public boolean playersOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            List<String> ids = ((ItemGeneratorManager)this.module).getItemIds();
            ids.remove("random");
            return ids;
        }
        return super.getTab(player, i, args);
    }

    protected void perform(@NotNull CommandSender commandSender, @NotNull String s, @NotNull String[] strings) {
        if (strings.length != 2) {
            this.printUsage(commandSender);
            return;
        }
        ItemGeneratorManager.GeneratorItem itemGenerator = (ItemGeneratorManager.GeneratorItem)((ItemGeneratorManager)this.module).getItemById(strings[1]);
        if (itemGenerator == null) {
            ((Divinity)this.plugin).lang().ItemGenerator_Cmd_Editor_Error_InvalidItem.send(commandSender);
            return;
        }
        try {
            new EditorGUI((Player)commandSender, new AbstractEditorGUI.ItemGeneratorReference(itemGenerator)).open(1);
        }
        catch (IllegalStateException e) {
            ((Divinity)this.plugin).lang().ItemGenerator_Cmd_Editor_Error_AlreadyOpen.replace("%player%", (Object)commandSender.getName()).send(commandSender);
        }
    }
}

