/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.fortify.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.fortify.FortifyManager;

public class FortifyCmd
extends MCmd<FortifyManager> {
    public FortifyCmd(@NotNull FortifyManager module) {
        super(module, new String[]{"fortify"}, "quantumrpg.fortify.cmd.fortify");
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Fortify_Cmd_Fortify_Usage.getMsg();
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Fortify_Cmd_Fortify_Desc.getMsg();
    }

    public boolean playersOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return ((FortifyManager)this.module).getItemIds();
        }
        if (i == 2) {
            return Arrays.asList("-1", "1", "2", "3", "4", "5");
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length != 3) {
            this.printUsage(sender);
            return;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (ItemUT.isAir((ItemStack)item)) {
            ((Divinity)this.plugin).lang().Error_NoItem.send((CommandSender)player);
            return;
        }
        FortifyManager.FortifyItem stone = (FortifyManager.FortifyItem)((FortifyManager)this.module).getItemById(args[1]);
        if (stone == null) {
            ((Divinity)this.plugin).lang().Fortify_Cmd_Fortify_Error_Stone.send((CommandSender)player);
            return;
        }
        int lvl = this.getNumI(sender, args[2], -1);
        if (lvl < 1) {
            lvl = Rnd.get((int)stone.getMinLevel(), (int)stone.getMaxLevel());
        }
        ((FortifyManager)this.module).fortifyItem(item, stone, lvl);
        player.getInventory().setItemInMainHand(item);
        ((Divinity)this.plugin).lang().Fortify_Fortify_Done.send(sender);
    }
}

