/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.customitems;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.divinity.stats.tiers.Tiered;

public class CustomItemsManager
extends QModuleDrop<CustomItem> {
    public CustomItemsManager(@NotNull Divinity plugin) {
        super(plugin, CustomItem.class);
    }

    @NotNull
    public String getId() {
        return "custom_items";
    }

    @NotNull
    public String version() {
        return "1.0";
    }

    public void setup() {
    }

    public void shutdown() {
    }

    public class CustomItem
    extends ModuleItem
    implements Tiered {
        private Tier tier;

        public CustomItem(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, CustomItemsManager.this);
            this.updateConfig(cfg);
            this.validateTier(cfg);
        }

        private void updateConfig(@NotNull JYML cfg) {
            cfg.addMissing("tier", (Object)"default");
            cfg.saveChanges();
        }

        private void validateTier(JYML cfg) {
            this.tier = Config.getTier(cfg.getString("tier", "default"));
            if (this.tier == null) {
                throw new IllegalArgumentException("Invalid Tier provided! Module Item must have valid Tier!");
            }
        }

        @Override
        protected String applyLoreReplacements(String lore) {
            return this.getTier().format(lore);
        }

        @Override
        protected void processLore(@NotNull JYML cfg, @NotNull QModuleDrop<?> module) {
            this.validateTier(cfg);
            super.processLore(cfg, module);
        }

        @Override
        @Generated
        public Tier getTier() {
            return this.tier;
        }

        @Generated
        public void setTier(Tier tier) {
            this.tier = tier;
        }
    }
}

