/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.combatlog;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.ClickText;
import studio.magemonkey.codex.util.MsgUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.SoundUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.manager.damage.DamageMeta;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.combatlog.command.LogCommand;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;

public class CombatLogManager
extends QModule {
    public boolean genLogEnabled;
    private int genLogMaxAmount;
    private DateTimeFormatter genLogFormatTime;
    private String genLogFormatText;
    private String genLogFormatButtonDamageName;
    private List<String> genLogFormatButtonDamageText;
    private String genLogFormatButtonDefenseName;
    private List<String> genLogFormatButtonDefenseText;
    private String genLogFormatButtonDetailsName;
    private List<String> genLogFormatButtonDetailsText;
    private String genLogFormatButtonWeaponName;
    private boolean ignoreZeroDamage;
    private List<String> indicatorOrder;
    private Map<String, String> indicatorDamageTypes;
    private Map<String, String> indicatorRegenTypes;
    private Map<String, List<ClickText>> logCombat;
    private IndicatorExpansion indicatorExpansion;

    public CombatLogManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "combat_log";
    }

    @NotNull
    public String version() {
        return "1.5.0";
    }

    public void setup() {
        String path = "general.";
        this.genLogEnabled = this.cfg.getBoolean(path + "logging.enabled");
        if (this.genLogEnabled) {
            this.logCombat = new HashMap<String, List<ClickText>>();
            this.genLogMaxAmount = this.cfg.getInt(path + "logging.max-amount", 10);
            String path2 = "general.logging.format.";
            this.genLogFormatTime = DateTimeFormatter.ofPattern(this.cfg.getString(path2 + "time", "HH:mm"));
            this.genLogFormatText = StringUT.color((String)this.cfg.getString(path2 + "text", "&6[%time%] &r%message% %damage% %defense% %details% %weapon%"));
            this.genLogFormatButtonDamageName = StringUT.color((String)this.cfg.getString(path2 + "buttons.damage.name", "&c&l[Damage]"));
            this.genLogFormatButtonDamageText = StringUT.color((List)this.cfg.getStringList(path2 + "buttons.damage.text"));
            this.genLogFormatButtonDefenseName = StringUT.color((String)this.cfg.getString(path2 + "buttons.defense.name", "&b&l[Defense]"));
            this.genLogFormatButtonDefenseText = StringUT.color((List)this.cfg.getStringList(path2 + "buttons.defense.text"));
            this.genLogFormatButtonDetailsName = StringUT.color((String)this.cfg.getString(path2 + "buttons.details.name", "&e&l[Details]"));
            this.genLogFormatButtonDetailsText = StringUT.color((List)this.cfg.getStringList(path2 + "buttons.details.text"));
            this.genLogFormatButtonWeaponName = StringUT.color((String)this.cfg.getString(path2 + "buttons.weapon.name", "&d&l[Weapon]"));
            this.moduleCommand.addSubCommand((ISubCommand)new LogCommand(this));
        }
        path = "messages.";
        this.ignoreZeroDamage = this.cfg.getBoolean(path + "ignore-zero-damage");
        for (MessageType msgType : MessageType.values()) {
            String path2 = path + "types." + msgType.name() + ".";
            if (!this.cfg.getBoolean(path2 + "enabled")) continue;
            String msgDamager = this.cfg.getString(path2 + "messages.damager");
            String msgVictim = this.cfg.getString(path2 + "messages.victim");
            String msgIndicator = this.cfg.getString(path2 + "messages.indicator");
            Keyed sound = null;
            String soundStr = this.cfg.getString(path2 + "sound");
            if (soundStr != null && !soundStr.equalsIgnoreCase("none")) {
                try {
                    sound = SoundUT.getSound((String)soundStr.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            msgType.setEnabled(true);
            msgType.setMessageDamager(msgDamager);
            msgType.setMessageVictim(msgVictim);
            msgType.setMessageIndicator(msgIndicator);
            msgType.setSound(sound);
        }
        path = "indicators.";
        if (this.cfg.getBoolean(path + "enabled") && Hooks.hasPlugin((String)"HolographicDisplays")) {
            this.indicatorOrder = this.cfg.getStringList(path + "format.order");
            this.indicatorDamageTypes = new HashMap<String, String>();
            for (String dmgId : this.cfg.getSection(path + "format.damage-types")) {
                String holoText = StringUT.color((String)this.cfg.getString(path + "format.damage-types." + dmgId, "&c-%damage%"));
                this.indicatorDamageTypes.put(dmgId.toLowerCase(), holoText);
            }
            this.indicatorRegenTypes = new HashMap<String, String>();
            for (String regenId : this.cfg.getSection(path + "format.regen-sources")) {
                String holoText = StringUT.color((String)this.cfg.getString(path + "format.regen-sources." + regenId, "&a+%hp%"));
                this.indicatorRegenTypes.put(regenId.toLowerCase(), holoText);
            }
            this.indicatorExpansion = new IndicatorExpansion();
            this.indicatorExpansion.setup();
        }
    }

    public void shutdown() {
        if (this.indicatorExpansion != null) {
            this.indicatorExpansion.shutdown();
            this.indicatorExpansion = null;
        }
        if (this.indicatorOrder != null) {
            this.indicatorOrder.clear();
            this.indicatorOrder = null;
        }
        if (this.indicatorDamageTypes != null) {
            this.indicatorDamageTypes.clear();
            this.indicatorDamageTypes = null;
        }
        if (this.indicatorRegenTypes != null) {
            this.indicatorRegenTypes.clear();
            this.indicatorRegenTypes = null;
        }
        if (this.logCombat != null) {
            this.logCombat.clear();
            this.logCombat = null;
        }
    }

    @NotNull
    public List<ClickText> getCombatLog(@NotNull Player player) {
        return this.logCombat.getOrDefault(player.getName(), new ArrayList());
    }

    private void sendCombatLog(final @NotNull DamageMeta meta, final double damageTotal) {
        String dMsg;
        String zMsg;
        LogFormatter logger;
        if (damageTotal <= 0.0 && this.ignoreZeroDamage) {
            return;
        }
        LivingEntity damager = meta.getDamager();
        if (damager == null) {
            return;
        }
        MessageType type = MessageType.NORMAL;
        if (meta.isDodged()) {
            type = MessageType.DODGE;
        } else if (meta.isCritical()) {
            type = MessageType.CRITICAL;
        } else if (meta.isBlocked()) {
            type = MessageType.BLOCK;
        }
        if (!type.isEnabled()) {
            return;
        }
        String strDamage = NumberUT.format((double)damageTotal);
        String strBlock = NumberUT.format((double)((1.0 - meta.getBlockModifier()) * 100.0));
        LivingEntity victim = meta.getVictim();
        Player pVictim = null;
        Player pDamager = null;
        if (victim instanceof Player) {
            pVictim = (Player)victim;
        }
        if (damager instanceof Player) {
            pDamager = (Player)damager;
        }
        class LogFormatter {
            LogFormatter() {
            }

            public void format(@NotNull LivingEntity damager, @NotNull Player sender, @NotNull String dMsg) {
                String time = CombatLogManager.this.genLogFormatTime.format(LocalTime.now());
                String main = CombatLogManager.this.genLogFormatText.replace("%message%", dMsg).replace("%time%", time);
                String atkPower = NumberUT.format((double)(100.0 * EntityStats.get(damager).getAttackPowerModifier()));
                double defBlockedTotal = meta.getDefendedDamage();
                double damageRawTotal = damageTotal + defBlockedTotal;
                double damagePercentTotal = damageTotal / damageRawTotal * 100.0;
                ArrayList<String> damageHint = new ArrayList<String>();
                for (String line : CombatLogManager.this.genLogFormatButtonDamageText) {
                    if (line.contains("%damage_type%")) {
                        for (Map.Entry<DamageAttribute, Double> entry : meta.getDamages().entrySet()) {
                            double damageAmount = entry.getValue();
                            double damageRaw = damageAmount + meta.getDefendedDamage(entry.getKey());
                            double damagePercent = damageAmount / damageRaw * 100.0;
                            String dmgName = entry.getKey().getName();
                            damageHint.add(line.replace("%percent%", NumberUT.format((double)damagePercent)).replace("%raw%", NumberUT.format((double)damageRaw)).replace("%amount%", NumberUT.format((double)damageAmount)).replace("%damage_type%", dmgName));
                        }
                        continue;
                    }
                    damageHint.add(line.replace("%percent_total%", NumberUT.format((double)damagePercentTotal)).replace("%raw_total%", NumberUT.format((double)damageRawTotal)).replace("%amount_total%", NumberUT.format((double)damageTotal)).replace("%attack_power%", atkPower));
                }
                double defPercentTotal = defBlockedTotal / damageRawTotal * 100.0;
                ArrayList<String> defenseHint = new ArrayList<String>();
                for (String line : CombatLogManager.this.genLogFormatButtonDefenseText) {
                    if (line.contains("%defense_type%")) {
                        for (Map.Entry<DamageAttribute, Double> e : meta.getDamages().entrySet()) {
                            double defBlocked = meta.getDefendedDamage(e.getKey());
                            double damageType = e.getValue() + defBlocked;
                            double defPercent = defBlocked / damageType * 100.0;
                            defenseHint.add(line.replace("%damage%", NumberUT.format((double)damageType)).replace("%percent%", NumberUT.format((double)defPercent)).replace("%amount%", NumberUT.format((double)defBlocked)).replace("%defense_type%", e.getKey().getName()));
                        }
                        continue;
                    }
                    defenseHint.add(line.replace("%percent_total%", NumberUT.format((double)defPercentTotal)).replace("%amount_total%", NumberUT.format((double)defBlockedTotal)).replace("%damage_total%", NumberUT.format((double)damageRawTotal)));
                }
                ArrayList<String> arrayList = new ArrayList<String>(CombatLogManager.this.genLogFormatButtonDetailsText);
                arrayList.replaceAll(s -> s.replace("%enchantment_protection_factor%", NumberUT.format((double)meta.getEnchantProtectionModifier())).replace("%pvpe_modifier%", NumberUT.format((double)meta.getPvEDamageModifier())).replace("%penetrate_modifier%", NumberUT.format((double)meta.getPenetrateModifier())).replace("%block_modifier%", NumberUT.format((double)meta.getBlockModifier())).replace("%critical_modifier%", NumberUT.format((double)meta.getCriticalModifier())).replace("%direct_modifier%", NumberUT.format((double)meta.getDirectModifier())));
                ItemStack weapon = meta.getWeapon();
                ClickText text = new ClickText(main);
                if (meta.isDodged()) {
                    text.createPlaceholder("%damage%", "");
                    text.createPlaceholder("%defense%", "");
                    text.createPlaceholder("%details%", "");
                } else {
                    text.createPlaceholder("%damage%", CombatLogManager.this.genLogFormatButtonDamageName).hint(damageHint);
                    text.createPlaceholder("%defense%", CombatLogManager.this.genLogFormatButtonDefenseName).hint(defenseHint);
                    text.createPlaceholder("%details%", CombatLogManager.this.genLogFormatButtonDetailsName).hint(arrayList);
                }
                if (weapon != null && weapon.getType() != Material.AIR) {
                    text.createPlaceholder("%weapon%", CombatLogManager.this.genLogFormatButtonWeaponName).showItem(weapon);
                } else {
                    text.createPlaceholder("%weapon%", "");
                }
                List<ClickText> dLog = CombatLogManager.this.getCombatLog(sender);
                if (dLog.size() >= CombatLogManager.this.genLogMaxAmount) {
                    dLog.remove(0);
                }
                dLog.add(text);
                CombatLogManager.this.logCombat.put(sender.getName(), dLog);
            }
        }
        LogFormatter logFormatter = logger = this.genLogEnabled && (pVictim != null || pDamager != null) ? new LogFormatter() : null;
        if (pVictim != null && (zMsg = type.getMessageVictim()) != null) {
            zMsg = zMsg.replace("%damage%", strDamage).replace("%entity%", meta.getDamagerName()).replace("%block%", strBlock);
            MsgUT.sendActionBar((Player)pVictim, (String)zMsg);
            type.playSound(pVictim);
            if (logger != null) {
                logger.format(damager, pVictim, zMsg);
            }
        }
        if (pDamager != null && (dMsg = type.getMessageDamager()) != null) {
            dMsg = dMsg.replace("%damage%", strDamage).replace("%entity%", meta.getVictimName()).replace("%block%", strBlock);
            MsgUT.sendActionBar((Player)pDamager, (String)dMsg);
            type.playSound(pDamager);
            if (logger != null) {
                logger.format((LivingEntity)pDamager, pDamager, dMsg);
            }
        }
    }

    @NotNull
    private String getDamageTypeFormat(@NotNull String type) {
        if (this.indicatorDamageTypes.containsKey(type = type.toLowerCase())) {
            return this.indicatorDamageTypes.get(type);
        }
        return "%damage%";
    }

    @Nullable
    private String getRegenTypeFormat(@NotNull String type) {
        if (this.indicatorRegenTypes.containsKey(type = type.toLowerCase())) {
            return this.indicatorRegenTypes.get(type);
        }
        if (this.indicatorRegenTypes.containsKey("default")) {
            return this.indicatorRegenTypes.get("default");
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onIndicatorRegen(EntityRegainHealthEvent e) {
        if (this.indicatorExpansion == null || this.indicatorRegenTypes.isEmpty()) {
            return;
        }
        Entity e1 = e.getEntity();
        if (!(e1 instanceof LivingEntity)) {
            return;
        }
        String regenSource = e.getRegainReason().name();
        double health = e.getAmount();
        if (health <= 0.0) {
            return;
        }
        String line = this.getRegenTypeFormat(regenSource);
        if (line == null) {
            return;
        }
        List<String> list = List.of(line.replace("%hp%", NumberUT.format((double)health)));
        LivingEntity li = (LivingEntity)e1;
        Location loc = li.getEyeLocation().clone().add(0.0, 0.9, 0.0);
        this.indicatorExpansion.create(loc, list);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamageIndicator(EntityDamageEvent e) {
        if (e instanceof EntityDamageByEntityEvent && ((Divinity)this.plugin).getPluginManager().isPluginEnabled("Fabled")) {
            EntityDamageByEntityEvent ede = (EntityDamageByEntityEvent)e;
            FabledHook fabledHook = (FabledHook)((Divinity)this.plugin).getHook("Fabled");
            if (Objects.requireNonNull(fabledHook).isFakeDamage(ede)) {
                return;
            }
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity zertva = (LivingEntity)e.getEntity();
        if (zertva instanceof ArmorStand || zertva.isInvulnerable()) {
            return;
        }
        DamageMeta meta = EntityStats.get(zertva).getLastDamageMeta();
        if (meta == null || e.isCancelled() && !meta.isDodged()) {
            return;
        }
        meta.addMissingDmg(e.getDamage());
        double dmgTotal = meta.getTotalDamage();
        if (dmgTotal <= 0.0 && this.ignoreZeroDamage && !meta.isDodged()) {
            return;
        }
        this.sendCombatLog(meta, dmgTotal);
        if (this.indicatorExpansion != null) {
            this.indicatorExpansion.create(meta);
        }
    }

    @Generated
    public boolean isIgnoreZeroDamage() {
        return this.ignoreZeroDamage;
    }

    static enum MessageType {
        NORMAL,
        CRITICAL,
        DODGE,
        BLOCK;

        private boolean enabled = false;
        private String msgDamager = null;
        private String msgVictim = null;
        private String msgIndicator = null;
        private Keyed sound = null;

        @Nullable
        public String getMessageDamager() {
            return this.msgDamager;
        }

        public void setMessageDamager(@Nullable String msgDamager) {
            this.msgDamager = msgDamager != null ? StringUT.color((String)msgDamager) : msgDamager;
        }

        @Nullable
        public String getMessageVictim() {
            return this.msgVictim;
        }

        public void setMessageVictim(@Nullable String msgVictim) {
            this.msgVictim = msgVictim != null ? StringUT.color((String)msgVictim) : msgVictim;
        }

        @Nullable
        public String getMessageIndicator() {
            return this.msgIndicator;
        }

        public void setMessageIndicator(@Nullable String msgIndicator) {
            this.msgIndicator = msgIndicator != null ? StringUT.color((String)msgIndicator) : msgIndicator;
        }

        public void setSound(@Nullable Keyed sound) {
            this.sound = sound;
        }

        public void playSound(@NotNull Player player) {
            if (this.sound != null) {
                player.playSound(player.getLocation(), this.sound.getKey().toString(), 0.8f, 0.8f);
            }
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    class IndicatorExpansion {
        private Map<Hologram, Integer> map;
        private UpTask taskUp;

        IndicatorExpansion() {
        }

        public void setup() {
            this.map = new HashMap<Hologram, Integer>();
            this.taskUp = new UpTask();
            this.taskUp.start();
        }

        public void shutdown() {
            if (this.taskUp != null) {
                this.taskUp.stop();
                this.taskUp = null;
            }
            if (this.map != null) {
                for (Hologram hologram : this.map.keySet()) {
                    hologram.delete();
                }
                this.map.clear();
                this.map = null;
            }
        }

        public void create(@NotNull DamageMeta meta) {
            ArrayList<String> list = new ArrayList<String>();
            for (String holoText : CombatLogManager.this.indicatorOrder) {
                if (holoText.equalsIgnoreCase("%dodge%") && meta.isDodged()) {
                    list.add(MessageType.DODGE.getMessageIndicator());
                    break;
                }
                if (holoText.equalsIgnoreCase("%critical%") && meta.isCritical()) {
                    list.add(MessageType.CRITICAL.getMessageIndicator());
                    continue;
                }
                if (holoText.equalsIgnoreCase("%block%") && meta.isBlocked()) {
                    list.add(MessageType.BLOCK.getMessageIndicator());
                    continue;
                }
                if (!holoText.equalsIgnoreCase("%damage%")) continue;
                for (Map.Entry<DamageAttribute, Double> e : meta.getDamages().entrySet()) {
                    double dmgType = e.getValue();
                    if (!(dmgType > 0.0)) continue;
                    String line = CombatLogManager.this.getDamageTypeFormat(e.getKey().getId());
                    list.add(line.replace("%damage%", NumberUT.format((double)dmgType)));
                }
            }
            Location loc = meta.getVictim().getEyeLocation().clone().add(0.0, 0.9, 0.0);
            this.create(loc, list);
        }

        public void create(@NotNull Location loc, @NotNull List<String> list) {
            if (list.isEmpty()) {
                return;
            }
            ((Divinity)CombatLogManager.this.plugin).getServer().getScheduler().runTask((Plugin)CombatLogManager.this.plugin, () -> {
                Hologram holo = HolographicDisplaysAPI.get((Plugin)CombatLogManager.this.plugin).createHologram(loc);
                for (String line : list) {
                    holo.getLines().appendText(line);
                }
                this.map.put(holo, 1);
            });
        }

        class UpTask
        extends ITask<Divinity> {
            public UpTask() {
                super((CodexPlugin)((Divinity)CombatLogManager.this.plugin), 1L, false);
            }

            public void action() {
                for (Map.Entry<Hologram, Integer> e : new HashMap<Hologram, Integer>(IndicatorExpansion.this.map).entrySet()) {
                    Hologram holo = e.getKey();
                    int yStack = e.getValue();
                    holo.setPosition(holo.getPosition().add(0.0, 0.11, 0.0));
                    if (yStack++ >= 20) {
                        IndicatorExpansion.this.map.remove(holo);
                        holo.delete();
                        continue;
                    }
                    IndicatorExpansion.this.map.put(holo, yStack);
                }
            }
        }
    }
}

