/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.object.ExpSource;

public class AddLevelCmd
extends MCmd<ClassManager> {
    public AddLevelCmd(@NotNull ClassManager module) {
        super(module, new String[]{"addlevel"}, "quantumrpg.classes.cmd.addlevel");
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_AddLevel_Desc.getMsg();
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Classes_Cmd_AddLevel_Usage.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return PlayerUT.getPlayerNames();
        }
        if (i == 2) {
            return Arrays.asList("<amount>");
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length != 3) {
            this.printUsage(sender);
            return;
        }
        int levels = this.getNumI(sender, args[2], 0);
        if (levels == 0) {
            return;
        }
        Player player = ((Divinity)this.plugin).getServer().getPlayer(args[1]);
        String name = "";
        for (int i = 0; i < levels; ++i) {
            if (player != null) {
                UserClassData cData = ((ClassManager)this.module).getUserData(player);
                if (cData == null) {
                    ((Divinity)this.plugin).lang().Classes_Cmd_AddLevel_Error_NoClass.send(sender);
                    return;
                }
                int amount = cData.getExpToUp(true);
                if (levels < 0) {
                    amount = -amount;
                }
                ((ClassManager)this.module).getLevelingManager().addExp(player, amount, sender.getName(), ExpSource.INTERNAL);
                name = player.getName();
                continue;
            }
            DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(args[1], false);
            if (user == null) {
                this.errPlayer(sender);
                return;
            }
            UserProfile prof = user.getActiveProfile();
            UserClassData cData = prof.getClassData();
            if (cData == null) {
                ((Divinity)this.plugin).lang().Classes_Cmd_AddLevel_Error_NoClass.send(sender);
                return;
            }
            int amount = cData.getExpToUp(true);
            if (levels < 0) {
                amount = -amount;
            }
            cData.addExp(amount);
            name = user.getName();
        }
        ((Divinity)this.plugin).lang().Classes_Cmd_AddLevel_Done.replace("%amount%", (Object)String.valueOf(levels)).replace("%name%", (Object)name).send(sender);
    }
}

