/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.api;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.util.FileUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.TimeUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.api.UserSkillData;
import studio.magemonkey.divinity.modules.list.classes.event.PlayerCastSkillEvent;
import studio.magemonkey.divinity.modules.list.classes.event.PlayerPreCastSkillEvent;

public abstract class IAbstractSkill
extends IListener<Divinity> {
    protected JYML cfg;
    protected ClassManager classManager;
    protected String name;
    protected int maxLvl;
    protected List<String> desc;
    protected ItemStack icon;
    protected TreeMap<Integer, Integer> spCost;
    protected TreeMap<Integer, Double> manaCost;
    protected TreeMap<Integer, Integer> cooldown;
    protected TreeMap<Integer, Map<String, Integer>> lvlClassReq;
    protected TreeMap<Integer, Map<String, Integer>> lvlSkillReq;
    public static final Map<String, Map<String, Long>> COOLDOWNS = new HashMap<String, Map<String, Long>>();

    public IAbstractSkill(@NotNull Divinity plugin) {
        super((JavaPlugin)plugin);
    }

    @NotNull
    public abstract String getId();

    public final void load(@NotNull ClassManager m) {
        this.classManager = m;
        try {
            int minLvl;
            HashMap<String, Integer> clazLvl;
            int lvl;
            File f2;
            File f = new File(m.getFullPath() + "/skills/" + this.getId());
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!(f2 = new File(m.getFullPath() + "/skills/" + this.getId(), "config.yml")).exists()) {
                FileUT.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/config.yml"), (File)f2);
            }
            this.cfg = new JYML(f2);
            this.cfg.options().copyDefaults(true);
            this.cfg.addMissing("name", (Object)this.getId());
            this.cfg.addMissing("max-level", (Object)1);
            if (!this.cfg.contains("description")) {
                this.cfg.set("description", Arrays.asList("&7Skill description here..."));
            }
            if (!this.cfg.contains("icon")) {
                JIcon icon = new JIcon(Material.GOLDEN_AXE);
                icon.setName("%name%");
                icon.addLore(new String[]{"%description%"});
                this.cfg.setItem("icon", icon.build());
            }
            if (!this.cfg.contains("skill-points-cost-by-level")) {
                this.cfg.addMissing("skill-points-cost-by-level.1", (Object)5);
            }
            if (!this.cfg.contains("mana-cost-by-level")) {
                this.cfg.addMissing("mana-cost-by-level.1", (Object)5);
            }
            if (!this.cfg.contains("cooldown-by-level")) {
                this.cfg.addMissing("cooldown-by-level.1", (Object)5);
            }
            if (!this.cfg.contains("required-classes-and-levels")) {
                this.cfg.set("required-classes-and-levels.1.Warrior", (Object)10);
                this.cfg.set("required-classes-and-levels.1.Templar", (Object)7);
                this.cfg.set("required-classes-and-levels.1.Archer", (Object)11);
            }
            if (!this.cfg.contains("required-skills-and-levels")) {
                this.cfg.set("required-skills-and-levels.1.SomeSkill", (Object)1);
                this.cfg.set("required-skills-and-levels.1.AnotherSkill", (Object)2);
            }
            this.cfg.saveChanges();
            this.name = StringUT.color((String)this.cfg.getString("name", this.getId()));
            this.maxLvl = this.cfg.getInt("max-level", 1);
            this.desc = this.cfg.getStringList("description");
            this.icon = this.cfg.getItem("icon");
            this.spCost = new TreeMap();
            for (String sLvl : this.cfg.getSection("skill-points-cost-by-level")) {
                lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                this.spCost.put(lvl, this.cfg.getInt("skill-points-cost-by-level." + sLvl));
            }
            this.manaCost = new TreeMap();
            for (String sLvl : this.cfg.getSection("mana-cost-by-level")) {
                lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                this.manaCost.put(lvl, this.cfg.getDouble("mana-cost-by-level." + sLvl));
            }
            this.cooldown = new TreeMap();
            for (String sLvl : this.cfg.getSection("cooldown-by-level")) {
                lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                this.cooldown.put(lvl, this.cfg.getInt("cooldown-by-level." + sLvl));
            }
            this.lvlClassReq = new TreeMap();
            for (String sLvl : this.cfg.getSection("required-classes-and-levels")) {
                lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                clazLvl = new HashMap<String, Integer>();
                for (String sClas : this.cfg.getSection("required-classes-and-levels." + sLvl)) {
                    minLvl = this.cfg.getInt("required-classes-and-levels." + sLvl + "." + sClas);
                    clazLvl.put(sClas.toLowerCase(), minLvl);
                }
                this.lvlClassReq.put(lvl, clazLvl);
            }
            this.lvlSkillReq = new TreeMap();
            for (String sLvl : this.cfg.getSection("required-skills-and-levels")) {
                lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                clazLvl = new HashMap();
                for (String sClas : this.cfg.getSection("required-skills-and-levels." + sLvl)) {
                    minLvl = this.cfg.getInt("required-skills-and-levels." + sLvl + "." + sClas);
                    clazLvl.put(sClas.toLowerCase(), minLvl);
                }
                this.lvlSkillReq.put(lvl, clazLvl);
            }
            this.setup();
            this.registerListeners();
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load skill '" + this.getId() + "': Configuration error");
            e.printStackTrace();
            this.shutdown();
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public final void unload() {
        this.shutdown();
        this.unregisterListeners();
    }

    public abstract void setup();

    public abstract void shutdown();

    public final boolean canUse(@NotNull Player caster, int lvl, boolean msg) {
        int manaHas;
        if (this.isOnCooldown(caster)) {
            if (msg) {
                ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Cooldown.replace("%time%", (Object)TimeUT.formatTimeLeft((long)this.getActiveCooldown(caster))).replace("%skill%", (Object)this.getName()).send((CommandSender)caster);
            }
            return false;
        }
        UserClassData cData = this.classManager.getUserData(caster);
        if (cData == null) {
            return false;
        }
        String userClass = cData.getPlayerClass().getId();
        int req = this.getMinClassLevelRequirement(lvl, userClass);
        if (req >= 0) {
            int userLvl = cData.getLevel();
            if (userLvl < req) {
                if (msg) {
                    ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Level.replace("%lvl%", (Object)String.valueOf(req)).send((CommandSender)caster);
                }
                return false;
            }
        } else {
            if (msg) {
                ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Class.replace("%class%", (Object)cData.getPlayerClass().getName()).send((CommandSender)caster);
            }
            return false;
        }
        double manaReq = this.getManaCost(lvl);
        if (manaReq > 0.0 && (double)(manaHas = cData.getMana()) < manaReq) {
            if (msg) {
                ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Mana.send((CommandSender)caster);
            }
            return false;
        }
        Map.Entry<Integer, Map<String, Integer>> eSkills = this.lvlSkillReq.floorEntry(lvl);
        if (eSkills != null) {
            for (Map.Entry<String, Integer> e : eSkills.getValue().entrySet()) {
                int reqSkill;
                String skillId = e.getKey();
                IAbstractSkill skillReq = this.classManager.getSkillById(skillId);
                if (skillReq == null) continue;
                UserSkillData sData = cData.getSkillData(skillId);
                if (sData == null) {
                    if (msg) {
                        ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Skill_Learn.replace("%skill%", (Object)skillReq.getName()).send((CommandSender)caster);
                    }
                    return false;
                }
                int userSkillLvl = sData.getLevel();
                if (userSkillLvl >= (reqSkill = e.getValue().intValue())) continue;
                if (msg) {
                    ((Divinity)this.plugin).lang().Classes_Skill_Cast_Error_Skill_Level.replace("%skill%", (Object)skillReq.getName()).replace("%lvl%", (Object)String.valueOf(reqSkill)).send((CommandSender)caster);
                }
                return false;
            }
        }
        return true;
    }

    public boolean cast(@NotNull Player caster, @NotNull ItemStack weapon, int lvl, boolean force) {
        if (this.isPassive()) {
            return false;
        }
        UserClassData classData = this.classManager.getUserData(caster);
        if (classData == null) {
            return false;
        }
        if (!force && !this.canUse(caster, lvl, !this.isPassive())) {
            return false;
        }
        PlayerPreCastSkillEvent e = new PlayerPreCastSkillEvent(caster, classData, this);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        if (this.onCast(caster, weapon, lvl, force)) {
            double manaReq = this.getManaCost(lvl);
            this.classManager.consumeMana(caster, manaReq, false);
            this.addCooldown(caster, lvl);
            PlayerCastSkillEvent e2 = new PlayerCastSkillEvent(caster, classData, this);
            ((Divinity)this.plugin).getPluginManager().callEvent((Event)e2);
            return true;
        }
        return false;
    }

    protected abstract boolean onCast(@NotNull Player var1, @NotNull ItemStack var2, int var3, boolean var4);

    public final void addCooldown(@NotNull Player player, int lvl) {
        UserClassData data = this.classManager.getUserData(player);
        if (data == null) {
            return;
        }
        double reduce = 0.0;
        double cd = (double)this.getCooldown(lvl) * (1.0 - reduce / 100.0) * 1000.0;
        if (cd <= 0.0) {
            return;
        }
        Map<String, Long> map = COOLDOWNS.get(player.getName());
        if (map == null) {
            map = new HashMap<String, Long>();
        }
        map.put(this.getId().toLowerCase(), System.currentTimeMillis() + (long)((int)cd));
        COOLDOWNS.put(player.getName(), map);
    }

    public final boolean isOnCooldown(@NotNull Player player) {
        return System.currentTimeMillis() <= this.getActiveCooldown(player);
    }

    public final long getActiveCooldown(@NotNull Player player) {
        Map<String, Long> map = COOLDOWNS.get(player.getName());
        if (map == null) {
            return 0L;
        }
        return map.getOrDefault(this.getId().toLowerCase(), 0L);
    }

    protected final boolean hasSkill(@NotNull Player player) {
        return this.getSkillLevel(player) > 0;
    }

    protected final int getSkillLevel(@NotNull Player player) {
        int lvl = -1;
        UserClassData data = this.classManager.getUserData(player);
        if (data == null) {
            return lvl;
        }
        UserSkillData sData = data.getSkillData(this.getId());
        if (sData == null) {
            return lvl;
        }
        return sData.getLevel();
    }

    public abstract String getAuthor();

    public abstract boolean isPassive();

    public abstract boolean canBeStigma();

    public abstract boolean canBeBook();

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getDescription(@Nullable Player player, int lvl) {
        ArrayList<String> desc = new ArrayList<String>();
        String upCost = String.valueOf(this.getSkillPointsCost(lvl));
        String level = String.valueOf(lvl);
        String rLevel = NumberUT.toRoman((int)lvl);
        String cooldown = TimeUT.formatTime((long)((long)this.getCooldown(lvl) * 1000L));
        String manaCost = String.valueOf(this.getManaCost(lvl));
        for (String s : new ArrayList<String>(this.desc)) {
            String s2;
            int cLvl;
            String cId;
            Map<String, Integer> map;
            if (s.contains("%req-class%")) {
                if (!this.lvlClassReq.containsKey(lvl)) continue;
                map = this.lvlClassReq.get(lvl);
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    cId = e.getKey();
                    RPGClass c = this.classManager.getClassById(cId);
                    if (c == null) continue;
                    cLvl = e.getValue();
                    s2 = s.replace("%req-class%", c.getName()).replace("%req-level%", String.valueOf(cLvl));
                    desc.add(s2);
                }
                continue;
            }
            if (s.contains("%req-skill%")) {
                if (!this.lvlSkillReq.containsKey(lvl)) continue;
                map = this.lvlSkillReq.get(lvl);
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    cId = e.getKey();
                    IAbstractSkill skill = this.classManager.getSkillById(cId);
                    if (skill == null) continue;
                    cLvl = e.getValue();
                    s2 = s.replace("%req-skill%", skill.getName()).replace("%req-level%", String.valueOf(cLvl));
                    desc.add(s2);
                }
                continue;
            }
            if (s.contains("%upgrade-cost%") && lvl >= this.getMaxLevel()) continue;
            desc.add(s.replace("%upgrade-cost%", upCost).replace("%level%", level).replace("%rlevel%", rLevel).replace("%cooldown%", cooldown).replace("%mana-cost%", manaCost));
        }
        return StringUT.color(desc);
    }

    public final int getMaxLevel() {
        return this.maxLvl;
    }

    @NotNull
    public ItemStack getIcon(@Nullable Player player, int lvl) {
        ItemStack item = new ItemStack(this.icon);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String level = String.valueOf(lvl);
        String rLevel = NumberUT.toRoman((int)lvl);
        if (meta.hasDisplayName()) {
            String name = meta.getDisplayName().replace("%level%", level).replace("%rlevel%", rLevel).replace("%name%", this.getName());
            meta.setDisplayName(name);
        }
        List lore = meta.getLore();
        ArrayList<String> lore2 = new ArrayList<String>();
        if (lore != null) {
            for (String s : lore) {
                if (s.contains("%description%")) {
                    for (String s2 : this.getDescription(player, lvl)) {
                        lore2.add(s2);
                    }
                    continue;
                }
                lore2.add(s);
            }
            meta.setLore(lore2);
        }
        item.setItemMeta(meta);
        return item;
    }

    public final int getMinSkillLevelRequirement(int lvl, @NotNull String skill) {
        Map.Entry<Integer, Map<String, Integer>> e = this.lvlSkillReq.floorEntry(lvl);
        if (e == null) {
            return -1;
        }
        return e.getValue().getOrDefault(skill.toLowerCase(), -1);
    }

    public final int getMinClassLevelRequirement(int lvl, @NotNull String clazz) {
        Map.Entry<Integer, Map<String, Integer>> e = this.lvlClassReq.floorEntry(lvl);
        if (e == null) {
            return -1;
        }
        return e.getValue().getOrDefault(clazz.toLowerCase(), -1);
    }

    public final int getSkillPointsCost(int lvl) {
        return this.getValueForLevel(lvl, this.spCost);
    }

    public final int getCooldown(int lvl) {
        return this.getValueForLevel(lvl, this.cooldown);
    }

    public final double getManaCost(int lvl) {
        return this.getDoubleValueForLevel(lvl, this.manaCost);
    }

    protected final void fillMapValues(@NotNull TreeMap<Integer, Double> map, @NotNull JYML cfg, @NotNull String path) {
        for (String sLvl : cfg.getSection(path)) {
            int lvl = StringUT.getInteger((String)sLvl, (int)-1);
            if (lvl < 1) continue;
            double potionLvl = cfg.getDouble(path + "." + sLvl);
            map.put(lvl, potionLvl);
        }
    }

    protected final int getValueForLevel(int lvl, @NotNull TreeMap<Integer, Integer> map) {
        Map.Entry<Integer, Integer> e = map.floorEntry(lvl);
        if (e == null) {
            return 0;
        }
        return e.getValue();
    }

    protected final double getDoubleValueForLevel(int lvl, @NotNull TreeMap<Integer, Double> map) {
        Map.Entry<Integer, Double> e = map.floorEntry(lvl);
        if (e == null) {
            return 0.0;
        }
        return e.getValue();
    }
}

