/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.MsgUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.manager.effects.IEffectType;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.api.UserSkillData;
import studio.magemonkey.divinity.modules.list.classes.event.PlayerComboProcessEvent;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.utils.ItemUtils;

public class ComboManager
extends IListener<Divinity>
implements Loadable {
    private ClassManager classManager;
    private JYML cfg;
    private Set<String> allowedGroups;
    private int comboLength;
    private long comboCheckTime;
    private int comboKeyTime;
    private ComboKey comboStartKey;
    private ComboKey comboStartAltKey;
    private String comboKeyNameNext;
    private String comboKeyNameSeparator;
    private String comboSoundKeyClick;
    private String comboSoundEmpty;
    private Set<String> comboStop;
    private ComboTask comboTask;
    private Map<Player, ComboInfo> comboUser;
    private static String guiTitle = null;
    private static int guiSize = 54;
    private static int[] guiComboSlots = new int[1];
    private static Map<ComboKey, ItemStack> guiKeyCache = new HashMap<ComboKey, ItemStack>();

    ComboManager(@NotNull ClassManager classManager) {
        super((JavaPlugin)((Divinity)classManager.plugin));
        this.classManager = classManager;
    }

    public void setup() {
        this.comboStop = new HashSet<String>();
        this.comboUser = new WeakHashMap<Player, ComboInfo>();
        try {
            this.cfg = JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)(this.classManager.getPath() + "combo.yml"));
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load combo config (" + this.classManager.getPath() + "combo.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        String path = "settings.";
        if (!this.cfg.contains(path + "allowed-items")) {
            this.cfg.set(path + "weapon-only", null);
            this.cfg.set(path + "allowed-items", Arrays.asList("WEAPON"));
        }
        this.allowedGroups = this.cfg.getStringSet(path + "allowed-items").stream().map(String::toLowerCase).collect(Collectors.toSet());
        path = "settings.combo.";
        this.comboLength = Math.min(ComboKey.values().length, this.cfg.getInt(path + "length"));
        this.comboCheckTime = this.cfg.getInt(path + "check-time", 5);
        this.comboKeyTime = this.cfg.getInt(path + "key-time", 30);
        path = "settings.combo.keys.";
        try {
            this.comboStartKey = ComboKey.valueOf(this.cfg.getString(path + "start-main", "RIGHT").toUpperCase());
            this.comboStartAltKey = ComboKey.valueOf(this.cfg.getString(path + "start-alternative", "LEFT").toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            this.comboStartKey = ComboKey.RIGHT;
            this.comboStartAltKey = ComboKey.LEFT;
        }
        path = "settings.combo.keys.names.";
        this.comboKeyNameNext = StringUT.color((String)this.cfg.getString(path + "next", "&8&l?"));
        this.comboKeyNameSeparator = StringUT.color((String)this.cfg.getString(path + "separator", " &f&l- "));
        for (ComboKey key : ComboKey.values()) {
            String name = this.cfg.getString(path + key.name());
            if (name == null) continue;
            key.setName(name);
        }
        path = "settings.combo.sounds.";
        this.comboSoundKeyClick = this.cfg.getString(path + "key-click", "UI_BUTTON_CLICK");
        this.comboSoundEmpty = this.cfg.getString(path + "combo-empty", "ENTITY_VILLAGER_NO");
        this.comboTask = new ComboTask();
        this.comboTask.start();
        this.registerListeners();
        this.cfg.saveChanges();
    }

    public void shutdown() {
        if (this.comboTask != null) {
            this.comboTask.stop();
            this.comboTask = null;
        }
        if (this.comboUser != null) {
            this.comboUser.clear();
            this.comboUser = null;
        }
        if (this.comboStop != null) {
            this.comboStop.clear();
            this.comboStop = null;
        }
        this.unregisterListeners();
    }

    public void openGUI(@NotNull Player player, @NotNull UserSkillData data) {
        if (guiTitle == null) {
            guiTitle = this.cfg.getString("gui.title", "Skill Combo");
            guiSize = this.cfg.getInt("gui.size", 54);
            guiComboSlots = this.cfg.getIntArray("gui.combo-slots");
        }
        GUI gui = new GUI(guiTitle, guiSize, data);
        gui.open(player, 1);
    }

    @Nullable
    public ComboInfo getCombo(@NotNull Player player) {
        return this.comboUser.get(player);
    }

    private void printComboInfo(@NotNull Player player, @NotNull ComboInfo comboInfo) {
        StringBuilder msg = new StringBuilder();
        for (ComboKey key : comboInfo.getKeys()) {
            if (key == null) continue;
            if (msg.length() > 0) {
                msg.append(this.comboKeyNameSeparator);
            }
            msg.append(key.getName());
        }
        if (!comboInfo.isComplete()) {
            int max = this.comboLength;
            int has = comboInfo.getCount();
            for (int i = 0; i < max - has; ++i) {
                msg.append(this.comboKeyNameSeparator).append(this.comboKeyNameNext);
            }
        }
        MsgUT.sendActionBar((Player)player, (String)StringUT.color((String)msg.toString()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClassCombo(PlayerInteractEvent e) {
        if (e.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Block block = e.getClickedBlock();
        ItemStack wpn = e.getItem();
        if (!ItemUT.isAir((ItemStack)wpn) && e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (wpn == null || !this.isAllowedItem(wpn)) {
            return;
        }
        if (block != null && (block.getType().isInteractable() || e.useInteractedBlock() == Event.Result.DENY)) {
            return;
        }
        Player player = e.getPlayer();
        if (!(ItemUT.isAir((ItemStack)wpn) || wpn.getType() != Material.FISHING_ROD || this.getCombo(player) != null || e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        ComboKey key = ComboKey.getFromAction(e.getAction(), player.isSneaking());
        if (key == null) {
            return;
        }
        if (this.processCombo(player, key)) {
            ItemStack off = player.getInventory().getItemInOffHand();
            if (ItemUT.isAir((ItemStack)off) || off.getType() != Material.SHIELD) {
                e.setUseItemInHand(Event.Result.DENY);
                e.setUseInteractedBlock(Event.Result.DENY);
            }
            if (!(ItemUT.isAir((ItemStack)wpn) || wpn.getType() != Material.FISHING_ROD || e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK)) {
                this.stopCombo(e.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClassComboQ(PlayerDropItemEvent e) {
        ComboKey key;
        Player player = e.getPlayer();
        if (this.processCombo(player, key = ComboKey.Q)) {
            e.setCancelled(true);
            this.stopCombo(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClassComboF(PlayerSwapHandItemsEvent e) {
        ComboKey key;
        Player player = e.getPlayer();
        if (this.processCombo(player, key = ComboKey.F)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClassComboFish(PlayerFishEvent e) {
        this.stopCombo(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClassCombo2(PlayerInteractEntityEvent e) {
        if (e.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack wpn = player.getInventory().getItemInMainHand();
        if (ItemUT.isAir((ItemStack)wpn) || !this.isAllowedItem(wpn)) {
            return;
        }
        ComboKey key = ComboKey.getFromAction(Action.RIGHT_CLICK_BLOCK, player.isSneaking());
        if (key == null) {
            return;
        }
        this.processCombo(player, key);
        this.stopCombo(player);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onClassCombo3(EntityDamageByEntityEvent e) {
        Entity e2 = e.getDamager();
        if (!(e2 instanceof Player)) {
            return;
        }
        Player player = (Player)e.getDamager();
        ItemStack wpn = player.getInventory().getItemInMainHand();
        if (ItemUT.isAir((ItemStack)wpn) || !this.isAllowedItem(wpn)) {
            return;
        }
        ComboKey key = ComboKey.getFromAction(Action.LEFT_CLICK_BLOCK, player.isSneaking());
        if (key == null) {
            return;
        }
        this.processCombo(player, key);
        this.stopCombo(player);
    }

    public void playAttackAnim(@NotNull Player player, boolean main) {
        int animId = main ? 0 : 3;
        this.stopCombo(player);
        VersionManager.getNms().sendAttackPacket(player, animId);
    }

    public void stopCombo(@NotNull Player p) {
        this.comboStop.add(p.getName());
    }

    private boolean isAllowedItem(@NotNull ItemStack item) {
        return this.allowedGroups.contains("*") || ItemUtils.compareItemGroup(item, this.allowedGroups.toArray(new String[this.allowedGroups.size()]));
    }

    private boolean isAltComboItem(@Nullable ItemStack wpn) {
        if (wpn == null) {
            return false;
        }
        return ItemUtils.isBow(wpn) || wpn.getType() == Material.FISHING_ROD || wpn.getType() == Material.TRIDENT;
    }

    private boolean processCombo(@NotNull Player player, @NotNull ComboKey key) {
        EntityStats es = EntityStats.get((LivingEntity)player);
        if (es.hasEffect(IEffectType.CONTROL_STUN) || es.hasEffect(IEffectType.SILENCE)) {
            return false;
        }
        UserClassData classData = this.classManager.getUserData(player);
        if (classData == null) {
            return false;
        }
        if (this.comboStop.contains(player.getName())) {
            this.comboStop.remove(player.getName());
            return false;
        }
        ComboInfo comboBuilder = this.getCombo(player);
        if (comboBuilder == null) {
            if (this.comboLength > 1) {
                ComboKey start = this.comboStartKey;
                ItemStack wpn = player.getInventory().getItemInMainHand();
                if (this.isAltComboItem(wpn)) {
                    start = this.comboStartAltKey;
                }
                if (key != start) {
                    return false;
                }
            }
            comboBuilder = new ComboInfo();
        } else if (!comboBuilder.isExpired() && comboBuilder.isComplete()) {
            return false;
        }
        PlayerComboProcessEvent e = new PlayerComboProcessEvent(player, classData, key, comboBuilder);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        if (comboBuilder.addKey(key, this.comboKeyTime)) {
            MsgUT.sound((Player)player, (String)this.comboSoundKeyClick);
            this.printComboInfo(player, comboBuilder);
        }
        this.comboUser.put(player, comboBuilder);
        return true;
    }

    public static enum ComboKey {
        LEFT("L"),
        RIGHT("R"),
        SHIFT_LEFT("SL"),
        SHIFT_RIGHT("SR"),
        Q("Q"),
        F("F");

        private String name;

        private ComboKey(String name) {
            this.setName(name);
        }

        public void setName(@NotNull String name) {
            this.name = StringUT.color((String)name);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public static ComboKey getFromAction(@NotNull Action a, boolean sneak) {
            if (a == Action.LEFT_CLICK_AIR || a == Action.LEFT_CLICK_BLOCK) {
                return sneak ? SHIFT_LEFT : LEFT;
            }
            if (a == Action.RIGHT_CLICK_AIR || a == Action.RIGHT_CLICK_BLOCK) {
                return sneak ? SHIFT_RIGHT : RIGHT;
            }
            return null;
        }
    }

    class ComboTask
    extends ITask<Divinity> {
        public ComboTask() {
            super((CodexPlugin)((Divinity)ComboManager.this.plugin), ComboManager.this.comboCheckTime, true);
        }

        public void action() {
            for (Player player : ((Divinity)this.plugin).getServer().getOnlinePlayers()) {
                ComboInfo comboInfo;
                if (player == null || (comboInfo = ComboManager.this.getCombo(player)) == null) continue;
                comboInfo.tick(ComboManager.this.comboCheckTime);
                if (comboInfo.isExpired()) {
                    ((Divinity)this.plugin).lang().Classes_Skill_Cast_Cancel.send((CommandSender)player);
                    ComboManager.this.comboUser.remove(player);
                    continue;
                }
                if (!comboInfo.isComplete()) continue;
                ComboManager.this.comboUser.remove(player);
                ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!ComboManager.this.classManager.castSkill(player, comboInfo.getKeys())) {
                        MsgUT.sound((Player)player, (String)ComboManager.this.comboSoundEmpty);
                    }
                });
            }
        }
    }

    class GUI
    extends NGUI<Divinity> {
        private UserSkillData data;

        public GUI(String title, @NotNull int size, final UserSkillData data) {
            super((CodexPlugin)((Divinity)ComboManager.this.plugin), title, size);
            this.data = data;
            GuiClick click = new GuiClick(){

                public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                    if (type == null) {
                        return;
                    }
                    Inventory inv = e.getInventory();
                    if (type.getClass().equals(GUIComboType.class)) {
                        GUIComboType type2 = (GUIComboType)type;
                        block0 : switch (type2.ordinal()) {
                            case 7: {
                                ComboManager.this.classManager.openSkillsGUI(p);
                                break;
                            }
                            case 8: {
                                for (int slot : guiComboSlots) {
                                    inv.setItem(slot, null);
                                }
                                break;
                            }
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                for (int comboSlot : guiComboSlots) {
                                    ItemStack c = inv.getItem(comboSlot);
                                    if (c != null && c.getType() != Material.AIR) continue;
                                    GuiItem button = GUI.this.getButton(p, e.getRawSlot());
                                    if (button == null) {
                                        return;
                                    }
                                    GuiItem buttonClone = new GuiItem(button);
                                    buttonClone.setSlots(new int[]{comboSlot});
                                    GUI.this.addButton(buttonClone);
                                    inv.setItem(comboSlot, e.getCurrentItem());
                                    break block0;
                                }
                                break;
                            }
                            case 6: {
                                ComboKey[] comboBuilder = new ComboKey[ComboManager.this.comboLength];
                                int count = 0;
                                for (int slot : guiComboSlots) {
                                    GuiItem comboButton = GUI.this.getButton(p, slot);
                                    if (comboButton == null) continue;
                                    Enum gType = comboButton.getType();
                                    if (gType == null || !gType.getClass().equals(GUIComboType.class)) {
                                        return;
                                    }
                                    ComboKey key = ((GUIComboType)gType).getAssignedKey();
                                    if (key == null) continue;
                                    comboBuilder[count++] = key;
                                    if (count == ComboManager.this.comboLength) break;
                                }
                                if (count > 0 && count != ComboManager.this.comboLength) {
                                    return;
                                }
                                data.setCombo(comboBuilder);
                                p.closeInventory();
                                ComboManager.this.classManager.openSkillsGUI(p);
                                break;
                            }
                        }
                    }
                }
            };
            for (String sId : ComboManager.this.cfg.getSection("gui.content")) {
                String path = "gui.content." + sId;
                GuiItem gi = ComboManager.this.cfg.getGuiItem(path, GUIComboType.class);
                if (gi == null) continue;
                Enum eType = gi.getType();
                if (eType != null && eType.getClass().equals(GUIComboType.class)) {
                    GUIComboType btnType = (GUIComboType)eType;
                    ComboKey key = btnType.getAssignedKey();
                    if (key != null) {
                        guiKeyCache.putIfAbsent(key, gi.getItem());
                    }
                    gi.setClick(click);
                }
                this.addButton(gi);
            }
        }

        protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
            int count = 0;
            for (ComboKey key : this.data.getCombo()) {
                ItemStack item = guiKeyCache.get((Object)key);
                if (item == null) continue;
                inv.setItem(guiComboSlots[count++], item);
            }
        }

        protected boolean cancelClick(int slot) {
            return true;
        }

        protected boolean cancelPlayerClick() {
            return true;
        }

        protected boolean ignoreNullClick() {
            return true;
        }

        public boolean destroyWhenNoViewers() {
            return true;
        }
    }

    public class ComboInfo {
        private int count = 0;
        private ComboKey[] keys;
        private long ticksLeft = 0L;

        public ComboInfo() {
            this.keys = new ComboKey[ComboManager.this.comboLength];
        }

        public boolean addKey(@NotNull ComboKey key, int ticks) {
            if (this.isComplete() || this.isExpired()) {
                return false;
            }
            this.keys[this.count++] = key;
            this.ticksLeft = ticks;
            return true;
        }

        public boolean isExpired() {
            return this.count > 0 && this.ticksLeft <= 0L;
        }

        public void tick(long lvlComboCheckTime) {
            this.ticksLeft = Math.max(0L, this.ticksLeft - lvlComboCheckTime);
        }

        public ComboKey[] getKeys() {
            return this.keys;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isComplete() {
            return this.count == ComboManager.this.comboLength;
        }
    }

    static enum GUIComboType {
        COMBO_LEFT(ComboKey.LEFT),
        COMBO_RIGHT(ComboKey.RIGHT),
        COMBO_SHIFT_LEFT(ComboKey.SHIFT_LEFT),
        COMBO_SHIFT_RIGHT(ComboKey.SHIFT_RIGHT),
        COMBO_Q(ComboKey.Q),
        COMBO_F(ComboKey.F),
        COMBO_SAVE,
        COMBO_CANCEL,
        COMBO_CLEAR;

        private ComboKey key;

        private GUIComboType() {
            this(null);
        }

        private GUIComboType(ComboKey key) {
            this.key = key;
        }

        @Nullable
        public ComboKey getAssignedKey() {
            return this.key;
        }
    }
}

