/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAspect;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAspectBonus;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAttribute;
import studio.magemonkey.divinity.modules.list.classes.object.ClassAttributeType;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;

public class AspectManager {
    private Divinity plugin;
    private ClassManager classManager;
    private Map<String, ClassAspect> aspects;
    private GUI gui;

    AspectManager(@NotNull ClassManager classManager) {
        this.classManager = classManager;
        this.plugin = (Divinity)this.classManager.plugin;
    }

    public void setup() {
        JYML cfg;
        this.aspects = new HashMap<String, ClassAspect>();
        try {
            cfg = JYML.loadOrExtract((CodexPlugin)this.plugin, (String)(this.classManager.getPath() + "aspects.yml"));
        }
        catch (InvalidConfigurationException e) {
            this.classManager.error("Failed to load aspects config (" + this.classManager.getPath() + "/aspects.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        for (String aspectId : cfg.getSection("aspects")) {
            String path2 = "aspects." + aspectId + ".";
            String name = cfg.getString(path2 + "name", aspectId);
            Material material = Material.getMaterial((String)cfg.getString(path2 + "material", "").toUpperCase());
            if (material == null) {
                this.classManager.error("Invalid material for aspect: '" + aspectId + "' in '" + cfg.getFile().getName() + "' !");
                continue;
            }
            ClassAspect aspect = new ClassAspect(aspectId, name, material);
            this.aspects.put(aspect.getId(), aspect);
            this.classManager.info("Loaded aspect: " + aspect.getId());
        }
        StringBuilder aspectsStr = new StringBuilder();
        this.getAspects().forEach(asp -> aspectsStr.append(asp.getId()).append(","));
        this.classManager.info("Loaded aspects are: " + String.valueOf(aspectsStr));
        this.gui = new GUI(cfg);
    }

    public void shutdown() {
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.aspects != null) {
            this.aspects.clear();
            this.aspects = null;
        }
    }

    public void openGUI(@NotNull Player player) {
        if (this.classManager.getUserData(player) == null) {
            this.plugin.lang().Classes_Error_NoClass.send((CommandSender)player);
            return;
        }
        this.gui.open(player, 1);
    }

    public void reallocateAspects(@NotNull Player player) {
        UserClassData data = this.classManager.getUserData(player);
        if (data == null) {
            this.plugin.lang().Classes_Error_NoClass.send((CommandSender)player);
            return;
        }
        RPGClass rpgClass = data.getPlayerClass();
        data.getAspects().clear();
        int points = rpgClass.getAspectPointsPerLevel() * (data.getLevel() - rpgClass.getStartLevel());
        for (RPGClass parent : rpgClass.getParents()) {
            points += parent.getAspectPointsPerLevel() * parent.getMaxLevel();
        }
        data.setAspectPoints(points);
        this.classManager.updateClassData(player);
    }

    public void addAspect(@NotNull Player player, @NotNull ClassAspect aspect, int amount, boolean force) {
        UserClassData cData = this.classManager.getUserData(player);
        if (cData == null) {
            return;
        }
        if (!force) {
            ClassAspectBonus a = cData.getPlayerClass().getAspectBonus(aspect);
            if (a == null || a.getMaxValue() >= 0 && cData.getAspect(aspect.getId()) >= a.getMaxValue()) {
                return;
            }
            int points = cData.getAspectPoints();
            if (points < amount) {
                this.plugin.lang().Classes_Aspect_Inc_Error_NoPoints.send((CommandSender)player);
                return;
            }
            cData.setAspectPoints(points - amount);
        }
        cData.addAspect(aspect.getId(), amount);
        this.plugin.lang().Classes_Aspect_Inc_Done.replace("%value%", (Object)String.valueOf(cData.getAspect(aspect.getId()))).replace("%aspect%", (Object)aspect.getName());
        this.classManager.updateClassData(player);
    }

    @Nullable
    public ClassAspect getAspectById(@NotNull String id) {
        return this.aspects.get(id.toLowerCase());
    }

    @NotNull
    public Collection<ClassAspect> getAspects() {
        return this.aspects.values();
    }

    public class GUI
    extends NGUI<Divinity> {
        private int[] aspectSlots;
        private List<String> aspectLore;

        public GUI(JYML cfg) {
            super((CodexPlugin)AspectManager.this.plugin, cfg, "gui.");
            String path = "gui.";
            this.aspectSlots = cfg.getIntArray(path + "aspect-slots");
            this.aspectLore = StringUT.color((List)cfg.getStringList(path + "aspect-lore"));
            GuiClick click = (player, type, e) -> {
                if (type == null) {
                    return;
                }
                if (type == GUIAspectType.RESET) {
                    AspectManager.this.reallocateAspects(player);
                    this.open(player, 1);
                    return;
                }
                if (type == ContentType.RETURN) {
                    AspectManager.this.classManager.openStatsGUI(player);
                    return;
                }
                if (type == ContentType.EXIT) {
                    player.closeInventory();
                    return;
                }
            };
            for (String sId : cfg.getSection(path + "content")) {
                GuiItem guiItem = cfg.getGuiItem(path + "content." + sId, GUIAspectType.class);
                if (guiItem == null) continue;
                if (guiItem.getType() != null) {
                    guiItem.setClick(click);
                }
                this.addButton(guiItem);
            }
        }

        protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
            DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
            if (user == null) {
                return;
            }
            UserProfile prof = user.getActiveProfile();
            UserClassData cData = prof.getClassData();
            if (cData == null) {
                return;
            }
            RPGClass clazz = cData.getPlayerClass();
            int j = 0;
            for (Map.Entry<ClassAspect, ClassAspectBonus> entry : clazz.getAspectBonuses().entrySet()) {
                ClassAspect aspect = entry.getKey();
                ClassAspectBonus aspectBonus = entry.getValue();
                ItemStack icon = new ItemStack(aspect.getMaterial());
                ItemMeta meta = icon.getItemMeta();
                if (meta == null) continue;
                ArrayList<String> lore2 = new ArrayList<String>();
                String plCurrent = "%aspect_current%";
                String plMax = "%aspect_max%";
                String cost = "%cost%";
                BonusMap bMap = aspectBonus.getBonusMap();
                String aspectMax = String.valueOf(aspectBonus.getMaxValue());
                String aspectHas = String.valueOf(cData.getAspect(aspect.getId()));
                double aspectCur = cData.getAspect(aspect);
                for (String line : this.aspectLore) {
                    if (line.contains("%att_name%")) {
                        for (ClassAttributeType aType : ClassAttributeType.values()) {
                            double inc;
                            ClassAttribute att = clazz.getAttribute(aType);
                            if (att == null || (inc = aspectBonus.getPerPointAttribute(aType)) == 0.0) continue;
                            double total = cData.getAttribute(aType);
                            lore2.add(line.replace("%att_total%", NumberUT.format((double)total)).replace("%att_name%", aType.getName()).replace("%att_inc%", NumberUT.format((double)inc)));
                        }
                        continue;
                    }
                    if (line.contains("%item_stat_name%")) {
                        bMap.getStatBonuses().forEach((statAtt, statFunc) -> {
                            String line2 = this.formatBonusMap(line, "item_stat", (ItemLoreStat<?>)statAtt, (BiFunction<Boolean, Double, Double>)statFunc, aspectCur);
                            if (line2 == null) {
                                return;
                            }
                            lore2.add(line2);
                        });
                        continue;
                    }
                    if (line.contains("%damage_name%")) {
                        bMap.getDamageBonuses().forEach((dmgAtt, dmgFunc) -> {
                            String line2 = this.formatBonusMap(line, "damage", (ItemLoreStat<?>)dmgAtt, (BiFunction<Boolean, Double, Double>)dmgFunc, aspectCur);
                            if (line2 == null) {
                                return;
                            }
                            lore2.add(line2);
                        });
                        continue;
                    }
                    if (line.contains("%defense_name%")) {
                        bMap.getDefenseBonuses().forEach((defAtt, defFunc) -> {
                            String line2 = this.formatBonusMap(line, "defense", (ItemLoreStat<?>)defAtt, (BiFunction<Boolean, Double, Double>)defFunc, aspectCur);
                            if (line2 == null) {
                                return;
                            }
                            lore2.add(line2);
                        });
                        continue;
                    }
                    lore2.add(line.replace("%aspect-points%", String.valueOf(cData.getAspectPoints())).replace(cost, "1").replace(plMax, aspectMax).replace(plCurrent, aspectHas));
                }
                meta.setDisplayName(aspect.getName());
                meta.setLore(lore2);
                icon.setItemMeta(meta);
                GuiClick click = (p, type, e) -> {
                    AspectManager.this.addAspect(p, aspect, 1, false);
                    this.open(p, 1);
                };
                JIcon button = new JIcon(icon);
                button.setClick(click);
                this.addButton(player, button, new int[]{this.aspectSlots[j++]});
            }
        }

        @Nullable
        private final String formatBonusMap(@NotNull String line, @NotNull String placeholder, @NotNull ItemLoreStat<?> stat, @NotNull BiFunction<Boolean, Double, Double> func, double aspectCur) {
            double valRaw = func.apply(false, 0.0);
            double valBonus = func.apply(true, 0.0);
            if (valRaw == 0.0 && valBonus == 0.0) {
                return null;
            }
            double valTotal = valRaw != 0.0 ? valRaw : valBonus;
            Object valFormat = NumberUT.format((double)valTotal);
            String valStr = valBonus != 0.0 ? (valFormat = (String)valFormat + EngineCfg.LORE_CHAR_PERCENT) : valFormat;
            return line.replace("%" + placeholder + "_total%", NumberUT.format((double)(valTotal * aspectCur))).replace("%" + placeholder + "_name%", stat.getName()).replace("%" + placeholder + "_inc%", valStr);
        }

        protected boolean cancelClick(int slot) {
            return true;
        }

        protected boolean cancelPlayerClick() {
            return true;
        }

        protected boolean ignoreNullClick() {
            return true;
        }
    }

    static enum GUIAspectType {
        RESET;

    }
}

