/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.LocUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;

public class MDropCmd
extends MCmd<QModuleDrop<?>> {
    public MDropCmd(@NotNull QModuleDrop<?> m) {
        super(m, new String[]{"drop"}, "quantumrpg.admin");
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Drop_Usage.getMsg();
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Drop_Desc.getMsg();
    }

    public boolean playersOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        ItemGeneratorManager itemGeneratorManager;
        ItemGeneratorManager.GeneratorItem generatorItem;
        if (i == 1) {
            return LocUT.getWorldNames();
        }
        if (i == 2) {
            return Arrays.asList("<x>");
        }
        if (i == 3) {
            return Arrays.asList("<y>");
        }
        if (i == 4) {
            return Arrays.asList("<z>");
        }
        if (i == 5) {
            return ((QModuleDrop)this.module).getItemIds();
        }
        if (i == 6) {
            return Arrays.asList("[level]", "-1", "1:5", "1");
        }
        if (i == 7) {
            return Arrays.asList("1", "10");
        }
        if (i == 8 && this.module instanceof ItemGeneratorManager && (generatorItem = (ItemGeneratorManager.GeneratorItem)(itemGeneratorManager = (ItemGeneratorManager)this.module).getItemById(args[5])) != null) {
            List<String> list = generatorItem.getMaterialsList().stream().map(ItemType::getNamespacedID).collect(Collectors.toList());
            return list;
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ItemType material;
        if (args.length < 7) {
            this.printUsage(sender);
            return;
        }
        World world = ((Divinity)this.plugin).getServer().getWorld(args[1]);
        if (world == null) {
            ((Divinity)this.plugin).lang().Error_NoWorld.replace("%world%", (Object)args[1]).send(sender);
            return;
        }
        double x = this.getNumD(sender, args[2], 0.0, true);
        double y = this.getNumD(sender, args[3], 0.0, true);
        double z = this.getNumD(sender, args[4], 0.0, true);
        int lMin = -1;
        int lMax = -1;
        int amount = 1;
        if (args.length >= 7) {
            if (args[6].contains(":")) {
                String[] split = args[6].split(":");
                lMin = this.getNumI(sender, split[0], -1, true);
                lMax = this.getNumI(sender, split[1], -1, true);
            } else {
                lMin = lMax = this.getNumI(sender, args[6], -1, true);
            }
        }
        if (args.length >= 8) {
            amount = this.getNumI(sender, args[7], 1);
        }
        String id = args[5];
        ItemStack item = null;
        Location loc = new Location(world, x, y, z);
        try {
            material = args.length >= 9 ? CodexEngine.get().getItemManager().getItemType(args[8]) : null;
        }
        catch (MissingItemException | MissingProviderException e) {
            material = null;
        }
        ItemGeneratorManager itemGenerator = this.module instanceof ItemGeneratorManager ? (ItemGeneratorManager)this.module : null;
        ItemGeneratorManager.GeneratorItem generatorItem = itemGenerator != null ? (ItemGeneratorManager.GeneratorItem)itemGenerator.getItemById(id) : null;
        HashMap<String, Integer> addedItems = new HashMap<String, Integer>();
        for (int i = 0; i < amount; ++i) {
            int iLevel = Rnd.get((int)lMin, (int)lMax);
            item = material != null && generatorItem != null ? generatorItem.create(iLevel, -1, material) : DivinityAPI.getItemByModule((QModuleDrop)this.module, id, iLevel, -1, -1);
            if (item == null) continue;
            world.dropItemNaturally(loc, item);
            String name = ItemUT.getItemName((ItemStack)item);
            addedItems.put(name, addedItems.containsKey(name) ? (Integer)addedItems.get(name) + item.getAmount() : item.getAmount());
        }
        for (String name : addedItems.keySet()) {
            ((Divinity)this.plugin).lang().Module_Cmd_Drop_Done.replace("%w%", (Object)world.getName()).replace("%x%", (Object)String.valueOf(x)).replace("%y%", (Object)String.valueOf(y)).replace("%z%", (Object)String.valueOf(z)).replace("%item%", (Object)name).replace("%amount%", (Object)String.valueOf(addedItems.get(name))).send(sender);
        }
    }
}

