/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.worth;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.list.refine.RefineManager;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class WorthManager
implements Loadable {
    private final Divinity plugin;
    private final Map<ItemStack, Double> worthCache = new HashMap<ItemStack, Double>();
    private Map<String, Double> priceItemMaterial;
    private Map<TypedStat.Type, Double> priceItemStats;
    private TreeMap<Integer, Double> priceRefineLvl;
    private Map<String, Double> priceDefenseTypes;
    private Map<String, Double> priceDamageTypes;
    private Map<SocketAttribute.Type, Map<String, Double>> priceSocketTypes;
    private Map<String, TreeMap<Integer, Double>> priceEnchants;
    private Map<String, Map<String, TreeMap<Integer, Double>>> priceItemModule;

    public WorthManager(@NotNull Divinity plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        JYML cfg;
        try {
            cfg = JYML.loadOrExtract((CodexPlugin)this.plugin, (String)"worth.yml");
        }
        catch (InvalidConfigurationException e) {
            this.plugin.error("Failed to load worth config (worth.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        this.priceItemMaterial = new HashMap<String, Double>();
        this.priceItemStats = new HashMap<TypedStat.Type, Double>();
        this.priceRefineLvl = new TreeMap();
        this.priceDefenseTypes = new HashMap<String, Double>();
        this.priceDamageTypes = new HashMap<String, Double>();
        this.priceSocketTypes = new HashMap<SocketAttribute.Type, Map<String, Double>>();
        this.priceEnchants = new HashMap<String, TreeMap<Integer, Double>>();
        this.priceItemModule = new HashMap<String, Map<String, TreeMap<Integer, Double>>>();
        String path = "worth-calculator.";
        for (TypedStat.Type type : TypedStat.Type.values()) {
            cfg.addMissing(path + "by-item-stats." + type.name(), (Object)Rnd.get((int)1, (int)11));
        }
        for (DamageAttribute dmgAtt : ItemStats.getDamages()) {
            cfg.addMissing(path + "by-damage-types." + dmgAtt.getId(), (Object)Rnd.get((int)1, (int)11));
        }
        for (DefenseAttribute defAtt : ItemStats.getDefenses()) {
            cfg.addMissing(path + "by-defense-types." + defAtt.getId(), (Object)Rnd.get((int)1, (int)11));
        }
        for (SocketAttribute.Type type : SocketAttribute.Type.values()) {
            for (SocketAttribute socket : ItemStats.getSockets(type)) {
                cfg.addMissing(path + "by-socket-types." + type.name() + "." + socket.getId(), (Object)Rnd.get((int)100, (int)150));
            }
        }
        for (Enchantment enchantment : Enchantment.values()) {
            for (int min = enchantment.getStartLevel(); min < enchantment.getMaxLevel(); ++min) {
                cfg.addMissing(path + "by-enchant-level." + enchantment.getKey().getKey() + "." + min, (Object)(Rnd.get((int)30, (int)60) * min));
            }
        }
        for (IModule mod : this.plugin.getModuleManager().getModules()) {
            if (!(mod instanceof QModuleDrop)) continue;
            QModuleDrop md = (QModuleDrop)mod;
            for (ModuleItem item : md.getItems()) {
                if (item == null) continue;
                cfg.addMissing(path + "by-item-id-level." + md.getId() + "." + item.getId() + ".1", (Object)Rnd.get((int)100, (int)200));
            }
        }
        for (String sMat : cfg.getSection(path + "by-item-material")) {
            Material material = Material.getMaterial((String)sMat.toUpperCase());
            if (material == null) {
                this.plugin.error("[Worth] Invalid material '" + sMat + "' !");
                continue;
            }
            double d = cfg.getDouble(path + "by-item-material." + sMat);
            if (d == 0.0) continue;
            this.priceItemMaterial.put(sMat.toUpperCase(), d);
        }
        for (String sId : cfg.getSection(path + "by-item-stats")) {
            TypedStat.Type type = (TypedStat.Type)CollectionsUT.getEnum((String)sId, TypedStat.Type.class);
            if (type == null) {
                this.plugin.error("[Worth] Invalid stat type: '" + sId + "' !");
                continue;
            }
            double d = cfg.getDouble(path + "by-item-stats." + sId);
            if (d == 0.0) continue;
            this.priceItemStats.put(type, d);
        }
        for (String sLvl : cfg.getSection(path + "by-refine-level")) {
            double d;
            int lvl = StringUT.getInteger((String)sLvl, (int)-1);
            if (lvl < 1 || (d = cfg.getDouble(path + "by-refine-level." + sLvl)) == 0.0) continue;
            this.priceRefineLvl.put(lvl, d);
        }
        for (String sId : cfg.getSection(path + "by-defense-types")) {
            DefenseAttribute defAtt = ItemStats.getDefenseById(sId);
            if (defAtt == null) {
                this.plugin.error("[Worth] Invalid Defense Attribute '" + sId + "' !");
                continue;
            }
            double d = cfg.getDouble(path + "by-defense-types." + sId);
            if (d == 0.0) continue;
            this.priceDefenseTypes.put(defAtt.getId(), d);
        }
        for (String sId : cfg.getSection(path + "by-damage-types")) {
            DamageAttribute defAtt = ItemStats.getDamageById(sId);
            if (defAtt == null) {
                this.plugin.error("[Worth] Invalid Damage Attribute '" + sId + "' !");
                continue;
            }
            double d = cfg.getDouble(path + "by-damage-types." + sId);
            if (d == 0.0) continue;
            this.priceDamageTypes.put(defAtt.getId(), d);
        }
        for (String sType : cfg.getSection(path + "by-socket-types")) {
            SocketAttribute.Type type = SocketAttribute.Type.getByName(sType);
            if (type == null) continue;
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            for (String sId : cfg.getSection(path + "by-socket-types." + sType)) {
                SocketAttribute socket = ItemStats.getSocket(type, sId);
                if (socket == null) {
                    this.plugin.error("[Worth] Invalid Socket Attribute: '" + sId + "' !");
                    continue;
                }
                double price = cfg.getDouble(path + "by-socket-types." + sType + "." + sId);
                if (price == 0.0) continue;
                hashMap.put(socket.getId(), price);
            }
            if (hashMap.isEmpty()) continue;
            this.priceSocketTypes.put(type, hashMap);
        }
        for (String sId : cfg.getSection(path + "by-enchant-level")) {
            block32: {
                try {
                    Enchantment e = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)sId.toLowerCase()));
                    if (e == null) {
                        this.plugin.error("[Worth] Invalid Enchantment '" + sId + "' !");
                    }
                    break block32;
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.error("[Worth] Invalid Enchantment '" + sId + "' !");
                }
                continue;
            }
            TreeMap<Integer, Double> lvlMap = new TreeMap<Integer, Double>();
            for (String sLvl : cfg.getSection(path + "by-enchant-level." + sId)) {
                int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 1) continue;
                double price = cfg.getDouble(path + "by-enchant-level." + sId + "." + sLvl);
                lvlMap.put(lvl, price);
            }
            if (lvlMap.isEmpty()) continue;
            this.priceEnchants.put(sId.toLowerCase(), lvlMap);
        }
        for (String mId : cfg.getSection(path + "by-item-id-level")) {
            IModule mod = this.plugin.getModuleManager().getModule(mId);
            if (mod == null || !mod.isLoaded() || !(mod instanceof QModuleDrop)) {
                this.plugin.error("[Worth] Invalid module provided: '" + mId + "' !");
                continue;
            }
            HashMap hashMap = new HashMap();
            for (String itemId : cfg.getSection(path + "by-item-id-level." + mId)) {
                TreeMap<Integer, Double> lvlMap = new TreeMap<Integer, Double>();
                for (String sLvl : cfg.getSection(path + "by-item-id-level." + mId + "." + itemId)) {
                    String path2;
                    double price;
                    int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                    if (lvl < 1 || (price = cfg.getDouble(path2 = path + "by-item-id-level." + mId + "." + itemId + "." + sLvl)) == 0.0) continue;
                    lvlMap.put(lvl, price);
                }
                if (lvlMap.isEmpty()) continue;
                hashMap.put(itemId.toLowerCase(), lvlMap);
            }
            if (hashMap.isEmpty()) continue;
            this.priceItemModule.put(mod.getId(), hashMap);
        }
        cfg.saveChanges();
    }

    public void shutdown() {
        if (this.priceItemMaterial != null) {
            this.priceItemMaterial.clear();
            this.priceItemMaterial = null;
        }
        if (this.priceItemStats != null) {
            this.priceItemStats.clear();
            this.priceItemStats = null;
        }
        if (this.priceRefineLvl != null) {
            this.priceRefineLvl.clear();
            this.priceRefineLvl = null;
        }
        if (this.priceDefenseTypes != null) {
            this.priceDefenseTypes.clear();
            this.priceDefenseTypes = null;
        }
        if (this.priceDamageTypes != null) {
            this.priceDamageTypes.clear();
            this.priceDamageTypes = null;
        }
        if (this.priceSocketTypes != null) {
            this.priceSocketTypes.clear();
            this.priceSocketTypes = null;
        }
        if (this.priceEnchants != null) {
            this.priceEnchants.clear();
            this.priceEnchants = null;
        }
        if (this.priceItemModule != null) {
            this.priceItemModule.clear();
            this.priceItemModule = null;
        }
    }

    private double getItemMaterialPrice(@NotNull ItemStack item) {
        return this.priceItemMaterial.getOrDefault(item.getType().name(), 0.0);
    }

    private double getItemEnchantCost(@NotNull ItemStack item) {
        double cost = 0.0;
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasEnchants()) {
            return cost;
        }
        for (Map.Entry e : meta.getEnchants().entrySet()) {
            Map.Entry<Integer, Double> eItem;
            String enchKey = ((Enchantment)e.getKey()).getKey().getKey();
            TreeMap<Integer, Double> itemMap = this.priceEnchants.get(enchKey);
            if (itemMap == null || (eItem = itemMap.floorEntry((Integer)e.getValue())) == null) continue;
            cost += eItem.getValue().doubleValue();
        }
        return cost;
    }

    private double getItemModulePrice(@NotNull ItemStack item) {
        Map.Entry<Integer, Double> ePrice;
        String modId;
        Map<String, TreeMap<Integer, Double>> itemMap;
        double cost = 0.0;
        QModuleDrop<?> md = ItemStats.getModule(item);
        if (md == null) {
            return cost;
        }
        if (!md.isSocketable()) {
            for (IModule iMod : this.plugin.getModuleManager().getModules()) {
                if (!(iMod instanceof ModuleSocket)) continue;
                ModuleSocket ms = (ModuleSocket)iMod;
                for (Map.Entry socket : ms.getItemSockets(item)) {
                    SocketItem sItem = (SocketItem)socket.getKey();
                    if (sItem == null) continue;
                    int sLvl = socket.getValue();
                    ItemStack sStack = sItem.create(sLvl);
                    cost += this.getItemModulePrice(sStack);
                }
            }
        }
        if ((itemMap = this.priceItemModule.get(modId = md.getId())) == null) {
            return 0.0;
        }
        String itemId = ItemStats.getId(item);
        if (itemId == null) {
            return 0.0;
        }
        TreeMap<Integer, Double> lvlMap = itemMap.get(itemId);
        if (lvlMap == null) {
            return 0.0;
        }
        int itemLvl = ItemStats.getLevel(item);
        if (itemLvl == 0) {
            itemLvl = 1;
        }
        if ((ePrice = lvlMap.floorEntry(itemLvl)) == null) {
            return 0.0;
        }
        return Math.max(0.0, cost += ePrice.getValue().doubleValue());
    }

    private double getItemAttributesPrice(@NotNull ItemStack item) {
        double cost = 0.0;
        for (Map.Entry<TypedStat.Type, Double> entry : this.priceItemStats.entrySet()) {
            cost += entry.getValue() * ItemStats.getStat(item, null, entry.getKey());
        }
        for (Map.Entry<Object, Double> entry : this.priceDamageTypes.entrySet()) {
            cost += entry.getValue() * ItemStats.getDamageMinOrMax(item, null, (String)entry.getKey(), 1);
        }
        for (Map.Entry<Object, Double> entry : this.priceDefenseTypes.entrySet()) {
            cost += entry.getValue() * ItemStats.getDefense(item, null, (String)entry.getKey());
        }
        return cost;
    }

    private double getItemRefinePrice(@NotNull ItemStack item) {
        if (this.priceRefineLvl.isEmpty()) {
            return 0.0;
        }
        RefineManager refine = this.plugin.getModuleCache().getRefineManager();
        if (refine == null) {
            return 0.0;
        }
        int refLvl = refine.getRefineLevel(item);
        if (refLvl < 1) {
            return 0.0;
        }
        Map.Entry<Integer, Double> e = this.priceRefineLvl.floorEntry(refLvl);
        if (e == null) {
            return 0.0;
        }
        return e.getValue();
    }

    private double getItemSocketPrice(@NotNull ItemStack item) {
        double cost = 0.0;
        for (Map.Entry<SocketAttribute.Type, Map<String, Double>> e : this.priceSocketTypes.entrySet()) {
            Map<String, Double> itemMap = e.getValue();
            for (Map.Entry<String, Double> eSocket : itemMap.entrySet()) {
                int emptyCount;
                SocketAttribute socket = ItemStats.getSocket(e.getKey(), eSocket.getKey());
                if (socket == null || (emptyCount = socket.getEmptyAmount(item)) == 0) continue;
                double socketCost = 0.0;
                String socketId = socket.getId();
                if (itemMap.containsKey(socketId)) {
                    socketCost = itemMap.get(socketId);
                }
                cost += socketCost * (double)emptyCount;
            }
        }
        return cost;
    }

    public double getItemWorth(@NotNull ItemStack item) {
        double cost = 0.0;
        if (this.worthCache.containsKey(item)) {
            return this.worthCache.get(item);
        }
        if (!ItemUT.isAir((ItemStack)item)) {
            cost += this.getItemMaterialPrice(item);
            cost += this.getItemModulePrice(item);
            cost += this.getItemAttributesPrice(item);
            cost += this.getItemEnchantCost(item);
            cost += this.getItemRefinePrice(item);
            cost += this.getItemSocketPrice(item);
            cost *= 1.0 + ItemStats.getStat(item, null, TypedStat.Type.SALE_PRICE) / 100.0;
            cost *= (double)item.getAmount();
        }
        cost = Math.max(0.0, NumberUT.round((double)cost));
        this.worthCache.put(item, cost);
        Bukkit.getScheduler().runTaskLater((Plugin)Divinity.getInstance(), () -> this.worthCache.remove(item), 400L);
        return cost;
    }
}

