/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.profile.ProfileManager;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;

public class ProfilesGUI
extends NGUI<Divinity> {
    private ProfileManager profileManager;
    private ItemStack profileIcon;
    private int[] profileSlots;

    ProfilesGUI(@NotNull ProfileManager profileManager, @NotNull JYML cfg) {
        super((CodexPlugin)((Divinity)profileManager.plugin), cfg, "");
        this.profileManager = profileManager;
        this.profileIcon = cfg.getItem("profiles.icon");
        this.profileSlots = cfg.getIntArray("profiles.slots");
        GuiClick click = (p, type, e) -> {
            ItemType type2;
            if (type == null) {
                return;
            }
            Class<?> clazz = type.getClass();
            if (clazz.equals(ContentType.class)) {
                ContentType type22 = (ContentType)type;
                switch (type22) {
                    case NEXT: {
                        this.open(p, this.getUserPage(p, 0) + 1);
                        break;
                    }
                    case BACK: {
                        this.open(p, this.getUserPage(p, 0) - 1);
                        break;
                    }
                    case RETURN: {
                        this.profileManager.getProfileGUI().open(p, 1);
                        break;
                    }
                    case EXIT: {
                        p.closeInventory();
                        break;
                    }
                }
                return;
            }
            if (clazz.equals(ItemType.class) && (type2 = (ItemType)type) == ItemType.PROFILE_CREATE) {
                this.profileManager.startProfileCreation(p);
                p.closeInventory();
                return;
            }
        };
        for (String id : cfg.getSection("content")) {
            GuiItem guiItem = cfg.getGuiItem("content." + id, ItemType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
        int length = this.profileSlots.length;
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            return;
        }
        List<UserProfile> list = new ArrayList<UserProfile>(user.getProfileMap().values());
        List split = CollectionsUT.split(list, (int)length);
        int pages = split.size();
        list = pages < 1 ? Collections.emptyList() : (List)split.get(Math.min(page, split.size()) - 1);
        int count = 0;
        for (UserProfile profile : list) {
            ItemStack icon = new ItemStack(this.profileIcon);
            icon.setAmount(count + 1);
            ItemMeta meta = icon.getItemMeta();
            if (meta == null) continue;
            if (meta instanceof SkullMeta) {
                ((SkullMeta)meta).setOwner(profile.getIdName());
            }
            meta.setDisplayName(meta.getDisplayName().replace("%profile%", profile.getIdName()));
            List lore = meta.getLore();
            if (lore != null) {
                UserClassData classData = profile.getClassData();
                lore.replaceAll(line -> line.replace("%class-level%", classData != null ? String.valueOf(classData.getLevel()) : "0").replace("%class-name%", classData != null ? classData.getPlayerClass().getName() : "?").replace("%default%", ((Divinity)this.plugin).lang().getBool(profile.isDefault())).replace("%active%", ((Divinity)this.plugin).lang().getBool(user.getActiveProfile().equals(profile))));
                meta.setLore(lore);
            }
            icon.setItemMeta(meta);
            GuiClick click = (p2, type, e) -> {
                if (e.isRightClick()) {
                    if (e.isShiftClick() && user.deleteProfile(profile.getIdName())) {
                        this.open(p2, 1);
                        return;
                    }
                    if (!profile.isDefault()) {
                        user.getProfileMap().values().forEach(profile2 -> profile2.setDefault(false));
                        profile.setDefault(true);
                        this.open(p2, 1);
                        return;
                    }
                    return;
                }
                if (!user.getActiveProfile().equals(profile)) {
                    ClassManager classManager;
                    this.profileManager.switchProfile(p2, profile);
                    if (user.getActiveProfile().getClassData() == null && (classManager = ((Divinity)this.plugin).getModuleCache().getClassManager()) != null && !classManager.isRemindDisabled(p2)) {
                        classManager.openSelectionGUI(p2, true);
                        return;
                    }
                    this.open(p2, 1);
                }
            };
            JIcon jicon = new JIcon(icon);
            jicon.setClick(click);
            this.addButton(player, jicon, new int[]{this.profileSlots[count++]});
        }
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    private static enum ItemType {
        PROFILE_CREATE;

    }
}

