/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.profile.ProfileCommand;
import studio.magemonkey.divinity.manager.profile.ProfileGUI;
import studio.magemonkey.divinity.manager.profile.ProfilesGUI;
import studio.magemonkey.divinity.manager.profile.SettingsGUI;
import studio.magemonkey.divinity.stats.EntityStats;

public class ProfileManager
extends IListener<Divinity>
implements Loadable {
    private JYML cfg;
    private boolean selectOnJoin;
    private int changeCooldown;
    private Pattern namePattern;
    private Map<String, Integer> profilesAmount;
    private SettingsGUI guiSettings;
    private ProfileGUI guiProfile;
    private ProfilesGUI guiProfiles;
    private ProfileCommand profileCommand;
    private Map<String, Long> profileCooldown;
    private Set<Player> profileCreation;

    public ProfileManager(@NotNull Divinity plugin) {
        super((JavaPlugin)plugin);
    }

    public void setup() {
        try {
            this.cfg = JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)"/profiles/settings.yml");
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load profiles config (" + ((Divinity)this.plugin).getName() + "/profiles/settings.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        this.selectOnJoin = this.cfg.getBoolean("profile.select-on-join", false);
        this.changeCooldown = this.cfg.getInt("profile.change-cooldown");
        this.namePattern = Pattern.compile(this.cfg.getString("profile.name-regex", "[a-zA-Z0-9_]*"));
        this.profilesAmount = new HashMap<String, Integer>();
        for (String rank : this.cfg.getSection("profiles-amount")) {
            int amount = this.cfg.getInt("profiles-amount." + rank);
            this.profilesAmount.put(rank.toLowerCase(), amount);
        }
        if (this.getChangeCooldown() > 0) {
            this.profileCooldown = new HashMap<String, Long>();
        }
        this.profileCreation = Collections.newSetFromMap(new WeakHashMap());
        try {
            this.guiSettings = new SettingsGUI(this, JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)"/profiles/gui.settings.yml"));
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load profiles config (" + ((Divinity)this.plugin).getName() + "/profiles/gui.settings.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        try {
            this.guiProfile = new ProfileGUI(this, JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)"/profiles/gui.profile.yml"));
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load profiles config (" + ((Divinity)this.plugin).getName() + "/profiles/gui.profile.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        try {
            this.guiProfiles = new ProfilesGUI(this, JYML.loadOrExtract((CodexPlugin)((CodexPlugin)this.plugin), (String)"/profiles/gui.profiles.yml"));
        }
        catch (InvalidConfigurationException e) {
            ((Divinity)this.plugin).error("Failed to load profiles config (" + ((Divinity)this.plugin).getName() + "/profiles/gui.profiles.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        this.profileCommand = new ProfileCommand(this);
        ((Divinity)this.plugin).getCommandManager().registerCommand((IGeneralCommand)this.profileCommand);
        this.registerListeners();
        ((Divinity)this.plugin).getLogger().info("Profile Manager has been enabled");
    }

    public void shutdown() {
        this.unregisterListeners();
        if (this.guiSettings != null) {
            this.guiSettings.shutdown();
            this.guiSettings = null;
        }
        if (this.guiProfile != null) {
            this.guiProfile.shutdown();
            this.guiProfile = null;
        }
        if (this.guiProfiles != null) {
            this.guiProfiles.shutdown();
            this.guiProfiles = null;
        }
        if (this.profilesAmount != null) {
            this.profilesAmount.clear();
            this.profilesAmount = null;
        }
        if (this.profileCooldown != null) {
            this.profileCooldown.clear();
            this.profileCooldown = null;
        }
        if (this.profileCreation != null) {
            this.profileCreation.clear();
            this.profileCreation = null;
        }
        if (this.profileCommand != null) {
            ((Divinity)this.plugin).getCommandManager().unregisterCommand((IGeneralCommand)this.profileCommand);
            this.profileCommand = null;
        }
    }

    public boolean isSelectOnJoin() {
        return this.selectOnJoin;
    }

    public int getChangeCooldown() {
        return this.changeCooldown;
    }

    @NotNull
    public Pattern getNamePattern() {
        return this.namePattern;
    }

    public int getPlayerMaxProfiles(@NotNull Player player) {
        return Hooks.getGroupValueInt((Player)player, this.profilesAmount, (boolean)true);
    }

    @NotNull
    public SettingsGUI getSettingsGUI() {
        return this.guiSettings;
    }

    @NotNull
    public ProfileGUI getProfileGUI() {
        return this.guiProfile;
    }

    @NotNull
    public ProfilesGUI getProfilesGUI() {
        return this.guiProfiles;
    }

    public boolean canCreateMoreProfiles(@NotNull Player player) {
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            return false;
        }
        int maxProfiles = this.getPlayerMaxProfiles(player);
        int hasProfiles = user.getProfileMap().size();
        return maxProfiles < 0 || hasProfiles < maxProfiles;
    }

    public void startProfileCreation(@NotNull Player player) {
        int maxProfiles = this.getPlayerMaxProfiles(player);
        if (!this.canCreateMoreProfiles(player)) {
            ((Divinity)this.plugin).lang().Profiles_Create_Error_Maximum.replace("%amount%", (Object)maxProfiles).send((CommandSender)player);
            return;
        }
        this.profileCreation.add(player);
        ((Divinity)this.plugin).lang().Profiles_Create_Tip_Name.send((CommandSender)player);
    }

    public boolean createProfile(@NotNull Player player, @NotNull String name) {
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            return false;
        }
        int maxProfiles = this.getPlayerMaxProfiles(player);
        if (!this.canCreateMoreProfiles(player)) {
            ((Divinity)this.plugin).lang().Profiles_Create_Error_Maximum.replace("%amount%", (Object)maxProfiles).send((CommandSender)player);
            return false;
        }
        if (!this.getNamePattern().matcher(name).matches() || name.equalsIgnoreCase("default")) {
            ((Divinity)this.plugin).lang().Profiles_Create_Error_Regex.send((CommandSender)player);
            return false;
        }
        if (user.getProfile(name) != null) {
            ((Divinity)this.plugin).lang().Profiles_Create_Error_Exists.send((CommandSender)player);
            return false;
        }
        if (!user.addProfile(name)) {
            return false;
        }
        this.getProfilesGUI().open(player, 1);
        this.profileCreation.remove(player);
        return true;
    }

    public boolean switchProfile(@NotNull Player player, @NotNull UserProfile profile) {
        DivinityUser user = (DivinityUser)((Divinity)this.plugin).getUserManager().getOrLoadUser(player);
        if (user == null) {
            return false;
        }
        if (user.switchProfile(profile.getIdName())) {
            ((Divinity)this.plugin).lang().Profiles_Switch_Done.replace("%profile%", (Object)profile.getIdName()).send((CommandSender)player);
            this.setProfileSwitchCooldown(player);
            EntityStats.get((LivingEntity)player).updateAll();
            return true;
        }
        return false;
    }

    public void setProfileSwitchCooldown(@NotNull Player player) {
        if (this.getChangeCooldown() <= 0) {
            return;
        }
        long expireDate = System.currentTimeMillis() + (long)this.getChangeCooldown() * 1000L;
        this.profileCooldown.computeIfAbsent(player.getName(), date -> expireDate);
    }

    public long getProfileSwitchCooldownDate(@NotNull Player player) {
        if (this.getChangeCooldown() <= 0) {
            return 0L;
        }
        long expireDate = this.profileCooldown.getOrDefault(player.getName(), 0L);
        if (expireDate < System.currentTimeMillis()) {
            this.profileCooldown.remove(player.getName());
        }
        return expireDate;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProfileSelectJoin(PlayerJoinEvent e) {
        if (!this.isSelectOnJoin()) {
            return;
        }
        ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.getProfilesGUI().open(e.getPlayer(), 1));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProfileCreationChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (!this.profileCreation.contains(player)) {
            return;
        }
        e.setCancelled(true);
        e.getRecipients().clear();
        String msg = e.getMessage();
        if (msg.equalsIgnoreCase("exit")) {
            player.sendTitle("", "", 1, 1, 1);
            this.profileCreation.remove(player);
            return;
        }
        ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!this.createProfile(player, e.getMessage())) {
                ((Divinity)this.plugin).lang().Profiles_Create_Tip_Error.send((CommandSender)player);
                this.profileCreation.remove(player);
                return;
            }
            ((Divinity)this.plugin).lang().Profiles_Create_Tip_Done.send((CommandSender)player);
        });
    }
}

