/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.listener.object;

import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;

public class ItemHandListener
extends IListener<Divinity> {
    public ItemHandListener(@NotNull Divinity plugin) {
        super((JavaPlugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onHandHeld(PlayerItemHeldEvent e) {
        int slot = e.getNewSlot();
        Player player = e.getPlayer();
        ItemStack toHold = player.getInventory().getItem(slot);
        if (toHold == null || toHold.getType() == Material.AIR) {
            return;
        }
        ItemStack inOff = player.getInventory().getItemInOffHand();
        if (ItemUT.isAir((ItemStack)inOff)) {
            return;
        }
        HandAttribute handTo = ItemStats.getHand(toHold);
        HandAttribute handOff = ItemStats.getHand(inOff);
        if (handTo != null && handTo.getType() == HandAttribute.Type.TWO || handOff != null && handOff.getType() == HandAttribute.Type.TWO) {
            ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHandSwap(PlayerSwapHandItemsEvent e) {
        Player player = e.getPlayer();
        ItemStack off = e.getOffHandItem();
        if (off == null || off.getType() == Material.AIR) {
            return;
        }
        HandAttribute handOff = ItemStats.getHand(off);
        if (handOff != null && handOff.getType() == HandAttribute.Type.TWO) {
            ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHandDrag(InventoryDragEvent e) {
        if (e.getInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        ItemStack drag = e.getOldCursor();
        if (ItemUT.isAir((ItemStack)drag)) {
            return;
        }
        HandAttribute hand = ItemStats.getHand(drag);
        if (hand == null || hand.getType() != HandAttribute.Type.TWO) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Set slots = e.getRawSlots();
        if (slots.contains(40)) {
            ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            String server = Bukkit.getServer().getName();
            if (server.contains("Mohist")) {
                player.getInventory().setItemInOffHand(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onHandClose(InventoryCloseEvent e) {
        Player player = (Player)e.getPlayer();
        ItemStack off = player.getInventory().getItemInOffHand();
        if (ItemUT.isAir((ItemStack)off)) {
            return;
        }
        ItemStack main = player.getInventory().getItemInMainHand();
        HandAttribute pickh = ItemStats.getHand(main);
        HandAttribute offh = ItemStats.getHand(off);
        if (pickh != null && pickh.getType() == HandAttribute.Type.TWO || offh != null && offh.getType() == HandAttribute.Type.TWO) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{new ItemStack(off)});
            player.getInventory().setItemInOffHand(null);
            player.updateInventory();
            ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onHandHoldOffClick(InventoryClickEvent e) {
        Inventory inv = e.getInventory();
        if (inv.getType() != InventoryType.CRAFTING) {
            return;
        }
        ItemStack cursor = e.getCursor();
        if (cursor == null || cursor.getType() == Material.AIR) {
            return;
        }
        if (e.getSlot() == 40) {
            Player player = (Player)e.getWhoClicked();
            HandAttribute handAtt = ItemStats.getHand(cursor);
            if (handAtt != null && handAtt.getType() == HandAttribute.Type.TWO) {
                ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
                e.setCancelled(true);
                player.updateInventory();
            } else if (this.holdMainTwo(player)) {
                ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Hand.send((CommandSender)player);
                e.setCancelled(true);
                player.updateInventory();
            }
        }
    }

    private boolean holdMainTwo(@NotNull Player player) {
        ItemStack main = player.getInventory().getItemInMainHand();
        HandAttribute hand = ItemStats.getHand(main);
        return hand != null && hand.getType() == HandAttribute.Type.TWO;
    }
}

