/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external.mimic;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.endlesscode.mimic.items.BukkitItemsRegistry;
import studio.magemonkey.codex.modules.ModuleManager;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;

public class DivinityItemsRegistry
implements BukkitItemsRegistry {
    static final String ID = "divinity";
    private static final String SEPARATOR = "/";
    private final Divinity divinity;

    public DivinityItemsRegistry(Divinity divinity) {
        this.divinity = divinity;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean isEnabled() {
        return this.divinity.isEnabled();
    }

    @NotNull
    public Collection<String> getKnownIds() {
        return this.getDropModules().flatMap(module -> module.getItemIds().stream().map(item -> this.buildItemName((QModuleDrop<?>)((Object)module), (String)item))).collect(Collectors.toList());
    }

    public boolean isSameItem(@NotNull ItemStack item, @NotNull String itemId) {
        String realItemId = this.getItemId(item);
        if (realItemId == null) {
            return false;
        }
        String[] parts = this.splitItemId(itemId);
        String id = parts[1];
        return realItemId.equals(id);
    }

    public boolean isItemExists(@NotNull String itemId) {
        String[] parts = this.splitItemId(itemId);
        String moduleId = parts[0];
        String id = parts[1];
        return this.getDropModules(moduleId).anyMatch(module -> module.getItemById(id) != null);
    }

    @Nullable
    public String getItemId(@NotNull ItemStack item) {
        return this.getDropModules().map(module -> {
            String itemId = module.getItemId(item);
            return itemId != null ? this.buildItemName((QModuleDrop<?>)((Object)module), itemId) : null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public ItemStack getItem(@NotNull String itemId, @Nullable Object payload, int amount) {
        String[] parts = this.splitItemId(itemId);
        String moduleId = parts[0];
        String id = parts[1];
        Optional<ItemStack> searchResult = this.getDropModules(moduleId).map(module -> module.getItemById(id)).filter(Objects::nonNull).map(ModuleItem::create).findFirst();
        if (searchResult.isPresent()) {
            ItemStack itemStack = searchResult.get();
            itemStack.setAmount(Math.max(Math.min(amount, itemStack.getMaxStackSize()), 1));
            return itemStack;
        }
        return null;
    }

    private Stream<QModuleDrop<?>> getDropModules(String moduleId) {
        return moduleId.isEmpty() ? this.getDropModules() : this.getDropModules().filter(module -> moduleId.equals(module.getId()));
    }

    private Stream<QModuleDrop<?>> getDropModules() {
        ModuleManager moduleManager = this.divinity.getModuleManager();
        Objects.requireNonNull(moduleManager, "It seems you're trying to access items from Divinity before the plugin is loaded. Try to add Divinity to 'depend' or 'softpend' of your plugin.");
        return moduleManager.getModules().stream().filter(module -> module instanceof QModuleDrop).map(module -> (QModuleDrop)((Object)module));
    }

    private String[] splitItemId(String itemId) {
        String[] stringArray;
        if (itemId.contains(SEPARATOR)) {
            stringArray = itemId.split(SEPARATOR, 2);
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = itemId;
        }
        return stringArray;
    }

    private String buildItemName(QModuleDrop<?> module, String itemId) {
        return module.getId() + SEPARATOR + itemId;
    }
}

