/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.hooks.HookState;
import studio.magemonkey.codex.hooks.NHook;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.HookMobLevel;

public class LevelledMobsHK
extends NHook<Divinity>
implements HookMobLevel {
    private final Boolean levelledMobsIsInstalled;
    private NamespacedKey key;

    public LevelledMobsHK(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin);
        Plugin levelledMobsPlugin = Bukkit.getPluginManager().getPlugin("LevelledMobs");
        this.levelledMobsIsInstalled = levelledMobsPlugin != null && levelledMobsPlugin.isEnabled();
        if (this.levelledMobsIsInstalled.booleanValue()) {
            this.key = new NamespacedKey(levelledMobsPlugin, "level");
        }
    }

    @NotNull
    protected HookState setup() {
        return HookState.SUCCESS;
    }

    protected void shutdown() {
    }

    public boolean hasLevelledMobsInstalled() {
        return this.levelledMobsIsInstalled != null && this.levelledMobsIsInstalled != false;
    }

    @Override
    public double getMobLevel(@NotNull Entity entity) {
        if (!(entity instanceof LivingEntity) || !this.hasLevelledMobsInstalled()) {
            return 0.0;
        }
        Integer mobLevel = (Integer)entity.getPersistentDataContainer().get(this.key, PersistentDataType.INTEGER);
        return Objects.requireNonNullElse(mobLevel, 0).intValue();
    }
}

