/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.utils.actions.conditions;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.codex.util.actions.params.IParamValue;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;

public class CEntityLevel
extends IConditionValidator {
    public CEntityLevel(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, "ENTITY_LEVEL");
    }

    public void registerParams() {
        this.registerParam("TARGET");
        this.registerParam("AMOUNT");
        this.registerParam("MESSAGE");
    }

    public boolean mustHaveTarget() {
        return true;
    }

    @Nullable
    protected Predicate<Entity> validate(Entity exe, Set<Entity> targets, IParamResult result) {
        IParamValue value = result.getParamValue("AMOUNT");
        IParamValue.IOperator oper = value.getOperator();
        int lvl = value.getInt(-1);
        if (lvl < 0) {
            return null;
        }
        return e -> {
            double eLvl = 0.0;
            eLvl = e instanceof Player ? (double)EngineCfg.HOOK_PLAYER_LEVEL_PLUGIN.getLevel((Player)e) : EngineCfg.HOOK_MOB_LEVEL_PLUGIN.getMobLevel((Entity)e);
            return oper.check((double)((int)eLvl), (double)lvl);
        };
    }

    @NotNull
    public List<String> getDescription() {
        return Arrays.asList("Checks for entity level");
    }
}

