/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.nms.packets.versions;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.events.EnginePlayerPacketEvent;
import studio.magemonkey.codex.api.events.EngineServerPacketEvent;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.nms.packets.IPacketHandler;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.event.EntityEquipmentChangeEvent;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserEntityNamesMode;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.EntityManager;

public class UniversalPacketHandler
implements IPacketHandler {
    protected Divinity plugin;

    public UniversalPacketHandler(@NotNull Divinity plugin) {
        this.plugin = plugin;
    }

    public void managePlayerPacket(@NotNull EnginePlayerPacketEvent e) {
        Class playoutParticles = Reflex.getNMSClass((String)"PacketPlayOutWorldParticles");
        Class playoutUpdateAttributes = Reflex.getNMSClass((String)"PacketPlayOutUpdateAttributes");
        Class playoutEntityMetadata = Reflex.getNMSClass((String)"PacketPlayOutEntityMetadata");
        Class playOutEntityEquipment = Reflex.getNMSClass((String)"PacketPlayOutEntityEquipment");
        Object packet = e.getPacket();
        if (EngineCfg.PACKETS_REDUCE_COMBAT_PARTICLES && playoutParticles.isInstance(packet)) {
            this.manageDamageParticle(e, packet);
            return;
        }
        if (playoutUpdateAttributes.isInstance(packet)) {
            this.manageEquipmentChanges(e, packet);
            return;
        }
        if (playoutEntityMetadata.isInstance(packet)) {
            this.manageEntityNames(e, packet);
            return;
        }
        if (playOutEntityEquipment.isInstance(packet)) {
            this.managePlayerHelmet(e, packet);
        }
    }

    public void manageServerPacket(@NotNull EngineServerPacketEvent e) {
    }

    public void manageEquipmentChanges(@NotNull EnginePlayerPacketEvent e, @NotNull Object packet) {
        Object worldServer;
        Class playoutUpdateAttributes = Reflex.getNMSClass((String)"PacketPlayOutUpdateAttributes");
        Class craftServerClass = Reflex.getCraftClass((String)"CraftServer");
        Class nmsEntityClass = Reflex.getNMSClass((String)"Entity");
        Class worldServerClass = Reflex.getNMSClass((String)"WorldServer");
        Object equip = playoutUpdateAttributes.cast(packet);
        Integer entityId = (Integer)Reflex.getFieldValue(equip, (String)"a");
        if (entityId == null) {
            return;
        }
        Object server = craftServerClass.cast(Bukkit.getServer());
        Object nmsEntity = null;
        Object dedicatedServer = Reflex.invokeMethod((Method)Reflex.getMethod((Class)craftServerClass, (String)"getServer", (Class[])new Class[0]), server, (Object[])new Object[0]);
        Iterable worlds = (Iterable)Reflex.invokeMethod((Method)Reflex.getMethod(dedicatedServer.getClass(), (String)"getWorlds", (Class[])new Class[0]), (Object)dedicatedServer, (Object[])new Object[0]);
        Method getEntity = Reflex.getMethod((Class)worldServerClass, (String)"getEntity", (Class[])new Class[]{Integer.TYPE});
        Iterator iterator = worlds.iterator();
        while (iterator.hasNext() && (nmsEntity = Reflex.invokeMethod((Method)getEntity, worldServer = iterator.next(), (Object[])new Object[]{(int)entityId})) == null) {
        }
        if (nmsEntity == null) {
            return;
        }
        Method getUniqueId = Reflex.getMethod((Class)nmsEntityClass, (String)"getUniqueID", (Class[])new Class[0]);
        Entity bukkitEntity = CodexEngine.get().getServer().getEntity((UUID)Reflex.invokeMethod((Method)getUniqueId, (Object)nmsEntity, (Object[])new Object[0]));
        if (!(bukkitEntity instanceof LivingEntity)) {
            return;
        }
        if (EntityManager.isPacketDuplicatorFixed(bukkitEntity) || !EntityManager.isEquipmentNew((LivingEntity)bukkitEntity)) {
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            EntityEquipmentChangeEvent event = new EntityEquipmentChangeEvent((LivingEntity)bukkitEntity);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        });
    }

    protected void manageDamageParticle(@NotNull EnginePlayerPacketEvent e, @NotNull Object packet) {
        Class packetParticlesClass = Reflex.getNMSClass((String)"PacketPlayOutWorldParticles");
        Class particleParamClass = Reflex.getNMSClass((String)"ParticleParam");
        Object p = packetParticlesClass.cast(packet);
        Object j = Reflex.getFieldValue(p, (String)"j");
        if (j == null) {
            return;
        }
        Method a = Reflex.getMethod((Class)particleParamClass, (String)"a", (Class[])new Class[0]);
        String name = (String)Reflex.invokeMethod((Method)a, (Object)j, (Object[])new Object[0]);
        if (name.contains("damage_indicator")) {
            Reflex.setFieldValue(p, (String)"h", (Object)20);
        }
    }

    protected void manageEntityNames(@NotNull EnginePlayerPacketEvent e, @NotNull Object packet) {
        DivinityUser user = (DivinityUser)this.plugin.getUserManager().getOrLoadUser(e.getReciever());
        if (user == null) {
            return;
        }
        UserProfile profile = user.getActiveProfile();
        UserEntityNamesMode namesMode = profile.getNamesMode();
        if (namesMode == UserEntityNamesMode.DEFAULT) {
            return;
        }
        Class pClass = Reflex.getNMSClass((String)"PacketPlayOutEntityMetadata");
        Object p = pClass.cast(packet);
        List list = (List)Reflex.getFieldValue(p, (String)"b");
        if (list == null) {
            return;
        }
        if (list.size() > 13) {
            Object index3 = list.get(13);
            Method bMethod = Reflex.getMethod(index3.getClass(), (String)"b", (Class[])new Class[0]);
            Object b = Reflex.invokeMethod((Method)bMethod, index3, (Object[])new Object[0]);
            if (b == null || !b.getClass().equals(Boolean.class)) {
                return;
            }
            boolean visibility = namesMode == UserEntityNamesMode.ALWAYS_VISIBLE;
            Reflex.setFieldValue(index3, (String)"b", (Object)visibility);
        }
    }

    protected void managePlayerHelmet(@NotNull EnginePlayerPacketEvent e, @NotNull Object packet) {
        Object worldServer;
        Class playOutEntityEquipment = Reflex.getNMSClass((String)"PacketPlayOutEntityEquipment");
        Class enumItemSlotClass = Reflex.getNMSClass((String)"EnumItemSlot");
        Object p = playOutEntityEquipment.cast(packet);
        List slots = (List)Reflex.getFieldValue(p, (String)"b");
        if (slots == null || !slots.contains(Reflex.getEnum((Class)enumItemSlotClass, (String)"HEAD"))) {
            return;
        }
        Integer entityId = (Integer)Reflex.getFieldValue(p, (String)"a");
        if (entityId == null) {
            return;
        }
        Class craftServerClass = Reflex.getCraftClass((String)"CraftServer");
        Class nmsEntityClass = Reflex.getNMSClass((String)"Entity");
        Class worldServerClass = Reflex.getNMSClass((String)"WorldServer");
        Object server = craftServerClass.cast(Bukkit.getServer());
        Object nmsEntity = null;
        Object dedicatedServer = Reflex.invokeMethod((Method)Reflex.getMethod((Class)craftServerClass, (String)"getServer", (Class[])new Class[0]), server, (Object[])new Object[0]);
        Iterable worlds = (Iterable)Reflex.invokeMethod((Method)Reflex.getMethod(dedicatedServer.getClass(), (String)"getWorlds", (Class[])new Class[0]), (Object)dedicatedServer, (Object[])new Object[0]);
        Method getEntity = Reflex.getMethod((Class)worldServerClass, (String)"getEntity", (Class[])new Class[]{Integer.TYPE});
        Iterator iterator = worlds.iterator();
        while (iterator.hasNext() && (nmsEntity = Reflex.invokeMethod((Method)getEntity, worldServer = iterator.next(), (Object[])new Object[]{(int)entityId})) == null) {
        }
        if (nmsEntity == null) {
            return;
        }
        Method getUniqueId = Reflex.getMethod((Class)nmsEntityClass, (String)"getUniqueID", (Class[])new Class[0]);
        Entity bukkitEntity = CodexEngine.get().getServer().getEntity((UUID)Reflex.invokeMethod((Method)getUniqueId, (Object)nmsEntity, (Object[])new Object[0]));
        if (bukkitEntity == null || Hooks.isNPC((Entity)bukkitEntity) || !(bukkitEntity instanceof Player)) {
            return;
        }
        Player player = (Player)bukkitEntity;
        DivinityUser user = (DivinityUser)this.plugin.getUserManager().getOrLoadUser(player);
        if (user == null) {
            return;
        }
        UserProfile profile = user.getActiveProfile();
        if (profile.isHideHelmet()) {
            Reflex.setFieldValue(p, (String)"c", (Object)Reflex.getFieldValue((Object)Reflex.getNMSClass((String)"ItemStack"), (String)"a"));
        }
    }
}

