/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.sets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.api.armor.ArmorEquipEvent;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.LoadableItem;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.fortify.FortifyManager;
import studio.magemonkey.divinity.modules.list.refine.RefineManager;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.utils.LoreUT;

public class SetManager
extends QModule {
    private static final List<String> SET_LORE_TAG = List.of("set_cache", "qrpg_set_cache");
    private String formatElementActive;
    private String formatElementInactive;
    private List<String> formatLore;
    private Map<String, ItemSet> sets;

    public SetManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "sets";
    }

    @NotNull
    public String version() {
        return "1.62";
    }

    public void setup() {
        String path = "format.";
        this.formatElementActive = StringUT.color((String)this.cfg.getString(path + "element.active", "%c%\u2022 %name% &a\u2713"));
        this.formatElementInactive = StringUT.color((String)this.cfg.getString(path + "element.inactive", "%c%\u2022 %name% &c\u2717"));
        this.formatLore = StringUT.color((List)this.cfg.getStringList(path + "lore"));
        this.sets = new HashMap<String, ItemSet>();
        ((Divinity)this.plugin).getConfigManager().extractFullPath(this.getFullPath() + "items");
        for (JYML cfg : JYML.loadAll((String)(this.getFullPath() + "items"), (boolean)true)) {
            try {
                ItemSet set = new ItemSet((Divinity)this.plugin, cfg);
                this.sets.put(set.getId(), set);
            }
            catch (Exception ex) {
                this.error("Could not load Set: " + cfg.getFile().getName());
                ex.printStackTrace();
            }
        }
    }

    public void shutdown() {
        if (this.sets != null) {
            this.sets.clear();
            this.sets = null;
        }
    }

    public void addSetPotionEffects(@NotNull LivingEntity entity) {
        EntityStats stats = EntityStats.get(entity);
        for (Map.Entry<ItemSet, Integer> e : this.getEquippedSets(entity).entrySet()) {
            int have = e.getValue();
            if (have <= 0) continue;
            ItemSet set = e.getKey();
            set.getElementBonuses().stream().filter(setBonus -> have >= setBonus.getMinElementsAmount()).forEach(setBonus -> setBonus.getPotionEffects().forEach(eff -> stats.addPermaPotionEffect((PotionEffect)eff)));
        }
    }

    @NotNull
    public Map<ItemSet, Integer> getEquippedSets(@NotNull LivingEntity entity) {
        HashMap<ItemSet, Integer> sets = new HashMap<ItemSet, Integer>();
        Collection<ItemSet> sets2 = this.getSets();
        for (ItemStack item : EntityStats.get(entity).getEquipment()) {
            sets2.stream().filter(set -> set.isValidElement(item)).forEach(set -> sets.merge((ItemSet)((Object)set), 1, Integer::sum));
        }
        return sets;
    }

    @NotNull
    public List<BonusMap> getActiveSetBonuses(@NotNull LivingEntity entity) {
        ArrayList<BonusMap> bonuses = new ArrayList<BonusMap>();
        for (Map.Entry<ItemSet, Integer> e : this.getEquippedSets(entity).entrySet()) {
            int have = e.getValue();
            if (have <= 0) continue;
            ItemSet set = e.getKey();
            set.getElementBonuses().stream().filter(elm -> have >= elm.getMinElementsAmount()).forEach(elm -> bonuses.add(elm.getBonusMap()));
        }
        return bonuses;
    }

    @NotNull
    private String getClearName(@NotNull ItemStack item) {
        FortifyManager fortifyManager;
        String name = ItemUT.getItemName((ItemStack)item);
        RefineManager refineManager = ((Divinity)this.plugin).getModuleCache().getRefineManager();
        if (refineManager != null) {
            name = refineManager.getNameWithoutLevel(item, name);
        }
        if ((fortifyManager = ((Divinity)this.plugin).getModuleCache().getFortifyManager()) != null) {
            name = fortifyManager.getNameDeformatted(item, name);
        }
        return name.trim();
    }

    public boolean hasSet(@NotNull ItemStack item) {
        return this.getItemSet(item) != null;
    }

    @Nullable
    public ItemSet getItemSet(@NotNull ItemStack item) {
        return this.getSets().stream().filter(set -> set.isValidElement(item)).findFirst().orElse(null);
    }

    private void updateSets(@NotNull Player player) {
        EntityStats entityStats = EntityStats.get((LivingEntity)player);
        entityStats.updateAll();
        entityStats.getEquipment().forEach(item -> this.updateItemSet((ItemStack)item, player));
    }

    public void updateItemSet(@NotNull ItemStack item, @Nullable Player player) {
        ItemSet set;
        String key;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        StringBuilder loreTag = new StringBuilder();
        String storedTag = null;
        Iterator<String> iterator = SET_LORE_TAG.iterator();
        while (iterator.hasNext() && (storedTag = ItemUT.getLoreTag((ItemStack)item, (String)(key = iterator.next()))) == null) {
        }
        String[] storedLines = storedTag != null ? storedTag.split("__x__") : new String[]{};
        int pos = lore.indexOf("%ITEM_SET%");
        if (pos < 0) {
            if (storedLines.length > 0) {
                int index;
                int firstText = -1;
                for (String stored : storedLines) {
                    ++firstText;
                    if (!StringUT.colorOff((String)stored).isEmpty()) break;
                }
                if ((index = lore.indexOf(storedLines[firstText]) - firstText) >= 0) {
                    pos = index;
                    for (int count = 0; count < storedLines.length; ++count) {
                        lore.remove(index);
                    }
                }
            }
            if (pos < 0) {
                return;
            }
        } else {
            lore.remove(pos);
        }
        if ((set = this.getItemSet(item)) != null) {
            for (String lineFormat : this.formatLore) {
                if (lineFormat.contains("%elements%")) {
                    for (SetElement setPart : set.getElements()) {
                        String name = StringUT.colorOff((String)setPart.getName());
                        String color = set.getColorInactive();
                        String format = this.formatElementInactive;
                        if (player != null && setPart.isEquipped((LivingEntity)player)) {
                            format = this.formatElementActive;
                            color = set.getColorActive();
                        }
                        String name3 = format.replace("%c%", color).replace("%name%", name);
                        pos = LoreUT.addToLore(lore, pos, name3);
                        if (loreTag.length() > 0) {
                            loreTag.append("__x__");
                        }
                        loreTag.append(name3);
                    }
                    continue;
                }
                if (lineFormat.contains("%effects%")) {
                    int partHave = player != null ? set.getEquippedElements((LivingEntity)player) : 0;
                    for (SetElementBonus setPartBonus : set.getElementBonuses()) {
                        int partNeed = setPartBonus.getMinElementsAmount();
                        String color = set.getColorInactive();
                        if (partHave >= partNeed) {
                            color = set.getColorActive();
                        }
                        List<String> loreBonus = setPartBonus.getLore();
                        for (String lineBonus : loreBonus) {
                            Object lineX = lineBonus.replace("%c%", color);
                            if (((String)lineX).isEmpty()) {
                                lineX = String.valueOf(ChatColor.GRAY) + (String)lineX;
                            }
                            pos = LoreUT.addToLore(lore, pos, (String)lineX);
                            if (loreTag.length() > 0) {
                                loreTag.append("__x__");
                            }
                            loreTag.append((String)lineX);
                        }
                    }
                    continue;
                }
                Object lineX = lineFormat.replace("%set%", set.getName());
                if (((String)lineX).isEmpty()) {
                    lineX = String.valueOf(ChatColor.GRAY) + (String)lineX;
                }
                pos = LoreUT.addToLore(lore, pos, (String)lineX);
                if (loreTag.length() > 0) {
                    loreTag.append("__x__");
                }
                loreTag.append((String)lineX);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUT.addLoreTag((ItemStack)item, (String)SET_LORE_TAG.get(0), (String)loreTag.toString());
    }

    @NotNull
    public Collection<ItemSet> getSets() {
        return this.sets.values();
    }

    @Nullable
    public ItemSet getSetById(@NotNull String id) {
        return id.equalsIgnoreCase("random") ? (ItemSet)((Object)Rnd.get(new ArrayList<ItemSet>(this.getSets()))) : this.sets.get(id.toLowerCase());
    }

    @NotNull
    public List<String> getSetNames() {
        return new ArrayList<String>(this.sets.keySet());
    }

    @EventHandler(ignoreCancelled=true)
    public void onSetUpdateEquip(ArmorEquipEvent e) {
        ItemStack newPiece;
        Player p = e.getPlayer();
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        boolean update = false;
        ItemStack oldPiece = e.getOldArmorPiece();
        if (oldPiece != null && this.hasSet(oldPiece)) {
            this.updateItemSet(oldPiece, null);
            update = true;
        }
        if ((newPiece = e.getNewArmorPiece()) != null && this.hasSet(newPiece)) {
            update = true;
        }
        if (update) {
            ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.updateSets(p));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSetUpdateSpawn(ItemSpawnEvent e) {
        Item item = e.getEntity();
        ItemStack stack = item.getItemStack();
        this.updateItemSet(stack, null);
        item.setItemStack(stack);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSetNameHackAnvil(PrepareAnvilEvent e) {
        String nameResult;
        ItemStack result = e.getResult();
        if (result == null) {
            return;
        }
        ItemStack before = e.getInventory().getItem(0);
        if (before == null) {
            return;
        }
        ItemMeta metaBefore = before.getItemMeta();
        ItemMeta metaResult = result.getItemMeta();
        String nameBefore = metaBefore == null ? "" : StringUT.colorOff((String)metaBefore.getDisplayName());
        String string = nameResult = metaResult == null ? "" : StringUT.colorOff((String)metaResult.getDisplayName());
        if (nameBefore.equalsIgnoreCase(nameResult)) {
            return;
        }
        if (this.hasSet(result) || this.hasSet(before)) {
            e.setResult(null);
        }
    }

    public class ItemSet
    extends LoadableItem {
        private final String name;
        private final String prefix;
        private final String suffix;
        private final String colorHave;
        private final String colorMiss;
        private final Map<String, SetElement> elements;
        private final TreeMap<Integer, SetElementBonus> elementBonus;

        public ItemSet(@NotNull Divinity plugin, JYML cfg) {
            super((CodexPlugin)plugin, cfg);
            this.name = StringUT.color((String)cfg.getString("name", this.id));
            this.prefix = StringUT.color((String)cfg.getString("prefix", ""));
            this.suffix = StringUT.color((String)cfg.getString("suffix", ""));
            this.colorHave = StringUT.color((String)cfg.getString("color.active", "&a"));
            this.colorMiss = StringUT.color((String)cfg.getString("color.inactive", "&8"));
            this.elements = new LinkedHashMap<String, SetElement>();
            for (String eId : cfg.getSection("elements")) {
                String path2 = "elements." + eId + ".";
                HashSet<Material> eMaterials = new HashSet<Material>();
                for (String matName : cfg.getStringList(path2 + "materials")) {
                    Material eMat = Material.getMaterial((String)matName.toUpperCase());
                    if (eMat == null) continue;
                    eMaterials.add(eMat);
                }
                if (eMaterials.isEmpty()) {
                    SetManager.this.error("Invalid material for '" + eId + "' element of '" + this.id + "' set!");
                    continue;
                }
                String eRawName = cfg.getString(path2 + "name");
                if (eRawName == null) {
                    SetManager.this.error("No Set Element name provided in: " + cfg.getFile().getName());
                    continue;
                }
                String eName = StringUT.oneSpace((String)StringUT.color((String)eRawName).replace("%suffix%", this.suffix).replace("%prefix%", this.prefix));
                SetElement setElement = new SetElement(eId, eMaterials, eName);
                this.elements.put(setElement.getId(), setElement);
            }
            this.elementBonus = new TreeMap();
            for (String sAmount : cfg.getSection("bonuses.by-elements-amount")) {
                int amount = StringUT.getInteger((String)sAmount, (int)-1);
                if (amount < 1) continue;
                String path2 = "bonuses.by-elements-amount." + sAmount + ".";
                List<String> bonusLore = cfg.getStringList(path2 + "lore").stream().map(StringUT::color).collect(Collectors.toList());
                HashMap<PotionEffectType, Integer> potions = new HashMap<PotionEffectType, Integer>();
                for (String potionName : cfg.getSection(path2 + "potion-effects")) {
                    PotionEffectType pet = PotionEffectType.getByName((String)potionName.toUpperCase());
                    if (pet == null) {
                        SetManager.this.error("Invalid potion effect " + potionName + " for set " + this.id);
                        continue;
                    }
                    int level = cfg.getInt(path2 + "potion-effects." + potionName);
                    if (level <= 0) continue;
                    potions.put(pet, level);
                }
                BonusMap bonusMap = new BonusMap();
                bonusMap.loadStats(cfg, path2 + "item-stats");
                bonusMap.loadDamages(cfg, path2 + "damage-types");
                bonusMap.loadDefenses(cfg, path2 + "defense-types");
                SetElementBonus spe = new SetElementBonus(amount, bonusLore, potions, bonusMap);
                this.elementBonus.put(amount, spe);
            }
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public String getColorActive() {
            return this.colorHave;
        }

        @NotNull
        public String getColorInactive() {
            return this.colorMiss;
        }

        @NotNull
        public Collection<SetElement> getElements() {
            return this.elements.values();
        }

        @Nullable
        public SetElement getElement(@NotNull String id) {
            return this.elements.get(id.toLowerCase());
        }

        @NotNull
        public Collection<SetElementBonus> getElementBonuses() {
            return this.elementBonus.values();
        }

        public boolean isValidElement(@NotNull ItemStack item) {
            return this.getElements().stream().anyMatch(element -> element.isValidElement(item));
        }

        public int getEquippedElements(@NotNull LivingEntity entity) {
            return (int)this.getElements().stream().filter(element -> element.isEquipped(entity)).count();
        }

        protected void save(@NotNull JYML cfg) {
        }
    }

    public class SetElement {
        private final String id;
        private final Set<Material> materials;
        private String name;

        public SetElement(@NotNull String id, @NotNull Set<Material> materials, String name) {
            this.id = id.toLowerCase();
            this.materials = materials;
            this.setName(name);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public Set<Material> getMaterials() {
            return this.materials;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public void setName(@NotNull String name) {
            this.name = name.trim();
        }

        public boolean isEquipped(@NotNull LivingEntity p) {
            return EntityStats.get(p).getEquipment().stream().anyMatch(this::isValidElement);
        }

        public boolean isValidElement(@NotNull ItemStack item) {
            if (!this.getMaterials().contains(item.getType())) {
                return false;
            }
            String itemName = StringUT.colorOff((String)SetManager.this.getClearName(item));
            String elemName = StringUT.colorOff((String)this.getName());
            return itemName.toLowerCase().contains(elemName.toLowerCase());
        }
    }

    public class SetElementBonus {
        private final int minAmount;
        private final List<String> lore;
        private final Set<PotionEffect> potions;
        private final BonusMap bonusMap;

        public SetElementBonus(@NotNull int amount, @NotNull List<String> lore, @NotNull Map<PotionEffectType, Integer> potions, BonusMap bonusMap) {
            this.minAmount = amount;
            this.lore = lore;
            this.potions = new HashSet<PotionEffect>();
            for (Map.Entry<PotionEffectType, Integer> e : potions.entrySet()) {
                PotionEffectType type = e.getKey();
                int dur = 140;
                if (type.equals(PotionEffectType.NIGHT_VISION) || type.getName().equalsIgnoreCase(PotionEffectType.NIGHT_VISION.getName())) {
                    dur *= 5;
                }
                PotionEffect pe = new PotionEffect(type, dur, Math.max(0, e.getValue() - 1));
                this.potions.add(pe);
            }
            this.bonusMap = bonusMap;
        }

        public int getMinElementsAmount() {
            return this.minAmount;
        }

        @NotNull
        public List<String> getLore() {
            return this.lore;
        }

        @NotNull
        public Set<PotionEffect> getPotionEffects() {
            return this.potions;
        }

        @NotNull
        public BonusMap getBonusMap() {
            return this.bonusMap;
        }
    }
}

