/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.party.compat.level;

import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.party.PartyManager;

public abstract class IPartyLevelManager
extends IListener<Divinity> {
    protected PartyManager partyManager;

    public IPartyLevelManager(@NotNull Divinity plugin, @NotNull PartyManager partyManager) {
        super((JavaPlugin)plugin);
        this.partyManager = partyManager;
    }

    public void setup() {
        this.registerListeners();
    }

    public void shutdown() {
        this.unregisterListeners();
    }

    protected final int getBalancedExp(@NotNull Player player, int amount) {
        PartyManager.PartyMember member = this.partyManager.getPartyMember(player);
        if (member == null || amount <= 0) {
            return 0;
        }
        PartyManager.Party party = member.getParty();
        if (party.getExpMode() != PartyManager.PartyExpMode.SHARED) {
            return 0;
        }
        int expDistance = this.partyManager.getSettings().getMaxLevelExpBalanceDistance();
        Set<PartyManager.PartyMember> expGetters = party.getMembersByDistance(member, expDistance);
        int size = expGetters.size() + 1;
        int[] each = IPartyLevelManager.splitIntoParts(amount, size);
        int i = 0;
        for (PartyManager.PartyMember friend : expGetters) {
            Player pFriend = friend.getPlayer();
            if (pFriend == null) continue;
            this.giveExp(pFriend, each[i++]);
        }
        return each[i];
    }

    private static int[] splitIntoParts(int whole, int parts) {
        int[] arr = new int[parts];
        int remain = whole;
        int partsLeft = parts;
        int i = 0;
        while (partsLeft > 0) {
            int size;
            arr[i] = size = (remain + partsLeft - 1) / partsLeft;
            remain -= size;
            --partsLeft;
            ++i;
        }
        return arr;
    }

    public abstract void giveExp(@NotNull Player var1, int var2);
}

