/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.party;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.party.PartyManager;

public class PartyGUI
extends NGUI<Divinity> {
    private PartyManager partyManager;
    private String memberName;
    private List<String> memberLore;
    private int[] memberSlots;

    public PartyGUI(@NotNull PartyManager partyManager) {
        super((CodexPlugin)((Divinity)partyManager.plugin), partyManager.getJYML(), "gui.");
        this.partyManager = partyManager;
        JYML cfg = partyManager.getJYML();
        String path = "gui.";
        this.memberName = StringUT.color((String)cfg.getString(path + "member.name", "&eParty Member"));
        this.memberLore = StringUT.color((List)cfg.getStringList(path + "member.lore"));
        this.memberSlots = cfg.getIntArray(path + "member.slots");
        GuiClick click = (p, type, e) -> {
            if (type == null) {
                return;
            }
            PartyManager.PartyMember member = partyManager.getPartyMember(p);
            if (member == null) {
                p.closeInventory();
                return;
            }
            if (type == ContentType.EXIT) {
                p.closeInventory();
                return;
            }
            if (!type.getClass().equals(GUIPartyType.class)) {
                return;
            }
            GUIPartyType type2 = (GUIPartyType)type;
            switch (type2.ordinal()) {
                case 1: {
                    partyManager.disbandParty(p);
                    p.closeInventory();
                    break;
                }
                case 2: {
                    member.leaveParty();
                    p.closeInventory();
                    break;
                }
                case 3: {
                    partyManager.togglePartyDrop(p);
                    this.open(p, 1);
                    break;
                }
                case 4: {
                    partyManager.togglePartyExp(p);
                    this.open(p, 1);
                    break;
                }
                case 5: {
                    partyManager.toggleChat(p);
                    break;
                }
            }
        };
        for (String itemId : cfg.getSection(path + "content")) {
            GuiItem guiItem = cfg.getGuiItem(path + "content." + itemId, GUIPartyType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
        PartyManager.Party party = this.partyManager.getPlayerParty(player);
        if (party == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)player);
            return;
        }
        int j = 0;
        for (PartyManager.PartyMember member : party.getMembers()) {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            if (meta == null) continue;
            String online = ((Divinity)this.plugin).lang().getBool(member.getPlayer() != null);
            meta.setDisplayName(this.memberName.replace("%online%", online).replace("%name%", member.getName()));
            ArrayList<String> lore = new ArrayList<String>(this.memberLore);
            lore.replaceAll(str -> str.replace("%online%", online).replace("%name%", member.getName()));
            meta.setLore(lore);
            meta.setOwningPlayer(((Divinity)this.plugin).getServer().getOfflinePlayer(member.getUUID()));
            head.setItemMeta((ItemMeta)meta);
            JIcon icon = new JIcon(head);
            icon.setClick((p, type, e) -> {
                if (e.isLeftClick()) {
                    this.partyManager.teleport(p, member.getPlayer());
                } else if (e.isRightClick()) {
                    this.partyManager.kickFromParty(p, member.getPlayer());
                    this.open(p, 1);
                }
            });
            this.addButton(player, icon, new int[]{this.memberSlots[j++]});
        }
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    protected void replaceMeta(@NotNull Player player, @NotNull ItemStack item, @NotNull GuiItem guiItem) {
        super.replaceMeta(player, item, guiItem);
        PartyManager.Party party = this.partyManager.getPlayerParty(player);
        if (party == null) {
            return;
        }
        PartyManager.PartyMember leader = party.getLeader();
        String dropMode = ((Divinity)this.plugin).lang().getEnum(party.getDropMode());
        String expMode = ((Divinity)this.plugin).lang().getEnum(party.getExpMode());
        String leaderName = leader != null ? leader.getName() : "null";
        String memSize = String.valueOf(party.getMembers().size());
        String name = party.getId();
        String fullSize = String.valueOf(party.getSize());
        ItemUT.replace((ItemStack)item, str -> str.replace("%party_drop%", dropMode).replace("%party_exp%", expMode).replace("%party_leader%", leaderName).replace("%party_members%", memSize).replace("%party_name%", name).replace("%party_size%", fullSize));
    }

    static enum GUIPartyType {
        PARTY_MEMBER,
        PARTY_DISBAND,
        PARTY_LEAVE,
        PARTY_DROP,
        PARTY_EXP,
        PARTY_CHAT;

    }
}

