/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.AbstractAttributeGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.DamageInformation;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.FabledAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.utils.ItemUtils;
import studio.magemonkey.divinity.utils.LoreUT;

public class AttributeGenerator<A extends ItemLoreStat<?>>
extends AbstractAttributeGenerator {
    protected Map<A, DamageInformation> attributes;

    public AttributeGenerator(@NotNull Divinity plugin, @NotNull ItemGeneratorManager.GeneratorItem generatorItem, @NotNull String path, @NotNull Collection<A> attributesAll, @NotNull String placeholder) {
        super(plugin, generatorItem, placeholder);
        JYML cfg = this.generatorItem.getConfig();
        this.minAmount = cfg.getInt(path + "minimum");
        this.maxAmount = cfg.getInt(path + "maximum");
        this.loreFormat = StringUT.color((List)cfg.getStringList(path + "lore-format"));
        this.attributes = new HashMap<A, DamageInformation>();
        attributesAll.forEach(att -> {
            double m2;
            String path2 = path + "list." + att.getId() + ".";
            boolean isSocket = att instanceof SocketAttribute;
            cfg.addMissing(path2 + "chance", (Object)0.0);
            if (!isSocket) {
                cfg.addMissing(path2 + "scale-by-level", (Object)1.0);
                cfg.addMissing(path2 + "min", (Object)0);
                cfg.addMissing(path2 + "max", (Object)0);
                cfg.addMissing(path2 + "flat-range", (Object)false);
                if (!this.getPlaceholder().equalsIgnoreCase("%GENERATOR_FABLED_ATTR%")) {
                    cfg.addMissing(path2 + "round", (Object)false);
                }
            }
            if (!this.loreFormat.contains(att.getPlaceholder())) {
                this.loreFormat.add(att.getPlaceholder());
                cfg.set(path + "lore-format", (Object)this.loreFormat);
            }
            double chance = cfg.getDouble(path2 + "chance");
            double m1 = cfg.getDouble(path2 + "min", 0.0);
            if (m1 > (m2 = cfg.getDouble(path2 + "max", 0.0))) {
                double temp = m1;
                m1 = m2;
                m2 = temp;
            }
            double scale = cfg.getDouble(path2 + "scale-by-level", 1.0);
            boolean flatRange = cfg.getBoolean(path2 + "flat-range", false);
            boolean roundValues = cfg.getBoolean(path2 + "round", false);
            DamageInformation damageInfo = new DamageInformation(chance, m1, m2, scale, flatRange, roundValues);
            this.attributes.put(att, damageInfo);
        });
    }

    @Override
    public void generate(@NotNull ItemStack item, int itemLevel) {
        int max;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        boolean isSocket = false;
        boolean isValid = true;
        Optional opt = this.getAttributes().keySet().stream().findFirst();
        if (opt.isPresent()) {
            ItemLoreStat check = (ItemLoreStat)opt.get();
            if (check instanceof DefenseAttribute && !ItemUtils.isArmor(item)) {
                isValid = false;
            } else if (check instanceof DamageAttribute && ItemUtils.isArmor(item)) {
                isValid = false;
            }
            isSocket = check instanceof SocketAttribute;
        }
        Map<A, DamageInformation> stats = this.getAttributes();
        int generatorPos = lore.indexOf(this.placeholder);
        int min = this.getMinAmount();
        int n = max = isSocket ? this.getMaxAmount() : Math.min(stats.size(), this.getMaxAmount());
        if (generatorPos < 0 || max == 0 || stats.isEmpty() || !isValid) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        boolean isMaxUnlimited = max < 0;
        boolean isMinUnlimited = min < 0;
        int maxSize = stats.size();
        int rollMax = isMaxUnlimited ? maxSize : max;
        int rollMin = isMinUnlimited || isMinUnlimited && isMaxUnlimited ? Rnd.get((int)(rollMax + 1)) : min;
        int roll = Rnd.get((int)(isMaxUnlimited ? rollMax : rollMin), (int)rollMax);
        if (roll <= 0) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        HashMap mapChance = new HashMap();
        stats.forEach((stat, values) -> mapChance.put(stat, values.getChance()));
        boolean noStats = true;
        for (int count = 0; count < roll; ++count) {
            DamageInformation values2;
            Map<ItemLoreStat, Double> filtered;
            ItemLoreStat stat2 = count < rollMin ? ((filtered = mapChance.keySet().stream().filter(a -> (Double)mapChance.get(a) >= 100.0).collect(Collectors.toMap(a -> a, mapChance::get, (a1, b) -> b))).isEmpty() ? (ItemLoreStat)Rnd.getRandomItem(mapChance) : (ItemLoreStat)Rnd.getRandomItem(filtered)) : (ItemLoreStat)Rnd.get(new ArrayList(mapChance.keySet()));
            if (stat2 == null || (values2 = stats.get(stat2)) == null) continue;
            if (count >= rollMin && (double)Rnd.get((boolean)true) >= values2.getChance()) {
                if (isSocket) continue;
                mapChance.remove(stat2);
                continue;
            }
            if (noStats) {
                for (String format : this.getLoreFormat()) {
                    generatorPos = LoreUT.addToLore(lore, generatorPos, format);
                }
                lore.remove(this.placeholder);
                meta.setLore(lore);
                item.setItemMeta(meta);
                noStats = false;
            }
            if (stat2 instanceof SocketAttribute) {
                SocketAttribute socketAtt = (SocketAttribute)stat2;
                int sPos = -1;
                if (!stat2.hasPlaceholder(item)) {
                    sPos = socketAtt.getLoreIndex(item, 0);
                }
                socketAtt.add(item, socketAtt.getDefaultValue(), sPos);
                continue;
            }
            if (stat2.hasPlaceholder(item)) {
                BiFunction<Boolean, Double, Double> vMod = this.generatorItem.getMaterialModifiers(item, stat2);
                double vScale = this.generatorItem.getScaleOfLevel(values2.getScaleByLevel(), itemLevel);
                double vMin = BonusCalculator.SIMPLE_FULL.apply(values2.getMin(), List.of(vMod)) * vScale;
                double vMax = BonusCalculator.SIMPLE_FULL.apply(values2.getMax(), List.of(vMod)) * vScale;
                if (stat2 instanceof DamageAttribute) {
                    DamageAttribute dmgAtt = (DamageAttribute)stat2;
                    double rndV1 = vMin;
                    double rndV2 = vMax;
                    if (!values2.isFlatRange()) {
                        rndV1 = NumberUT.round((double)Rnd.getDouble((double)vMin, (double)vMax));
                        rndV2 = NumberUT.round((double)Rnd.getDouble((double)vMin, (double)vMax));
                        if (values2.isRound()) {
                            rndV1 = Math.round(rndV1);
                            rndV2 = Math.round(rndV2);
                        }
                    }
                    double vFinMin = Math.min(rndV1, rndV2);
                    double vFinMax = Math.max(rndV1, rndV2);
                    if (vFinMin != 0.0 || vFinMax != 0.0) {
                        dmgAtt.add(item, new StatBonus(new double[]{vFinMin, vFinMax}, false, null), -1);
                    }
                } else {
                    double vFin = NumberUT.round((double)Rnd.getDouble((double)vMin, (double)vMax));
                    if (values2.isRound()) {
                        vFin = Math.round(vFin);
                    }
                    if (vFin != 0.0) {
                        if (stat2 instanceof DefenseAttribute) {
                            DefenseAttribute defAtt = (DefenseAttribute)stat2;
                            defAtt.add(item, new StatBonus(new double[]{vFin}, false, null), -1);
                        } else if (stat2 instanceof FabledAttribute) {
                            FabledAttribute fabledAttribute = (FabledAttribute)stat2;
                            fabledAttribute.add(item, (int)Math.floor(vFin), -1);
                        }
                    }
                }
                for (StatBonus statBonus : this.generatorItem.getClassBonuses(stat2)) {
                    stat2.add(item, statBonus, -1);
                }
                for (StatBonus statBonus : this.generatorItem.getRarityBonuses(stat2)) {
                    stat2.add(item, statBonus, -1);
                }
                for (StatBonus statBonus : this.generatorItem.getMaterialBonuses(item, stat2)) {
                    stat2.add(item, statBonus, -1);
                }
            }
            mapChance.remove(stat2);
        }
        if (noStats) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
        }
    }

    @NotNull
    public Map<A, DamageInformation> getAttributes() {
        return this.attributes;
    }
}

