/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.skills;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.skills.NewSkillGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.skills.SkillGUI;

public class SkillListGUI
extends AbstractEditorGUI {
    public SkillListGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.SKILLS.getTitle(), itemGenerator);
    }

    public void setContents() {
        ArrayList list = new ArrayList();
        final JYML cfg = this.itemGenerator.getConfig();
        ConfigurationSection section = cfg.getConfigurationSection(EditorGUI.ItemType.SKILLS.getPath() + ".list");
        if (section != null) {
            list.addAll(section.getKeys(false));
        }
        final ArrayList<String> missingList = new ArrayList<String>();
        FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
        if (fabledHook != null) {
            for (String skillId : fabledHook.getSkills()) {
                boolean missing = true;
                for (String key : list) {
                    if (!key.equalsIgnoreCase(skillId)) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                missingList.add(skillId);
            }
        }
        Collections.sort(missingList);
        if (!missingList.isEmpty()) {
            list.add(null);
        }
        int i = 0;
        for (String key : list) {
            ItemStack indicator;
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            final String path = EditorGUI.ItemType.SKILLS.getPath() + ".list." + key;
            if (key == null) {
                this.setSlot(i, new Slot(SkillListGUI.createItem(Material.REDSTONE, "&eAdd new skill", new String[0])){

                    public void onLeftClick() {
                        SkillListGUI.this.openSubMenu(new NewSkillGUI(SkillListGUI.this.player, SkillListGUI.this.itemGenerator, missingList));
                    }
                });
                continue;
            }
            ItemStack itemStack = SkillListGUI.createItem(Material.JACK_O_LANTERN, "&e" + key, (List<String>)StringUT.replace((String)"%current%", (List)cfg.getStringList(SkillGUI.ItemType.LORE.getPath(path)), (String[])new String[]{"&bChance: &a" + cfg.getDouble(SkillGUI.ItemType.CHANCE.getPath(path)), "&bMinimum level: &a" + cfg.getInt(SkillGUI.ItemType.MIN.getPath(path)), "&bMaximum level: &a" + cfg.getInt(SkillGUI.ItemType.MAX.getPath(path)), "&bLore format:", "&a----------", "&f%current%", "&a----------", "&6Left-Click: &eModify", "&6Right-Click: &eRemove"}));
            if (fabledHook != null && (indicator = fabledHook.getSkillIndicator(key)) != null) {
                ItemMeta indicatorMeta;
                itemStack.setType(indicator.getType());
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta != null && (indicatorMeta = indicator.getItemMeta()) != null && indicatorMeta.hasCustomModelData()) {
                    itemMeta.setCustomModelData(Integer.valueOf(indicatorMeta.getCustomModelData()));
                    itemStack.setItemMeta(itemMeta);
                }
            }
            this.setSlot(i, new Slot(itemStack){

                public void onLeftClick() {
                    SkillListGUI.this.openSubMenu(new SkillGUI(SkillListGUI.this.player, SkillListGUI.this.itemGenerator, path));
                }

                public void onRightClick() {
                    cfg.remove(path);
                    SkillListGUI.this.saveAndReopen();
                }
            });
        }
        if (list.get(list.size() - 1) == null) {
            list.remove(list.size() - 1);
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

