/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.skills;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.LoreGUI;

public class SkillGUI
extends AbstractEditorGUI {
    private final String path;

    public SkillGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, String path) {
        super(player, 1, "Editor/" + EditorGUI.ItemType.SKILLS.getTitle(), itemGenerator);
        this.path = path;
    }

    public void setContents() {
        this.setSlot(0, new Slot(SkillGUI.createItem(Material.DROPPER, "&eChance", "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(ItemType.CHANCE.getPath(this.path)), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                SkillGUI.this.sendSetMessage(ItemType.CHANCE.getTitle(), String.valueOf(SkillGUI.this.itemGenerator.getConfig().getDouble(ItemType.CHANCE.getPath(SkillGUI.this.path))), s -> {
                    SkillGUI.this.itemGenerator.getConfig().set(ItemType.CHANCE.getPath(SkillGUI.this.path), (Object)Double.parseDouble(s));
                    SkillGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.CHANCE.getPath(SkillGUI.this.path), (Object)0);
                SkillGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(SkillGUI.createItem(Material.BROWN_MUSHROOM, "&eMinimum Level", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MIN.getPath(this.path)), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(SkillGUI.this.path), (Object)Math.max(1, SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MIN.getPath(SkillGUI.this.path)) - 1));
                SkillGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(SkillGUI.this.path), (Object)(SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MIN.getPath(SkillGUI.this.path)) + 1));
                SkillGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                SkillGUI.this.sendSetMessage(ItemType.MIN.getTitle(), String.valueOf(SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MIN.getPath(SkillGUI.this.path))), s -> {
                    SkillGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(SkillGUI.this.path), (Object)Double.parseDouble(s));
                    SkillGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(SkillGUI.this.path), (Object)1);
                SkillGUI.this.saveAndReopen();
            }
        });
        this.setSlot(2, new Slot(SkillGUI.createItem(Material.RED_MUSHROOM, "&eMaximum Level", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MAX.getPath(this.path)), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(SkillGUI.this.path), (Object)Math.max(1, SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MAX.getPath(SkillGUI.this.path)) - 1));
                SkillGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(SkillGUI.this.path), (Object)(SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MAX.getPath(SkillGUI.this.path)) + 1));
                SkillGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                SkillGUI.this.sendSetMessage(ItemType.MAX.getTitle(), String.valueOf(SkillGUI.this.itemGenerator.getConfig().getInt(ItemType.MAX.getPath(SkillGUI.this.path))), s -> {
                    SkillGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(SkillGUI.this.path), (Object)Double.parseDouble(s));
                    SkillGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(SkillGUI.this.path), (Object)1);
                SkillGUI.this.saveAndReopen();
            }
        });
        this.setSlot(3, new Slot(SkillGUI.createItem(Material.WRITABLE_BOOK, "&eLore format", (List<String>)StringUT.replace((String)"%current%", (List)this.itemGenerator.getConfig().getStringList(ItemType.LORE.getPath(this.path)), (String[])new String[]{"&bCurrent:", "&a----------", "&f%current%", "&a----------", "&6Left-Click: &eModify", "&6RightClick: &eSet to default value"}))){

            public void onLeftClick() {
                SkillGUI.this.openSubMenu(new LoreGUI(SkillGUI.this.player, SkillGUI.this.title, SkillGUI.this.itemGenerator, ItemType.LORE.getPath(SkillGUI.this.path)));
            }

            public void onDrop() {
                SkillGUI.this.itemGenerator.getConfig().set(ItemType.LORE.getPath(SkillGUI.this.path), List.of("&b" + SkillGUI.this.path.substring(SkillGUI.this.path.lastIndexOf(46) + 1) + " &7Lvl. &f%level%"));
                SkillGUI.this.saveAndReopen();
            }
        });
    }

    public static enum ItemType {
        CHANCE("chance"),
        MIN("min-level"),
        MAX("max-level"),
        LORE("lore-format");

        private final String path;

        private ItemType(String path) {
            this.path = path;
        }

        public String getPath(String rootPath) {
            return rootPath + "." + this.path;
        }

        public String getTitle() {
            return this.path.replace('-', ' ');
        }
    }
}

