/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.enchantments;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.enchantments.EnchantmentListGUI;

public class EnchantmentsGUI
extends AbstractEditorGUI {
    public EnchantmentsGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 1, "Editor/" + EditorGUI.ItemType.ENCHANTMENTS.getTitle(), itemGenerator);
    }

    public void setContents() {
        this.setSlot(0, new Slot(EnchantmentsGUI.createItem(Material.BROWN_MUSHROOM, "&eMinimum enchantments", "&bCurrent: &a" + this.itemGenerator.getHandle().getMinEnchantments(), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MINIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Math.max(0, EnchantmentsGUI.this.itemGenerator.getHandle().getMinEnchantments() - 1));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MINIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Math.max(0, EnchantmentsGUI.this.itemGenerator.getHandle().getMinEnchantments() + 1));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EnchantmentsGUI.this.sendSetMessage(ItemType.MINIMUM.name().toLowerCase() + " enchantments", String.valueOf(EnchantmentsGUI.this.itemGenerator.getHandle().getMinEnchantments()), s -> {
                    EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MINIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Integer.parseInt(s));
                    EnchantmentsGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EnchantmentsGUI.this.setDefault(ItemType.MINIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()));
                EnchantmentsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(EnchantmentsGUI.createItem(Material.RED_MUSHROOM, "&eMaximum enchantments", "&bCurrent: &a" + this.itemGenerator.getHandle().getMaxEnchantments(), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MAXIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Math.max(0, EnchantmentsGUI.this.itemGenerator.getHandle().getMaxEnchantments() - 1));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MAXIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Math.max(0, EnchantmentsGUI.this.itemGenerator.getHandle().getMaxEnchantments() + 1));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EnchantmentsGUI.this.sendSetMessage(ItemType.MAXIMUM.name().toLowerCase() + " enchantments", String.valueOf(EnchantmentsGUI.this.itemGenerator.getHandle().getMaxEnchantments()), s -> {
                    EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.MAXIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)Integer.parseInt(s));
                    EnchantmentsGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EnchantmentsGUI.this.setDefault(ItemType.MAXIMUM.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()));
                EnchantmentsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(2, new Slot(EnchantmentsGUI.createItem(Material.BOW, "&eSafe enchantments only", "&bCurrent: &a" + this.itemGenerator.getHandle().isSafeEnchant(), "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.SAFE_ONLY.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)(!EnchantmentsGUI.this.itemGenerator.getHandle().isSafeEnchant() ? 1 : 0));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                EnchantmentsGUI.this.setDefault(ItemType.SAFE_ONLY.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()));
                EnchantmentsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(3, new Slot(EnchantmentsGUI.createItem(Material.EXPERIENCE_BOTTLE, "&eSafe enchantment levels only", "&bCurrent: &a" + this.itemGenerator.getHandle().isEnchantsSafeLevels(), "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                EnchantmentsGUI.this.itemGenerator.getConfig().set(ItemType.SAFE_LEVELS.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()), (Object)(!EnchantmentsGUI.this.itemGenerator.getHandle().isEnchantsSafeLevels() ? 1 : 0));
                EnchantmentsGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                EnchantmentsGUI.this.setDefault(ItemType.SAFE_LEVELS.getPath(EditorGUI.ItemType.ENCHANTMENTS.getPath()));
                EnchantmentsGUI.this.saveAndReopen();
            }
        });
        this.setSlot(4, new Slot(EnchantmentsGUI.createItem(Material.ENCHANTED_BOOK, "&eList of enchantments", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EnchantmentsGUI.this.openSubMenu(new EnchantmentListGUI(EnchantmentsGUI.this.player, EnchantmentsGUI.this.itemGenerator));
            }
        });
    }

    public static enum ItemType {
        MINIMUM,
        MAXIMUM,
        SAFE_ONLY,
        SAFE_LEVELS,
        LIST;


        public String getPath(String path) {
            return path + "." + this.name().toLowerCase().replace('_', '-');
        }
    }
}

