/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.manager.api.menu.Menu;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;

public abstract class AbstractEditorGUI
extends Menu {
    public static final String CURRENT_PLACEHOLDER = "%current%";
    static AbstractEditorGUI instance;
    protected ItemGeneratorReference itemGenerator;

    public AbstractEditorGUI(Player player, int rows, String title, ItemGeneratorReference itemGenerator) {
        super(player, rows, title);
        this.itemGenerator = itemGenerator;
    }

    @Nullable
    public static AbstractEditorGUI getInstance() {
        return instance;
    }

    public void open(int page) {
        if (instance != null) {
            for (HumanEntity humanEntity : instance.getInventory().getViewers()) {
                if (humanEntity.getUniqueId().equals(this.player.getUniqueId())) continue;
                throw new IllegalStateException("Another editor is already open");
            }
        }
        super.open(page);
        instance = this;
    }

    public void shutdown() {
        instance = null;
    }

    protected static ItemStack createItem(Material material, String name, String ... lore) {
        return AbstractEditorGUI.createItem(material, name, List.of(lore));
    }

    protected static ItemStack createItem(Material material, String name, List<String> lore) {
        return AbstractEditorGUI.createItem(new ItemStack(material), name, lore);
    }

    protected static ItemStack createItem(ItemStack itemStack, String name, String ... lore) {
        return AbstractEditorGUI.createItem(itemStack, name, List.of(lore));
    }

    protected static ItemStack createItem(ItemStack itemStack, String name, List<String> lore) {
        ItemFlag hidePotionsFlag;
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        try {
            hidePotionsFlag = ItemFlag.HIDE_ADDITIONAL_TOOLTIP;
        }
        catch (NoSuchFieldError ignored) {
            hidePotionsFlag = ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{hidePotionsFlag});
        if (Version.CURRENT.isHigher(Version.V1_19_R3)) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
        meta.setDisplayName(StringUT.color((String)name));
        ArrayList<String> coloredLore = new ArrayList<String>(lore.size());
        for (String loreLine : lore) {
            coloredLore.add(StringUT.color((String)loreLine));
        }
        meta.setLore(coloredLore);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    protected List<String> color(List<String> list) {
        ArrayList<String> coloredList = new ArrayList<String>(list.size());
        for (String string : list) {
            coloredList.add(StringUT.color((String)string));
        }
        return coloredList;
    }

    protected List<String> color(String ... strings) {
        ArrayList<String> coloredList = new ArrayList<String>(strings.length);
        for (String string : strings) {
            coloredList.add(StringUT.color((String)string));
        }
        return coloredList;
    }

    protected void saveAndReopen() {
        this.itemGenerator.reload();
        new BukkitRunnable(){

            public void run() {
                if (AbstractEditorGUI.this.parentMenu == null) {
                    AbstractEditorGUI.this.open();
                } else {
                    AbstractEditorGUI.this.fakeClosing = true;
                    AbstractEditorGUI.this.parentMenu.openSubMenu((Menu)AbstractEditorGUI.this);
                    AbstractEditorGUI.this.fakeClosing = false;
                }
            }
        }.runTask((Plugin)Divinity.getInstance());
    }

    protected void setDefault(String path) {
        this.itemGenerator.getConfig().set(path, ItemGeneratorManager.commonItemGenerator.get(path));
    }

    protected void sendSetMessage(final String valueName, @Nullable String currentValue, final Consumer<String> onMessage) {
        this.fakeClose();
        final BaseComponent component = StringUT.parseJson((String)("[\"\",{\"text\":\"\\u25b8 Enter the desired " + valueName + ". \"},{\"text\":\"Cancel\",\"underlined\":true,\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"cancel\"}}" + String.valueOf(currentValue == null ? Character.valueOf(']') : ",{\"text\":\" \"},{\"text\":\"Current Value\",\"underlined\":true,\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + currentValue + "\"}}]")));
        this.player.spigot().sendMessage(component);
        this.registerListener(new Listener(){

            @EventHandler
            public void onChat(AsyncPlayerChatEvent event) {
                if (!event.getPlayer().equals((Object)AbstractEditorGUI.this.player)) {
                    return;
                }
                event.setCancelled(true);
                String message = event.getMessage().strip();
                if (message.equalsIgnoreCase("cancel")) {
                    AbstractEditorGUI.this.unregisterListener(this);
                    AbstractEditorGUI.this.saveAndReopen();
                } else {
                    try {
                        onMessage.accept(message);
                        AbstractEditorGUI.this.unregisterListener(this);
                    }
                    catch (IllegalArgumentException e) {
                        Divinity.getInstance().lang().ItemGenerator_Cmd_Editor_Error_InvalidInput.replace("%input%", (Object)message).replace("%value%", (Object)valueName).send((CommandSender)AbstractEditorGUI.this.player);
                        AbstractEditorGUI.this.player.spigot().sendMessage(component);
                    }
                }
            }
        });
    }

    public static class ItemGeneratorReference {
        private ItemGeneratorManager.GeneratorItem handle;

        public ItemGeneratorReference(ItemGeneratorManager.GeneratorItem itemGenerator) {
            this.handle = itemGenerator;
        }

        public ItemGeneratorManager.GeneratorItem getHandle() {
            return this.handle;
        }

        public void reload() {
            JYML cfg = this.getConfig();
            cfg.save();
            this.handle = Objects.requireNonNull((ItemGeneratorManager)Divinity.getInstance().getModuleManager().getModule(ItemGeneratorManager.class)).load(this.handle.getId(), cfg);
        }

        public String getId() {
            return this.handle.getId();
        }

        public JYML getConfig() {
            return this.handle.getConfig();
        }
    }
}

