/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.extractor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.list.extractor.ExtractorManager;
import studio.magemonkey.divinity.modules.list.extractor.event.PlayerExtractSocketEvent;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;

class ExtractGUI
extends NGUI<Divinity> {
    private static final NamespacedKey META_KEY_SOCKET_SELECT = new NamespacedKey((Plugin)Divinity.getInstance(), "QRPG_EXTRACTOR_GUI_SOCKET_SELECTOR");
    private static final NamespacedKey META_KEY_SOCKET_SELECT2 = NamespacedKey.fromString((String)"quantumrpg:qrpg_extractor_gui_socket_selector");
    private final int[] socketSlots;
    protected ExtractorManager extractorManager;
    protected int itemSlot;
    protected int srcSlot;
    protected int resultSlot;
    protected String socketName;
    protected List<String> socketLore;

    public ExtractGUI(@NotNull ExtractorManager extractorManager) {
        super((CodexPlugin)((Divinity)extractorManager.plugin), extractorManager.getJYML(), "gui.");
        this.extractorManager = extractorManager;
        JYML cfg = extractorManager.getJYML();
        String path = "gui.";
        this.itemSlot = cfg.getInt(path + "item-slot");
        this.srcSlot = cfg.getInt(path + "source-slot");
        this.resultSlot = cfg.getInt(path + "result-slot");
        this.socketName = StringUT.color((String)cfg.getString(path + "socket-name", "&7Extract: %name%"));
        this.socketLore = StringUT.color((List)cfg.getStringList(path + "socket-lore"));
        this.socketSlots = cfg.getIntArray(path + "socket-slots");
        GuiClick clickMain = new GuiClick(){

            public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                if (type == ContentType.EXIT) {
                    p.closeInventory();
                }
            }
        };
        for (String itemId : cfg.getSection(path + "content")) {
            GuiItem guiItem = cfg.getGuiItem(path + "content." + itemId, ContentType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(clickMain);
            }
            this.addButton(guiItem);
        }
        GuiClick clickSocket = (p, type, e) -> {
            if (type == null || !type.getClass().equals(SocketAttribute.Type.class)) {
                return;
            }
            SocketAttribute.Type socketType = (SocketAttribute.Type)type;
            Inventory inv = e.getInventory();
            ItemStack target = inv.getItem(this.itemSlot);
            ItemStack src = inv.getItem(this.srcSlot);
            inv.setItem(this.itemSlot, null);
            inv.setItem(this.srcSlot, null);
            this.open(p, target, src, socketType);
        };
        for (String itemId : cfg.getSection(path + "socket-types")) {
            GuiItem guiItem = cfg.getGuiItem(path + "socket-types." + itemId, SocketAttribute.Type.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(clickSocket);
            }
            this.addButton(guiItem);
        }
    }

    public void open(@NotNull Player player, @Nullable ItemStack target, @Nullable ItemStack source, @Nullable SocketAttribute.Type type) {
        ModuleSocket<?> mod;
        if (target == null) {
            target = new ItemStack(Material.AIR);
        }
        if (source == null) {
            source = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)source.getItemMeta();
            if (meta == null) {
                return;
            }
            meta.setDisplayName(player.getName());
            meta.setOwningPlayer((OfflinePlayer)player);
            source.setItemMeta((ItemMeta)meta);
        }
        this.clearUserCache(player);
        this.LOCKED_CACHE.add(player.getName());
        this.addButton(player, new JIcon(target), new int[]{this.itemSlot});
        this.addButton(player, new JIcon(source), new int[]{this.srcSlot});
        if (type != null && target.getType() != Material.AIR && (mod = type.getModule()) != null) {
            ItemMeta meta = target.getItemMeta();
            int indexMain = 0;
            block0: for (SocketAttribute socketAtt : ItemStats.getSockets(type)) {
                String socketCategory = socketAtt.getId();
                for (Map.Entry<Integer, String[]> en : mod.getFilledSocketKeys(meta, socketCategory).entrySet()) {
                    if (indexMain >= this.socketSlots.length) break block0;
                    String[] values = en.getValue();
                    String itemId = values[0];
                    int lvl = StringUT.getInteger((String)values[1], (int)-1);
                    double extractPrice = this.extractorManager.getExtractionPrice(type, socketCategory, lvl);
                    ItemStack item = DivinityAPI.getItemByModule(mod, itemId, lvl, -1, 0);
                    if (item == null) continue;
                    this.replaceCostHave(player, item, socketAtt, extractPrice);
                    int indexSocket = en.getKey();
                    ItemStack src = source;
                    GuiClick itemClick = (p, type2, e) -> {
                        Inventory inv = e.getInventory();
                        for (int socketSlot : this.socketSlots) {
                            ItemStack socketItem = inv.getItem(socketSlot);
                            if (socketItem == null) continue;
                            socketItem.removeEnchantment(NamespaceResolver.getEnchantment((String[])new String[]{"POWER", "ARROW_DAMAGE"}));
                        }
                        ItemStack item1 = e.getCurrentItem();
                        if (item1 != null) {
                            item1.addUnsafeEnchantment(NamespaceResolver.getEnchantment((String[])new String[]{"POWER", "ARROW_DAMAGE"}), 1);
                        }
                        ItemStack target1 = this.getItem(inv, this.itemSlot);
                        List<ItemStack> resultItems = mod.extractSocket(new ItemStack(target1), socketCategory, indexSocket);
                        ItemStack result = resultItems.get(0);
                        resultItems.remove(result);
                        if (e.isLeftClick()) {
                            inv.setItem(this.resultSlot, result);
                        } else if (e.isRightClick()) {
                            PlayerExtractSocketEvent eve = new PlayerExtractSocketEvent(p, target1, result, resultItems, type);
                            VaultHK vh = ((Divinity)this.plugin).getVault();
                            if (extractPrice > 0.0 && vh != null) {
                                double userBalance = vh.getBalance((OfflinePlayer)p);
                                if (userBalance < extractPrice) {
                                    ((Divinity)this.plugin).lang().Extractor_Extract_Error_TooExpensive.replace("%cost%", (Object)NumberUT.format((double)extractPrice)).replace("%balance%", (Object)NumberUT.format((double)userBalance)).send((CommandSender)p);
                                    eve.setFailed(true);
                                } else {
                                    vh.take((OfflinePlayer)p, extractPrice);
                                }
                            }
                            ((Divinity)this.plugin).getPluginManager().callEvent((Event)eve);
                            if (eve.isCancelled() || eve.isFailed()) {
                                return;
                            }
                            inv.setItem(this.srcSlot, null);
                            inv.setItem(this.itemSlot, result);
                            p.getInventory().addItem(resultItems.toArray(new ItemStack[0])).values().forEach(itm -> p.getWorld().dropItemNaturally(p.getLocation().add(0.0, 0.5, 0.0), itm));
                            if (this.extractorManager.isItemOfThisModule(src)) {
                                this.extractorManager.takeItemCharge(src);
                                if (this.extractorManager.getItemCharges(src) == 0) {
                                    p.closeInventory();
                                    return;
                                }
                            }
                            inv.setItem(this.itemSlot, null);
                            this.open(p, result, src, type);
                        }
                    };
                    JIcon ico = new JIcon(item);
                    ico.setClick(itemClick);
                    int slot = this.socketSlots[indexMain++];
                    this.addButton(player, ico, new int[]{slot});
                }
            }
        }
        for (GuiItem guiItem : this.getContent().values()) {
            Enum type22 = guiItem.getType();
            if (type22 == null || type22 != type) continue;
            ItemStack itemGlow = guiItem.getItem();
            itemGlow.addUnsafeEnchantment(NamespaceResolver.getEnchantment((String[])new String[]{"POWER", "ARROW_DAMAGE"}), 1);
            DataUT.setData((ItemStack)itemGlow, (NamespacedKey)META_KEY_SOCKET_SELECT, (Object)"true");
            JIcon active = new JIcon(itemGlow);
            active.setClick(guiItem.getClick());
            for (int slot : guiItem.getSlots()) {
                this.addButton(player, active, new int[]{slot});
            }
        }
        super.open(player, 1);
    }

    @Nullable
    private SocketAttribute.Type getSelectedType(@NotNull Inventory inv) {
        for (GuiItem gi : this.getContent().values()) {
            Enum type2 = gi.getType();
            if (type2 == null || !type2.getClass().equals(SocketAttribute.Type.class)) continue;
            for (int slot : gi.getSlots()) {
                ItemStack item = inv.getItem(slot);
                if (item == null) continue;
                String data = DataUT.getStringData((ItemStack)item, (NamespacedKey)META_KEY_SOCKET_SELECT);
                if (data == null) {
                    data = DataUT.getStringData((ItemStack)item, (NamespacedKey)META_KEY_SOCKET_SELECT2);
                }
                if (data == null || !data.equalsIgnoreCase("true")) continue;
                return (SocketAttribute.Type)type2;
            }
        }
        return null;
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
    }

    protected void onReady(@NotNull Player player, @NotNull Inventory inv, int page) {
        super.onReady(player, inv, page);
    }

    private void replaceCostHave(@NotNull Player p, @NotNull ItemStack item, @NotNull SocketAttribute socketAtt, double price) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        VaultHK vh = ((Divinity)this.plugin).getVault();
        ArrayList<String> lore = new ArrayList<String>();
        String cost = NumberUT.format((double)price);
        String have = "0";
        if (vh != null && vh.getEconomy() != null) {
            have = NumberUT.format((double)vh.getBalance((OfflinePlayer)p));
        }
        if (meta.hasDisplayName()) {
            String n = meta.getDisplayName();
            meta.setDisplayName(this.socketName.replace("%socket%", socketAtt.getName()).replace("%name%", n).replace("%cost%", cost).replace("%have%", have));
        }
        for (String s : this.socketLore) {
            lore.add(s.replace("%socket%", socketAtt.getName()).replace("%cost%", cost).replace("%have%", have));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public void click(@NotNull Player player, @Nullable ItemStack item, int slot, InventoryClickEvent e) {
        Inventory inv = e.getInventory();
        ItemStack target = this.getItem(inv, this.itemSlot);
        ItemStack source = this.getItem(inv, this.srcSlot);
        if (slot >= inv.getSize() && target.getType() == Material.AIR && item != null) {
            if (this.extractorManager.openExtraction(player, item, source, this.getSelectedType(inv), true)) {
                player.getInventory().removeItem(new ItemStack[]{source});
            }
            return;
        }
        if (slot == this.itemSlot && target.getType() != Material.AIR) {
            inv.setItem(this.srcSlot, null);
            this.open(player, null, source, this.getSelectedType(inv));
            return;
        }
        super.click(player, item, slot, e);
    }

    public void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
        Inventory inv = e.getInventory();
        ItemStack item = inv.getItem(this.itemSlot);
        ItemStack src = inv.getItem(this.srcSlot);
        if (item != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{item});
        }
        if (src != null && this.extractorManager.isItemOfThisModule(src)) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{src});
        }
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    protected boolean ignoreNullClick() {
        return true;
    }
}

