/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.dismantle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.ILangMsg;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.PlayerUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.dismantle.DismantleGUI;
import studio.magemonkey.divinity.modules.list.dismantle.DismantleTrait;
import studio.magemonkey.divinity.modules.list.dismantle.command.DismantleOpenCmd;
import studio.magemonkey.divinity.modules.list.dismantle.event.PlayerDismantleItemEvent;
import studio.magemonkey.divinity.modules.list.dismantle.event.PlayerPreDismantleItemEvent;
import studio.magemonkey.divinity.stats.items.ItemStats;

public class DismantleManager
extends QModuleDrop<DismantleItem> {
    private Map<String, Set<DismantleTable>> moduleTables;
    private ActionManipulator actionsComplete;
    ActionManipulator actionsError;
    private DismantleGUI gui;

    public DismantleManager(@NotNull Divinity plugin) {
        super(plugin, DismantleItem.class);
    }

    @NotNull
    public String getId() {
        return "dismantle";
    }

    @NotNull
    public String version() {
        return "1.8.0";
    }

    public void setup() {
        this.moduleTables = new HashMap<String, Set<DismantleTable>>();
        ((Divinity)this.plugin).getConfigManager().extract(this.getPath() + "source");
        for (JYML cfg : JYML.loadAll((String)(this.getFullPath() + "source"), (boolean)true)) {
            try {
                DismantleTable table = new DismantleTable(cfg);
                Set<DismantleTable> tables = this.moduleTables.get(table.getModule());
                if (tables == null) {
                    tables = new HashSet<DismantleTable>();
                }
                tables.add(table);
                this.moduleTables.put(table.getModule(), tables);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        this.actionsComplete = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "general.actions-complete");
        this.actionsError = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "general.actions-error");
        this.gui = new DismantleGUI(this);
        this.moduleCommand.addSubCommand((ISubCommand)new DismantleOpenCmd(this));
        CitizensHK citizens = ((Divinity)this.plugin).getCitizens();
        if (citizens != null) {
            TraitInfo trait = TraitInfo.create(DismantleTrait.class).withName("dismantle");
            citizens.registerTrait((CodexPlugin)this.plugin, trait);
        }
    }

    public void shutdown() {
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.moduleTables != null) {
            this.moduleTables.clear();
            this.moduleTables = null;
        }
        this.actionsComplete = null;
        this.actionsError = null;
    }

    public void openDismantleGUI(@NotNull Player player, boolean isForce) {
        if (!isForce && !player.hasPermission("quantumrpg.dismantle.gui")) {
            ((Divinity)this.plugin).lang().Error_NoPerm.send((CommandSender)player);
            return;
        }
        this.gui.open(player, 1);
    }

    @Nullable
    public OutputContainer getResult(@NotNull ItemStack item) {
        QModuleDrop<?> mod = ItemStats.getModule(item);
        if (mod == null) {
            return null;
        }
        String itemId = ItemStats.getId(item);
        if (itemId == null) {
            return null;
        }
        int itemLvl = ItemStats.getLevel(item);
        for (DismantleTable table : this.moduleTables.getOrDefault(mod.getId(), Collections.emptySet())) {
            OutputContainer result = table.getResult(itemId, itemLvl);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isDismantleable(@NotNull ItemStack item) {
        return this.getResult(item) != null;
    }

    public boolean dismantle(@NotNull Player player, @NotNull ItemStack item) {
        OutputContainer result = this.getResult(item);
        if (result == null) {
            return false;
        }
        for (OutputItem src : result.getItems()) {
            src.give(player);
        }
        return true;
    }

    @Override
    protected boolean onDragDrop(@NotNull Player player, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull DismantleItem rItem, @NotNull InventoryClickEvent e) {
        OutputContainer out = this.getResult(target);
        if (out == null) {
            return false;
        }
        HashMap<ItemStack, OutputContainer> result = new HashMap<ItemStack, OutputContainer>();
        result.put(target, out);
        PlayerPreDismantleItemEvent event = new PlayerPreDismantleItemEvent(player, 0.0, result);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)event);
        double cost = event.getCost();
        if (!this.payForDismantle(player, cost)) {
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            this.actionsError.process((Entity)player);
            return false;
        }
        this.takeChargeClickEvent(player, src, e);
        ItemStack targetLeft = null;
        if (target.getAmount() > 1) {
            targetLeft = new ItemStack(target);
            targetLeft.setAmount(target.getAmount() - 1);
            target.setAmount(1);
        }
        e.setCurrentItem(null);
        if (targetLeft != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{targetLeft});
        }
        for (OutputItem oItem : out.getItems()) {
            oItem.give(player);
        }
        PlayerDismantleItemEvent event2 = new PlayerDismantleItemEvent(player, cost, result);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)event2);
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDismantleMain(PlayerDismantleItemEvent e) {
        Player p = e.getPlayer();
        Map<ItemStack, OutputContainer> result = e.getResult();
        double cost = e.getCost();
        boolean isFree = cost <= 0.0;
        ILangMsg msg = null;
        if (result.size() == 1) {
            for (ItemStack item : result.keySet()) {
                if (isFree) {
                    msg = ((Divinity)this.plugin).lang().Dismantle_Dismantle_Single_Free.replace("%item%", (Object)ItemUT.getItemName((ItemStack)item));
                    continue;
                }
                msg = ((Divinity)this.plugin).lang().Dismantle_Dismantle_Single_Paid.replace("%item%", (Object)ItemUT.getItemName((ItemStack)item));
            }
        } else {
            msg = isFree ? ((Divinity)this.plugin).lang().Dismantle_Dismantle_Many_Free : ((Divinity)this.plugin).lang().Dismantle_Dismantle_Many_Paid;
        }
        if (msg != null) {
            msg.replace("%cost%", (Object)NumberUT.format((double)cost)).send((CommandSender)p);
        }
        this.actionsComplete.process((Entity)p);
    }

    final boolean payForDismantle(@NotNull Player player, double cost) {
        VaultHK vault;
        if (cost > 0.0 && (vault = ((Divinity)this.plugin).getVault()) != null && vault.getEconomy() != null) {
            double balance = vault.getBalance((OfflinePlayer)player);
            if (balance < cost) {
                ((Divinity)this.plugin).lang().Dismantle_Dismantle_Error_TooExpensive.replace("%cost%", (Object)NumberUT.format((double)cost)).replace("%balance%", (Object)NumberUT.format((double)balance)).send((CommandSender)player);
                return false;
            }
            vault.take((OfflinePlayer)player, cost);
        }
        return true;
    }

    public class DismantleItem
    extends LimitedItem {
        public DismantleItem(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, DismantleManager.this);
        }
    }

    public class DismantleTable {
        private String module;
        private Map<String, TreeMap<Integer, OutputContainer>> items;

        public DismantleTable(JYML cfg) {
            this.module = cfg.getString("input-module");
            IModule mod = ((Divinity)DismantleManager.this.plugin).getModuleManager().getModule(this.module);
            if (mod == null || !mod.isLoaded() || !(mod instanceof QModuleDrop)) {
                throw new IllegalArgumentException("Module " + this.module + " is invalid or not loaded.");
            }
            this.items = new HashMap<String, TreeMap<Integer, OutputContainer>>();
            for (String mItemId : cfg.getSection("output-by-item-id-level")) {
                TreeMap<Integer, OutputContainer> mapLvlContainer = new TreeMap<Integer, OutputContainer>();
                for (String sItemLvl : cfg.getSection("output-by-item-id-level." + mItemId)) {
                    int mItemLvl = StringUT.getInteger((String)sItemLvl, (int)-1);
                    if (mItemLvl < 1) continue;
                    String path = "output-by-item-id-level." + mItemId + "." + sItemLvl + ".";
                    double oCost = cfg.getDouble(path + "cost");
                    ArrayList<OutputItem> oItems = new ArrayList<OutputItem>();
                    for (String oItemId : cfg.getSection(path + "output")) {
                        String path2 = path + "output." + oItemId + ".";
                        double chance = cfg.getDouble(path2 + "chance");
                        if (chance <= 0.0) continue;
                        ItemStack preview = cfg.getItem(path2 + "preview");
                        ItemStack item = cfg.getItem(path2 + "item");
                        List cmds = cfg.getStringList(path2 + "commands");
                        OutputItem si = new OutputItem(oItemId, chance, preview, item, cmds);
                        oItems.add(si);
                    }
                    if (oItems.isEmpty()) continue;
                    OutputContainer container = new OutputContainer(oCost, oItems);
                    mapLvlContainer.put(mItemLvl, container);
                }
                if (mapLvlContainer.isEmpty()) continue;
                this.items.put(mItemId.toLowerCase(), mapLvlContainer);
            }
        }

        @NotNull
        public String getModule() {
            return this.module;
        }

        @Nullable
        public OutputContainer getResult(@NotNull String itemId, int itemLvl) {
            TreeMap<Integer, OutputContainer> mapContainer = this.items.get(itemId);
            if (mapContainer == null) {
                mapContainer = this.items.get("default");
            }
            if (mapContainer == null) {
                return null;
            }
            Map.Entry<Integer, OutputContainer> e = mapContainer.floorEntry(itemLvl);
            if (e == null) {
                return null;
            }
            return e.getValue();
        }
    }

    public class OutputContainer {
        private double cost;
        private List<OutputItem> items;

        public OutputContainer(@NotNull double cost, List<OutputItem> items) {
            this.cost = cost;
            this.items = items;
        }

        public double getCost() {
            return this.cost;
        }

        @NotNull
        public List<OutputItem> getItems() {
            return this.items;
        }
    }

    public class OutputItem {
        private String id;
        private double chance;
        private ItemStack preview;
        private ItemStack item;
        private List<String> cmds;

        public OutputItem(String id, @Nullable double chance, @Nullable ItemStack preview, @NotNull ItemStack item, List<String> cmds) {
            this.id = id.toLowerCase();
            this.chance = chance;
            this.item = item;
            this.cmds = cmds;
            this.preview = preview;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        public double getChance() {
            return this.chance;
        }

        public void setChance(double chance) {
            this.chance = chance;
        }

        @Nullable
        public ItemStack getPreview() {
            return this.preview;
        }

        @Nullable
        public ItemStack getItem() {
            return this.item;
        }

        @NotNull
        public List<String> getCommands() {
            return this.cmds;
        }

        public void give(@NotNull Player player) {
            if ((double)Rnd.get((boolean)true) >= this.getChance()) {
                return;
            }
            if (this.item != null) {
                ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{this.item});
            }
            for (String cmd : this.cmds) {
                PlayerUT.execCmd((Player)player, (String)cmd);
            }
        }
    }
}

