/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.command.MCmd;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;

public class MGetCmd
extends MCmd<QModuleDrop<?>> {
    public MGetCmd(@NotNull QModuleDrop<?> module) {
        super(module, new String[]{"get"}, "quantumrpg.admin");
    }

    @NotNull
    public String usage() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Get_Usage.getMsg();
    }

    @NotNull
    public String description() {
        return ((Divinity)this.plugin).lang().Module_Cmd_Get_Desc.getMsg();
    }

    public boolean playersOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        ItemGeneratorManager itemGeneratorManager;
        ItemGeneratorManager.GeneratorItem generatorItem;
        if (i == 1) {
            return ((QModuleDrop)this.module).getItemIds();
        }
        if (i == 2) {
            return Arrays.asList("[level]", "-1", "1:5", "1");
        }
        if (i == 3) {
            return Arrays.asList("1", "10");
        }
        if (i == 4 && this.module instanceof ItemGeneratorManager && (generatorItem = (ItemGeneratorManager.GeneratorItem)(itemGeneratorManager = (ItemGeneratorManager)this.module).getItemById(args[1])) != null) {
            return generatorItem.getMaterialsList().stream().map(ItemType::getNamespacedID).collect(Collectors.toList());
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ItemType material;
        String id = "random";
        if (args.length >= 2) {
            id = args[1];
        }
        int amount = 1;
        int lMin = -1;
        int lMax = -1;
        if (args.length >= 3) {
            if (args[2].contains(":")) {
                String[] split = args[2].split(":");
                lMin = this.getNumI(sender, split[0], -1, true);
                lMax = this.getNumI(sender, split[1], -1, true);
            } else {
                lMin = lMax = this.getNumI(sender, args[2], -1, true);
            }
        }
        if (args.length >= 4) {
            amount = this.getNumI(sender, args[3], 1);
        }
        Player p = (Player)sender;
        ItemStack item = null;
        try {
            material = args.length >= 5 ? CodexEngine.get().getItemManager().getItemType(args[4]) : null;
        }
        catch (MissingItemException | MissingProviderException e) {
            material = null;
        }
        ItemGeneratorManager itemGenerator = this.module instanceof ItemGeneratorManager ? (ItemGeneratorManager)this.module : null;
        ItemGeneratorManager.GeneratorItem generatorItem = itemGenerator != null ? (ItemGeneratorManager.GeneratorItem)itemGenerator.getItemById(id) : null;
        HashMap<String, Integer> addedItems = new HashMap<String, Integer>();
        for (int i = 0; i < amount; ++i) {
            int iLevel = Rnd.get((int)lMin, (int)lMax);
            item = material != null && generatorItem != null ? generatorItem.create(iLevel, -1, material) : DivinityAPI.getItemByModule((QModuleDrop)this.module, id, iLevel, -1, -1);
            if (item == null) continue;
            ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{item});
            String name = ItemUT.getItemName((ItemStack)item);
            addedItems.put(name, addedItems.containsKey(name) ? (Integer)addedItems.get(name) + 1 : 1);
        }
        for (String name : addedItems.keySet()) {
            ((Divinity)this.plugin).lang().Module_Cmd_Get_Done.replace("%item%", (Object)name).replace("%amount%", (Object)String.valueOf(addedItems.get(name))).send(sender);
        }
    }
}

