/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.effects;

import org.jetbrains.annotations.NotNull;
import studio.magemonkey.divinity.manager.effects.IExpirableEffect;

public abstract class IPeriodicEffect
extends IExpirableEffect {
    private long lastTrigger;
    private double interval;

    protected IPeriodicEffect(@NotNull Builder<?> builder) {
        super((IExpirableEffect.Builder<?>)builder);
        this.interval = builder.interval;
    }

    @Override
    public void trigger(boolean force) {
        super.trigger(force);
        this.tick();
    }

    public final double getInterval() {
        return this.interval;
    }

    public final long getLastTriggerTime() {
        return this.lastTrigger;
    }

    public final boolean isReady() {
        return (double)System.currentTimeMillis() > (double)this.getLastTriggerTime() + this.getInterval() * 1000.0;
    }

    private final void tick() {
        this.lastTrigger = System.currentTimeMillis();
    }

    public static abstract class Builder<B extends Builder<B>>
    extends IExpirableEffect.Builder<B> {
        private double interval;

        public Builder(double lifeTime, double interval) {
            super(lifeTime);
            this.interval = interval;
        }

        @Override
        @NotNull
        public abstract IPeriodicEffect build();

        @Override
        @NotNull
        protected abstract B self();
    }
}

