/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.damage;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.items.PrefixHelper;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.registry.provider.DamageTypeProvider;
import studio.magemonkey.codex.util.LocUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.PartyAPI;
import studio.magemonkey.divinity.api.event.DivinityDamageEvent;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.hooks.external.mythicmobs.AbstractMythicMobsHK;
import studio.magemonkey.divinity.manager.damage.DamageMeta;
import studio.magemonkey.divinity.manager.effects.main.AdjustStatEffect;
import studio.magemonkey.divinity.manager.effects.main.DisarmEffect;
import studio.magemonkey.divinity.modules.list.party.PartyManager;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.attributes.stats.BleedStat;

public class DamageManager
extends IListener<Divinity>
implements DamageTypeProvider {
    private AbstractMythicMobsHK mmHook;

    public DamageManager(Divinity plugin) {
        super((JavaPlugin)plugin);
    }

    @Nullable
    public static LivingEntity getTargetByDirection(@NotNull Entity damager) {
        return DamageManager.getTargetByDirection(damager, EngineCfg.COMBAT_MAX_GET_TARGET_DISTANCE);
    }

    @Nullable
    public static LivingEntity getTargetByDirection(@NotNull Entity damager, double range) {
        Location start = damager.getLocation();
        if (damager instanceof LivingEntity) {
            start = ((LivingEntity)damager).getEyeLocation();
        }
        Vector increase = start.getDirection();
        return DamageManager.getTargetByDirection(damager, start, increase, range);
    }

    @Nullable
    public static LivingEntity getTargetByDirection(@NotNull Entity damager, @NotNull Location from, @NotNull Location to) {
        return DamageManager.getTargetByDirection(damager, from, to, EngineCfg.COMBAT_MAX_GET_TARGET_DISTANCE);
    }

    @Nullable
    public static LivingEntity getTargetByDirection(@NotNull Entity damager, @NotNull Location from, @NotNull Location to, double range) {
        Vector increase = LocUT.getDirectionTo((Location)from, (Location)to);
        return DamageManager.getTargetByDirection(damager, from, increase, range);
    }

    @Nullable
    public static LivingEntity getTargetByDirection(@NotNull Entity damager, @NotNull Location from, @NotNull Vector dir, double range) {
        Location point;
        Material wall;
        LivingEntity target = null;
        Vector increase = dir;
        PartyManager.Party party = null;
        if (damager.getType() == EntityType.PLAYER) {
            party = PartyAPI.getPlayerParty((Player)damager);
        }
        int counter = 0;
        while ((double)counter < range && (wall = (point = from.add(increase)).getBlock().getType()) == Material.AIR && !wall.isSolid()) {
            for (Entity entity : point.getChunk().getEntities()) {
                LivingEntity entity2;
                if (!Hooks.canFights((Entity)damager, (Entity)entity) || (entity2 = (LivingEntity)entity).isDead() || !entity2.isValid() || entity2.getEyeLocation().distance(point) > 1.5 || party != null && entity2 instanceof Player && party.isMember((Player)entity2)) continue;
                return entity2;
            }
            ++counter;
        }
        return target;
    }

    @NotNull
    public static Set<LivingEntity> getTargetsByRange(@NotNull Entity damager, double range) {
        return DamageManager.getTargetsByRange(damager, damager.getLocation(), range);
    }

    @NotNull
    public static Set<LivingEntity> getTargetsByRange(@NotNull Entity damager, @NotNull Location from, double range) {
        HashSet<LivingEntity> set = new HashSet<LivingEntity>();
        PartyManager.Party party = null;
        if (damager.getType() == EntityType.PLAYER) {
            party = PartyAPI.getPlayerParty((Player)damager);
        }
        ProjectileSource shooter = null;
        if (damager instanceof Projectile) {
            shooter = ((Projectile)damager).getShooter();
        }
        for (Entity entity : damager.getWorld().getNearbyEntities(from, range, range, range)) {
            LivingEntity target;
            if (!Hooks.canFights((Entity)damager, (Entity)entity) || (target = (LivingEntity)entity).isDead() || !target.isValid() || party != null && target instanceof Player && party.isMember((Player)target) || shooter != null && target.equals((Object)shooter)) continue;
            set.add(target);
        }
        return set;
    }

    public void setup() {
        this.mmHook = (AbstractMythicMobsHK)((Divinity)this.plugin).getHook(AbstractMythicMobsHK.class);
        this.registerListeners();
    }

    public void shutdown() {
        this.unregisterListeners();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDamageFishHook(PlayerFishEvent e) {
        if (!EngineCfg.COMBAT_FISHING_HOOK_DO_DAMAGE) {
            return;
        }
        Entity caught = e.getCaught();
        if (!(caught instanceof LivingEntity)) {
            return;
        }
        Player player = e.getPlayer();
        LivingEntity target = (LivingEntity)caught;
        target.damage(1.0, (Entity)player);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageRPGStart(@NotNull DivinityDamageEvent.Start e) {
        List metadata;
        LivingEntity victim = e.getVictim();
        LivingEntity damager = e.getDamager();
        Projectile projectile = e.getProjectile();
        DamageMeta meta = e.getDamageMeta();
        EntityDamageEvent orig = e.getOriginalEvent();
        EntityStats statsDamager = e.getDamagerStats();
        EntityStats statsVictim = e.getVictimStats();
        if (damager != null && statsDamager != null && !this.handleDamageModifiers(e, victim, damager, statsVictim, statsDamager, projectile, orig, meta)) {
            return;
        }
        DivinityDamageEvent.Pre eventPre = new DivinityDamageEvent.Pre(victim, damager, projectile, orig, meta);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)eventPre);
        if (eventPre.isCancelled()) {
            return;
        }
        String mythicFaction = "";
        if (this.mmHook != null && this.mmHook.isMythicMob((Entity)victim)) {
            mythicFaction = this.mmHook.getMythicInstance((Entity)victim).getFaction();
        }
        List list = metadata = damager != null && !e.isExempt() ? damager.getMetadata("custom-cooldown") : Collections.emptyList();
        double powerMod = metadata == null || metadata.isEmpty() ? (statsDamager != null ? statsDamager.getAttackPowerModifier() : 1.0) : (double)((MetadataValue)metadata.get(0)).asInt();
        FabledHook skillApi = (FabledHook)Divinity.getInstance().getHook("Fabled");
        if (skillApi != null && skillApi.isSkillDamage() && damager != null && !skillApi.ignoreDivinity(damager)) {
            powerMod = 1.0;
        }
        double directMod = meta.getDirectModifier();
        double critMod = meta.getCriticalModifier();
        double blockMod = meta.getBlockModifier();
        double penetrateMod = meta.getPenetrateModifier();
        double pveDamageMod = meta.getPvEDamageModifier();
        double pveDefenseMod = meta.getPvEDefenseModifier();
        double enchantFactorMod = this.getEnchantModifier(victim, e.getCause());
        double toughness = e.getVictimStats().getItemStat(TypedStat.Type.ARMOR_TOUGHNESS, false);
        meta.setEnchantProtectionModifier(enchantFactorMod);
        Map<DefenseAttribute, Double> defenses = e.getDefenseMap();
        for (Map.Entry<DamageAttribute, Double> en : e.getDamageMap().entrySet()) {
            DamageAttribute dmgAtt = en.getKey();
            double dmgType = en.getValue();
            dmgType *= pveDamageMod;
            dmgType *= critMod;
            if (dmgAtt != null) {
                dmgType *= dmgAtt.getDamageModifierByEntityType((Entity)victim);
                dmgType *= dmgAtt.getDamageModifierByMythicFaction(mythicFaction);
            }
            dmgType *= enchantFactorMod;
            if (!e.isExempt()) {
                dmgType *= powerMod;
            }
            dmgType *= blockMod;
            double directType = dmgType * directMod;
            if ((dmgType = Math.max(0.0, dmgType - directType)) > 0.0) {
                DefenseAttribute defAtt;
                DefenseAttribute defenseAttribute = defAtt = dmgAtt != null ? dmgAtt.getAttachedDefense() : null;
                if (defAtt != null && defenses.containsKey(defAtt)) {
                    double def = Math.max(0.0, defenses.get(defAtt) * pveDefenseMod * penetrateMod);
                    double defCalced = EngineCfg.LEGACY_COMBAT ? Math.max(0.0, dmgType * (1.0 - def * defAtt.getProtectionFactor() * 0.01)) : Math.max(0.0, dmgType * (1.0 - Math.max(def / 5.0, def - 4.0 * dmgType / Math.max(1.0, toughness + 8.0)) * defAtt.getProtectionFactor() * 0.05));
                    meta.setDefendedDamage(defAtt, dmgType - defCalced);
                    dmgType = defCalced;
                }
            }
            meta.setDamage(dmgAtt, dmgType + directType);
            if (damager == null || dmgAtt == null) continue;
            dmgAtt.getHitActions().process((Entity)damager);
        }
        double modifiedDamage = meta.getTotalDamage();
        double invulnerableProt = 0.0;
        try {
            invulnerableProt = e.getOriginalEvent().getDamage(EntityDamageEvent.DamageModifier.valueOf((String)"INVULNERABILITY_REDUCTION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (modifiedDamage + invulnerableProt < 0.001) {
            e.setCancelled(true);
            e.getOriginalEvent().setCancelled(true);
            return;
        }
        meta.setInvulnerableProtection(invulnerableProt);
        double dmgTotal = meta.getTotalDamage();
        orig.setDamage(EntityDamageEvent.DamageModifier.BASE, dmgTotal);
        if (e.isExempt()) {
            return;
        }
        if (damager != null && statsDamager != null && dmgTotal > 0.0 && !this.handleDamagePostEffects(e, victim, damager, statsVictim, statsDamager, projectile, orig, meta)) {
            return;
        }
        DivinityDamageEvent.Exit eventExit = new DivinityDamageEvent.Exit(victim, damager, projectile, orig, meta);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)eventExit);
        if (eventExit.isCancelled()) {
            return;
        }
        if (damager != null && this.mmHook != null) {
            this.mmHook.setSkillDamage((Entity)damager, dmgTotal);
        }
    }

    private boolean handleDamageModifiers(@NotNull DivinityDamageEvent event, @NotNull LivingEntity victim, @NotNull LivingEntity damager, @NotNull EntityStats statsVictim, @NotNull EntityStats statsDamager, @Nullable Projectile projectile, @NotNull EntityDamageEvent e, @NotNull DamageMeta meta) {
        double dodgeRate = statsVictim.getItemStat(TypedStat.Type.DODGE_RATE, false);
        if (dodgeRate > 0.0) {
            double accurRate = event.getDamagerItemStat(TypedStat.Type.ACCURACY_RATE);
            if ((double)Rnd.get((boolean)true) < dodgeRate && (double)Rnd.get((boolean)true) >= accurRate) {
                DivinityDamageEvent.Dodge qDodge = new DivinityDamageEvent.Dodge(victim, damager, projectile, e, meta);
                ((Divinity)this.plugin).getPluginManager().callEvent((Event)qDodge);
                if (!qDodge.isCancelled()) {
                    e.setDamage(0.0);
                    e.setCancelled(true);
                    meta.setDodge(true);
                    return false;
                }
            }
        }
        double critModifier = 1.0;
        double critRate = event.getDamagerItemStat(TypedStat.Type.CRITICAL_RATE);
        if (critRate > 0.0 && (double)Rnd.get((boolean)true) < critRate && (critModifier = event.getDamagerItemStat(TypedStat.Type.CRITICAL_DAMAGE)) == 0.0) {
            critModifier = 1.0;
        }
        meta.setCriticalModifier(critModifier);
        TypedStat.Type pvpDefenseType = TypedStat.Type.PVE_DEFENSE;
        TypedStat.Type pvpDamageType = TypedStat.Type.PVE_DAMAGE;
        if (statsVictim.isPlayer() && statsDamager.isPlayer()) {
            pvpDefenseType = TypedStat.Type.PVP_DEFENSE;
            pvpDamageType = TypedStat.Type.PVP_DAMAGE;
        }
        double directPercent = 0.0;
        double penetration = 1.0 - event.getDamagerItemStat(TypedStat.Type.PENETRATION) / 100.0;
        double pvpDefense = 1.0 + statsVictim.getItemStat(pvpDefenseType, false) / 100.0;
        double pvpDamage = 1.0 + event.getDamagerItemStat(pvpDamageType) / 100.0;
        meta.setPvEDamageModifier(pvpDamage);
        meta.setPvEDefenseModifier(pvpDefense);
        meta.setDirectModifier(directPercent);
        meta.setPenetrateModifier(penetration);
        double blockModifier = statsVictim.getItemStat(TypedStat.Type.BLOCK_DAMAGE, false);
        double blockRate = statsVictim.getItemStat(TypedStat.Type.BLOCK_RATE, false);
        Player player = statsVictim.getPlayer();
        boolean isVanillaBlocked = false;
        if (player != null && player.isBlocking() && player.getCooldown(Material.SHIELD) <= 0) {
            if (e.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                isVanillaBlocked = true;
                blockRate += EngineCfg.COMBAT_SHIELD_BLOCK_BONUS_RATE;
                blockModifier += EngineCfg.COMBAT_SHIELD_BLOCK_BONUS_DAMAGE_MOD;
            }
            if (blockRate > 0.0) {
                double vanillaBlockModifier = 1.0;
                if ((double)Rnd.get((boolean)true) < blockRate) {
                    vanillaBlockModifier = 0.0;
                    meta.setBlockModifier(1.0 - blockModifier / 100.0);
                    if (isVanillaBlocked && player != null) {
                        this.applyShieldDamage(player);
                    }
                }
                if (e.isApplicable(EntityDamageEvent.DamageModifier.BLOCKING)) {
                    e.setDamage(EntityDamageEvent.DamageModifier.BLOCKING, vanillaBlockModifier);
                }
            }
        }
        return true;
    }

    private void applyShieldDamage(Player player) {
        ItemStack shield;
        if (!player.isBlocking()) {
            return;
        }
        player.setCooldown(Material.SHIELD, 20 * EngineCfg.COMBAT_SHIELD_BLOCK_COOLDOWN);
        ItemStack offHand = player.getInventory().getItemInOffHand();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        Object object = offHand.getType() == Material.SHIELD ? offHand : (shield = mainHand.getType() == Material.SHIELD ? mainHand : null);
        if (shield == null) {
            return;
        }
        ItemMeta shieldMeta = shield.getItemMeta();
        int level = shieldMeta.getEnchantLevel(NamespaceResolver.getEnchantment((String[])new String[]{"UNBREAKING", "DURABILITY"}));
        if ((double)Rnd.get((boolean)true) <= 100.0 / (double)(level + 1)) {
            if (shieldMeta instanceof Damageable) {
                ((Damageable)shieldMeta).setDamage(((Damageable)shieldMeta).getDamage() + 1);
                shield.setItemMeta(shieldMeta);
            } else {
                shield.setDurability((short)(shield.getDurability() - 1));
            }
        }
    }

    private boolean handleDamagePostEffects(@NotNull DivinityDamageEvent event, @NotNull LivingEntity victim, @NotNull LivingEntity damager, @NotNull EntityStats statsVictim, @NotNull EntityStats statsDamager, @Nullable Projectile projectile, @NotNull EntityDamageEvent e, @NotNull DamageMeta meta) {
        double thorn;
        double vamp;
        BleedStat bleedStat;
        double bleed;
        double burn;
        double aoe = event.getDamagerItemStat(TypedStat.Type.AOE_DAMAGE);
        if (aoe > 0.0 && e.getCause() != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            if (statsVictim.isIgnoreAOE()) {
                statsVictim.setIgnoreAOE(false);
            } else {
                ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    Set<LivingEntity> targets = DamageManager.getTargetsByRange((Entity)damager, 2.0);
                    targets.remove(victim);
                    targets.remove(damager);
                    DoubleUnaryOperator operator = dmg -> dmg * (aoe / 100.0);
                    for (LivingEntity targetAoe : targets) {
                        AdjustStatEffect aoeReducer = ((AdjustStatEffect.Builder)new AdjustStatEffect.Builder(-1.0).withCharges(1)).withAdjust(ItemStats.getDamages(), operator).build();
                        aoeReducer.applyTo(damager);
                        EntityStats.get(targetAoe).setIgnoreAOE(true);
                        targetAoe.damage(1.0, (Entity)damager);
                    }
                });
            }
        }
        double dmgTotal = meta.getTotalDamage();
        double disarm = event.getDamagerItemStat(TypedStat.Type.DISARM_RATE);
        if (disarm > 0.0 && (double)Rnd.get((boolean)true) < disarm) {
            DisarmEffect disarmEffect = new DisarmEffect();
            disarmEffect.applyTo(victim);
        }
        if ((burn = event.getDamagerItemStat(TypedStat.Type.BURN_RATE)) > 0.0 && (double)Rnd.get((boolean)true) < burn) {
            victim.setFireTicks(100);
        }
        if ((bleed = event.getDamagerItemStat(TypedStat.Type.BLEED_RATE)) > 0.0 && (double)Rnd.get((boolean)true) < bleed && (bleedStat = ItemStats.getStat(BleedStat.class)) != null) {
            bleedStat.bleed(victim, dmgTotal);
        }
        if ((vamp = Math.max(0.0, dmgTotal * (event.getDamagerItemStat(TypedStat.Type.VAMPIRISM) / 100.0))) > 0.0) {
            EntityRegainHealthEvent eventRegain = new EntityRegainHealthEvent((Entity)damager, vamp, EntityRegainHealthEvent.RegainReason.CUSTOM);
            ((Divinity)this.plugin).getPluginManager().callEvent((Event)eventRegain);
            if (!eventRegain.isCancelled()) {
                double max = EntityStats.getEntityMaxHealth(damager);
                damager.setHealth(Math.min(max, damager.getHealth() + vamp));
            }
        }
        if ((thorn = statsVictim.getItemStat(TypedStat.Type.THORNMAIL, false) / 100.0) > 0.0) {
            damager.damage(dmgTotal * thorn);
        }
        return true;
    }

    private double getEnchantModifier(@NotNull LivingEntity zertva, @NotNull EntityDamageEvent.DamageCause cause) {
        EntityStats stats = EntityStats.get(zertva);
        double epfAll = stats.getEnchantProtectFactor(NamespaceResolver.getEnchantment((String[])new String[]{"PROTECTION", "PROTECTION_ENVIRONMENTAL"}));
        double epfSpec = 0.0;
        double epfMod = 1.0;
        if (cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA) {
            epfSpec = stats.getEnchantProtectFactor(NamespaceResolver.getEnchantment((String[])new String[]{"FIRE_PROTECTION", "PROTECTION_FIRE"}));
        } else if (cause == EntityDamageEvent.DamageCause.FALL) {
            epfSpec = stats.getEnchantProtectFactor(NamespaceResolver.getEnchantment((String[])new String[]{"FEATHER_FALLING", "PROTECTION_FALL"}));
        } else if (cause == EntityDamageEvent.DamageCause.PROJECTILE) {
            epfSpec = stats.getEnchantProtectFactor(NamespaceResolver.getEnchantment((String[])new String[]{"PROJECTILE_PROTECTION", "PROTECTION_PROJECTILE"}));
        } else if (cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            epfSpec = stats.getEnchantProtectFactor(NamespaceResolver.getEnchantment((String[])new String[]{"BLAST_PROTECTION", "PROTECTION_EXPLOSION"}));
        }
        epfMod = Math.min(20.0, epfSpec + epfAll);
        return 1.0 - epfMod / 25.0;
    }

    public String pluginName() {
        return Divinity.getInstance().getName();
    }

    public String getNamespace() {
        return Divinity.getInstance().getName().toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dealDamage(final @NotNull LivingEntity entity, final double amount, String damageType, @Nullable LivingEntity damager) {
        final DamageAttribute damageAttribute = ItemStats.getDamageById(PrefixHelper.stripPrefix((String)this.getNamespace(), (String)damageType));
        if (damageAttribute == null) {
            return false;
        }
        final boolean[] success = new boolean[]{false};
        Listener listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void onDamage(DivinityDamageEvent.BeforeScale event) {
                if (event.getOriginalEvent().getEntity() != entity) {
                    return;
                }
                Map<DamageAttribute, Double> damageMap = event.getDamageMap();
                damageMap.clear();
                damageMap.put(damageAttribute, amount);
                event.getDefenseMap().putIfAbsent(damageAttribute.getAttachedDefense(), 0.0);
                success[0] = true;
            }
        };
        try {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)Divinity.getInstance());
            entity.damage(amount, (Entity)damager);
        }
        finally {
            HandlerList.unregisterAll((Listener)listener);
        }
        return success[0];
    }
}

