/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.data.api.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashSet;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.data.api.UserEntityNamesMode;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.manager.effects.buffs.SavedBuff;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;

public class UserProfileSerializer
implements JsonSerializer<UserProfile>,
JsonDeserializer<UserProfile> {
    public JsonElement serialize(UserProfile src, Type type, JsonSerializationContext contex) {
        JsonObject o = new JsonObject();
        o.addProperty("name", src.getIdName());
        o.addProperty("isDefault", Boolean.valueOf(src.isDefault()));
        o.add("buffDamage", contex.serialize(src.getDamageBuffs()));
        o.add("buffDefense", contex.serialize(src.getDefenseBuffs()));
        o.add("buffStats", contex.serialize(src.getItemStatBuffs()));
        o.addProperty("namesMode", src.getNamesMode().name());
        o.addProperty("hideHelmet", Boolean.valueOf(src.isHideHelmet()));
        o.add("cData", contex.serialize((Object)src.getClassData()));
        o.addProperty("cCooldown", (Number)src.getClassSelectionCooldown());
        return o;
    }

    public UserProfile deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonElement eNames;
        JsonObject j = json.getAsJsonObject();
        String id = j.get("name").getAsString();
        boolean isDefault = j.get("isDefault").getAsBoolean();
        HashSet<SavedBuff> buffDamage = new HashSet<SavedBuff>();
        JsonElement jBuffsElem = j.get("buffDamage");
        JsonArray jBuffs = null;
        if (jBuffsElem != null) {
            jBuffs = jBuffsElem.getAsJsonArray();
            for (Object e : jBuffs) {
                buffDamage.add((SavedBuff)context.deserialize((JsonElement)e, SavedBuff.class));
            }
        }
        HashSet<SavedBuff> buffDefense = new HashSet<SavedBuff>();
        jBuffsElem = j.get("buffDefense");
        jBuffs = null;
        if (jBuffsElem != null) {
            jBuffs = jBuffsElem.getAsJsonArray();
            for (Object e : jBuffs) {
                buffDefense.add((SavedBuff)context.deserialize((JsonElement)e, SavedBuff.class));
            }
        }
        HashSet<SavedBuff> buffStats = new HashSet<SavedBuff>();
        jBuffsElem = j.get("buffStats");
        jBuffs = null;
        if (jBuffsElem != null) {
            jBuffs = jBuffsElem.getAsJsonArray();
            for (JsonElement e : jBuffs) {
                buffStats.add((SavedBuff)context.deserialize(e, SavedBuff.class));
            }
        }
        String namesModeRaw = (eNames = j.get("namesMode")) != null ? eNames.getAsString() : null;
        UserEntityNamesMode namesMode = namesModeRaw != null ? (UserEntityNamesMode)CollectionsUT.getEnum((String)namesModeRaw, UserEntityNamesMode.class) : UserEntityNamesMode.DEFAULT;
        JsonElement eHideHelmet = j.get("hideHelmet");
        boolean hideHelmet = eHideHelmet != null && eHideHelmet.getAsBoolean();
        UserClassData cData = null;
        JsonElement jData = j.get("cData");
        if (jData != null && Divinity.getInstance().cfg().isModuleEnabled("classes")) {
            RPGClass clazz;
            JsonObject jClass = jData.getAsJsonObject();
            cData = (UserClassData)context.deserialize((JsonElement)jClass, UserClassData.class);
            String clazzId = cData.getClassId();
            ClassManager classManager = DivinityAPI.getModuleManager().getClassManager();
            RPGClass rPGClass = clazz = classManager == null ? null : classManager.getClassById(clazzId);
            if (clazz == null) {
                Divinity.getInstance().getLogger().info("Player class '" + clazzId + "' no more exists.");
                cData = null;
            } else {
                cData.setPlayerClass(clazz);
            }
        }
        JsonElement jCooldown = j.get("cCooldown");
        long cCooldown = 0L;
        if (jCooldown != null) {
            cCooldown = jCooldown.getAsLong();
        }
        return new UserProfile(id, isDefault, buffDamage, buffDefense, buffStats, namesMode == null ? UserEntityNamesMode.DEFAULT : namesMode, hideHelmet, cData, cCooldown);
    }
}

