/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import lombok.Generated;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexDataPlugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.api.items.providers.ICodexItemProvider;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.migration.MigrationUtil;
import studio.magemonkey.codex.registry.DamageRegistry;
import studio.magemonkey.codex.registry.provider.DamageTypeProvider;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.params.IParam;
import studio.magemonkey.divinity.DependencyRequirement;
import studio.magemonkey.divinity.command.BuffCommand;
import studio.magemonkey.divinity.command.ModifyCommand;
import studio.magemonkey.divinity.command.SetCommand;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.config.Lang;
import studio.magemonkey.divinity.data.DivinityUserData;
import studio.magemonkey.divinity.data.UserManager;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.hooks.external.CrackShotHK;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.hooks.external.LevelledMobsHK;
import studio.magemonkey.divinity.hooks.external.LorinthsRpgMobsHK;
import studio.magemonkey.divinity.hooks.external.MagicHK;
import studio.magemonkey.divinity.hooks.external.McmmoHK;
import studio.magemonkey.divinity.hooks.external.MyPetHK;
import studio.magemonkey.divinity.hooks.external.PlaceholderAPIHK;
import studio.magemonkey.divinity.hooks.external.PwingRacesHK;
import studio.magemonkey.divinity.hooks.external.mimic.MimicHook;
import studio.magemonkey.divinity.hooks.external.mythicmobs.MythicMobsHK;
import studio.magemonkey.divinity.hooks.external.mythicmobs.MythicMobsHKv5;
import studio.magemonkey.divinity.manager.EntityManager;
import studio.magemonkey.divinity.manager.damage.DamageManager;
import studio.magemonkey.divinity.manager.interactions.InteractionManager;
import studio.magemonkey.divinity.manager.listener.ListenerManager;
import studio.magemonkey.divinity.manager.profile.ProfileManager;
import studio.magemonkey.divinity.manager.worth.WorthManager;
import studio.magemonkey.divinity.modules.ModuleCache;
import studio.magemonkey.divinity.nms.engine.PMSManager;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.utils.DivinityProvider;
import studio.magemonkey.divinity.utils.actions.conditions.CEntityLevel;
import studio.magemonkey.divinity.utils.actions.executors.ActionDamage;
import studio.magemonkey.divinity.utils.actions.executors.ActionParticleLine;
import studio.magemonkey.divinity.utils.actions.executors.ActionParticlePulse;
import studio.magemonkey.divinity.utils.actions.executors.ActionTakeMana;
import studio.magemonkey.divinity.utils.actions.params.AttackableParam;
import studio.magemonkey.divinity.utils.actions.params.PartyMemberParam;

public class Divinity
extends CodexDataPlugin<Divinity, DivinityUser> {
    public static Divinity instance;
    private Config config;
    private Lang lang;
    private EngineCfg engineCfg;
    private DivinityUserData dataHandler;
    private InteractionManager interactionManager;
    private WorthManager worthManager;
    private DamageManager dmgManager;
    private EntityManager entityManager;
    private ListenerManager listenerManager;
    private ProfileManager profileManager;
    private ModuleCache moduleCache;
    private PMSManager pms;

    public Divinity() {
        instance = this;
        MigrationUtil.renameDirectory((String)"plugins/ProRPGItems", (String)"plugins/Divinity");
    }

    public Divinity(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        instance = this;
        MigrationUtil.renameDirectory((String)"plugins/ProRPGItems", (String)"plugins/Divinity");
    }

    public void onLoad() {
        MimicHook.hook(this);
    }

    public void enable() {
        boolean useProfiles;
        this.addCustomActions();
        this.pms = new PMSManager(this);
        this.pms.setup();
        String coreVersion = CodexEngine.getEngine().getDescription().getVersion();
        boolean minCoreVersionMet = DependencyRequirement.meetsVersion("1.1.1-R0.13-SNAPSHOT", coreVersion);
        try {
            JYML profileConfig = JYML.loadOrExtract((CodexPlugin)this, (String)"/profiles/settings.yml");
            useProfiles = profileConfig.getBoolean("enabled", true);
        }
        catch (InvalidConfigurationException e) {
            this.error("Failed to load profile settings (" + this.getName() + "/profiles/settings.yml): Configuration error");
            this.error("Disabling profiles...");
            e.printStackTrace();
            useProfiles = false;
        }
        if (!minCoreVersionMet) {
            this.error("\n\n===== [ INITIALIZATION ERROR ] =====\nMissing required Codex version. " + coreVersion + " installed. 1.1.1-R0.13-SNAPSHOT required. Disabling.\n\n");
            this.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.interactionManager = new InteractionManager(this);
        this.interactionManager.setup();
        this.dmgManager = new DamageManager(this);
        this.dmgManager.setup();
        this.entityManager = new EntityManager(this);
        this.entityManager.setup();
        this.listenerManager = new ListenerManager(this);
        this.listenerManager.setup();
        if (useProfiles) {
            this.profileManager = new ProfileManager(this);
            this.profileManager.setup();
        }
        this.moduleCache = new ModuleCache(this);
        this.moduleCache.initialize();
        this.worthManager = new WorthManager(this);
        this.worthManager.setup();
        CodexEngine.getEngine().getItemManager().registerProvider("DIVINITY", (ICodexItemProvider)new DivinityProvider());
        DamageRegistry.registerProvider((DamageTypeProvider)this.dmgManager);
    }

    public void disable() {
        DamageRegistry.unregisterProvider(DamageManager.class);
        if (this.interactionManager != null) {
            this.interactionManager.shutdown();
            this.interactionManager = null;
        }
        if (this.worthManager != null) {
            this.worthManager.shutdown();
            this.worthManager = null;
        }
        this.dmgManager.shutdown();
        this.entityManager.shutdown();
        this.listenerManager.shutdown();
        this.moduleCache.shutdown();
        if (this.profileManager != null) {
            this.profileManager.shutdown();
            this.profileManager = null;
        }
        this.pms.shutdown();
        ItemStats.clear();
        ItemRequirements.clear();
        ArrayList<EntityStats> toRemove = new ArrayList<EntityStats>(EntityStats.getAll());
        toRemove.forEach(EntityStats::purge);
        DivinityUserData.destroy();
        CodexEngine.get().getItemManager().unregisterProvider(DivinityProvider.class);
    }

    public void setConfig() {
        this.config = new Config(this);
        this.config.setup();
        try {
            this.engineCfg = new EngineCfg(this);
            this.engineCfg.setup();
        }
        catch (InvalidConfigurationException e) {
            this.error("Failed to load engine config (" + this.getName() + "/engine.yml): Configuration error");
            this.error("Disabling...");
            e.printStackTrace();
            this.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.lang = new Lang(this);
        this.lang.setup();
        this.cfg().setupAttributes();
        this.cfg().save();
    }

    public void registerHooks() {
        this.registerHook("CrackShot", CrackShotHK.class);
        this.registerHook("LevelledMobs", LevelledMobsHK.class);
        this.registerHook("LorinthsRpgMobs", LorinthsRpgMobsHK.class);
        this.registerHook("Magic", MagicHK.class);
        this.registerHook("mcMMO", McmmoHK.class);
        boolean mythic4 = true;
        try {
            Class.forName("io.lumine.xikage.mythicmobs.MythicMobs");
        }
        catch (ClassNotFoundException classNotFoundException) {
            mythic4 = false;
        }
        if (mythic4) {
            this.registerHook("MythicMobs", MythicMobsHK.class);
        } else {
            this.registerHook("MythicMobs", MythicMobsHKv5.class);
        }
        this.registerHook("MyPet", MyPetHK.class);
        if (Hooks.hasPlaceholderAPI()) {
            this.registerHook("PlaceholderAPI", PlaceholderAPIHK.class);
        }
        this.registerHook("PwingRaces", PwingRacesHK.class);
        this.registerHook("Fabled", FabledHook.class);
    }

    public void registerCommands(@NotNull IGeneralCommand<Divinity> mainCommand) {
        mainCommand.addSubCommand((ISubCommand)new ModifyCommand(this));
        mainCommand.addSubCommand((ISubCommand)new SetCommand(this));
        mainCommand.addSubCommand((ISubCommand)new BuffCommand(this));
    }

    public void registerEditor() {
    }

    @NotNull
    public Config cfg() {
        return this.config;
    }

    @NotNull
    public Lang lang() {
        return this.lang;
    }

    protected boolean setupDataHandlers() {
        try {
            this.dataHandler = DivinityUserData.getInstance(this);
            this.dataHandler.setup();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
        this.userManager = new UserManager(this);
        this.userManager.setup();
        return true;
    }

    public DivinityUserData getData() {
        return this.dataHandler;
    }

    private void addCustomActions() {
        this.getActionsManager().registerParam((IParam)new PartyMemberParam());
        this.getActionsManager().registerParam((IParam)new AttackableParam());
        this.getActionsManager().registerCondition((IConditionValidator)new CEntityLevel(this));
        this.getActionsManager().registerExecutor((IActionExecutor)new ActionDamage(this));
        this.getActionsManager().registerExecutor((IActionExecutor)new ActionParticleLine(this));
        this.getActionsManager().registerExecutor((IActionExecutor)new ActionParticlePulse(this));
        this.getActionsManager().registerExecutor((IActionExecutor)new ActionTakeMana(this));
    }

    @NotNull
    public InteractionManager getInteractionManager() {
        return this.interactionManager;
    }

    @NotNull
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NotNull
    public WorthManager getWorthManager() {
        return this.worthManager;
    }

    @NotNull
    public ModuleCache getModuleCache() {
        return this.moduleCache;
    }

    @Generated
    public static Divinity getInstance() {
        return instance;
    }
}

