/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.magicdust;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.RatedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.magicdust.MagicDustTrait;
import studio.magemonkey.divinity.modules.list.magicdust.command.DustOpenCmd;
import studio.magemonkey.divinity.modules.list.magicdust.event.PlayerImproveItemSocketRateEvent;
import studio.magemonkey.divinity.stats.items.ItemStats;

public class MagicDustManager
extends QModuleDrop<MagicDust> {
    PaidGUI guiPaid;
    private ActionManipulator actionsApply;
    private ActionManipulator actionsError;

    public MagicDustManager(@NotNull Divinity plugin) {
        super(plugin, MagicDust.class);
    }

    @NotNull
    public String getId() {
        return "magic_dust";
    }

    @NotNull
    public String version() {
        return "1.9.0";
    }

    public void setup() {
        this.moduleCommand.addSubCommand((ISubCommand)new DustOpenCmd(this));
        this.actionsApply = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "general.actions-apply");
        this.actionsError = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "general.actions-error");
        this.guiPaid = new PaidGUI((Divinity)this.plugin);
        CitizensHK citizens = ((Divinity)this.plugin).getCitizens();
        if (citizens != null) {
            TraitInfo trait = TraitInfo.create(MagicDustTrait.class).withName("magicdust");
            citizens.registerTrait((CodexPlugin)this.plugin, trait);
        }
    }

    public void shutdown() {
        if (this.guiPaid != null) {
            this.guiPaid.shutdown();
            this.guiPaid = null;
        }
        this.actionsApply = null;
        this.actionsError = null;
    }

    @Override
    protected boolean onDragDrop(@NotNull Player player, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull MagicDust mDust, @NotNull InventoryClickEvent e) {
        if (!this.isRateableItem(target)) {
            return false;
        }
        int targetRate = ItemStats.getSocketRate(target);
        if (targetRate < 0) {
            return false;
        }
        if (targetRate >= mDust.getMaxRate()) {
            ((Divinity)this.plugin).lang().MagicDust_Apply_Error_MaxRate.replace("%source%", (Object)ItemUT.getItemName((ItemStack)src)).replace("%max-rate%", (Object)String.valueOf(targetRate)).send((CommandSender)player);
            this.actionsError.process((Entity)player);
            return false;
        }
        int rateAdd = mDust.getRateByLevel(ItemStats.getLevel(src));
        int rateFinal = targetRate + rateAdd;
        PlayerImproveItemSocketRateEvent event = new PlayerImproveItemSocketRateEvent(player, target, targetRate, rateFinal);
        ((Divinity)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.actionsError.process((Entity)player);
            return false;
        }
        this.takeChargeClickEvent(player, src, e);
        ItemStack lost = null;
        if (target.getAmount() > 1) {
            lost = new ItemStack(target);
            lost.setAmount(target.getAmount() - 1);
            target.setAmount(1);
        }
        e.setCurrentItem(this.changeItemRate(target, rateAdd));
        if (lost != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{lost});
        }
        return true;
    }

    @NotNull
    public ItemStack changeItemRate(@NotNull ItemStack target, int toAdd) {
        QModuleDrop<?> moduleDrop = ItemStats.getModule(target);
        if (moduleDrop == null || !moduleDrop.isLoaded()) {
            return target;
        }
        int targetRate = ItemStats.getSocketRate(target);
        if (targetRate < 0) {
            return target;
        }
        Object mItem = moduleDrop.getModuleItem(target);
        if (mItem == null || !(mItem instanceof RatedItem)) {
            return target;
        }
        RatedItem rItem = (RatedItem)mItem;
        int targetLvl = ItemStats.getLevel(target);
        int targetUses = moduleDrop.getItemCharges(target);
        int rateFinal = Math.max(0, targetRate + toAdd);
        return rItem.create(targetLvl, targetUses, rateFinal);
    }

    public boolean isRateableItem(@NotNull ItemStack target) {
        QModuleDrop<?> moduleDrop = ItemStats.getModule(target);
        if (moduleDrop == null || !moduleDrop.isLoaded()) {
            return false;
        }
        Object mItem = moduleDrop.getModuleItem(target);
        return mItem != null && mItem instanceof RatedItem;
    }

    public void openGUIPaid(@NotNull Player player, @Nullable ItemStack target, boolean force) {
        if (!force && !player.hasPermission("quantumrpg.magicdust.gui")) {
            ((Divinity)this.plugin).lang().Error_NoPerm.send((CommandSender)player);
            return;
        }
        if (target == null) {
            target = new ItemStack(Material.AIR);
        }
        if (target.getType() != Material.AIR) {
            if (!this.isRateableItem(target)) {
                ((Divinity)this.plugin).lang().MagicDust_GUI_Error_InvalidItem.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
                return;
            }
            this.splitDragItem(player, null, target);
        }
        this.guiPaid.open(player, target);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onImproveRate(PlayerImproveItemSocketRateEvent e) {
        Player player = e.getPlayer();
        ItemStack target = e.getItem();
        int rateFinal = e.getRateNew();
        this.actionsApply.process((Entity)player);
        ((Divinity)this.plugin).lang().MagicDust_Apply_Done.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).replace("%rate-new%", (Object)String.valueOf(rateFinal)).send((CommandSender)player);
    }

    public class MagicDust
    extends LimitedItem {
        private final int rateMax;
        private final TreeMap<Integer, Integer> rateLvl;

        public MagicDust(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, MagicDustManager.this);
            this.rateMax = Math.min(100, cfg.getInt("rate-increasing.max-value", 80));
            this.rateLvl = new TreeMap();
            for (String sLvl : cfg.getSection("rate-increasing.values-by-level")) {
                int lvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (lvl < 0) continue;
                int rate = cfg.getInt("rate-increasing.values-by-level." + sLvl);
                this.rateLvl.put(lvl, rate);
            }
        }

        public int getMaxRate() {
            return this.rateMax;
        }

        public int getRateByLevel(int lvl) {
            Map.Entry<Integer, Integer> e = this.rateLvl.floorEntry(lvl);
            if (e == null) {
                return 0;
            }
            return e.getValue();
        }

        @Override
        @NotNull
        protected ItemStack build(int lvl, int uses) {
            ItemStack item = super.build(lvl, uses);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            List lore = meta.getLore();
            if (lore == null) {
                return item;
            }
            int rate = this.getRateByLevel(lvl);
            lore.replaceAll(str -> str.replace("%rate-max%", String.valueOf(this.getMaxRate())).replace("%rate-amount%", String.valueOf(rate)));
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }
    }

    class PaidGUI
    extends NGUI<Divinity> {
        private final int itemSlot;
        private final VaultHK vault;
        private final boolean hasVault;
        private final Set<GuiItem> buttons;

        public PaidGUI(final Divinity plugin) {
            super((CodexPlugin)plugin, MagicDustManager.this.cfg, "gui.paid.");
            this.buttons = new HashSet<GuiItem>();
            this.vault = plugin.getVault();
            this.hasVault = this.vault != null && this.vault.getEconomy() != null;
            String path = "gui.paid.";
            this.itemSlot = MagicDustManager.this.cfg.getInt(path + "item-slot", 4);
            for (String itemId : MagicDustManager.this.cfg.getSection(path + "dust-buttons")) {
                GuiItem gi = MagicDustManager.this.cfg.getGuiItem(path + "dust-buttons." + itemId);
                if (gi == null) continue;
                String path2 = path + "dust-buttons." + itemId + ".";
                final int rateAmount = MagicDustManager.this.cfg.getInt(path2 + "rate-amount");
                if (rateAmount == 0) continue;
                final double rateCost = this.hasVault ? MagicDustManager.this.cfg.getDouble(path2 + "rate-cost") : 0.0;
                final int rateCap = MagicDustManager.this.cfg.getInt(path2 + "rate-max", 80);
                ItemStack item = gi.getItem();
                ItemMeta meta = item.getItemMeta();
                if (meta == null) continue;
                List lore = meta.getLore();
                if (lore != null) {
                    lore.replaceAll(str -> str.replace("%rate-max%", String.valueOf(rateCap)));
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
                gi.setItem(item);
                gi.setClick(new GuiClick(){

                    public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                        double balance;
                        Inventory inv = e.getInventory();
                        ItemStack target = inv.getItem(PaidGUI.this.itemSlot);
                        if (target == null || target.getType() == Material.AIR) {
                            return;
                        }
                        int rateHas = ItemStats.getSocketRate(target);
                        if (rateHas >= rateCap) {
                            plugin.lang().MagicDust_Apply_Error_MaxRate.replace("%source%", (Object)PaidGUI.this.getTitle()).replace("%max-rate%", (Object)String.valueOf(rateHas)).send((CommandSender)p);
                            MagicDustManager.this.actionsError.process((Entity)p);
                            return;
                        }
                        int rateDiff = rateCap - rateHas;
                        int rateAmount2 = rateDiff >= rateAmount ? rateAmount : rateDiff;
                        double rateCost2 = rateCost;
                        if (rateCost > 0.0 && rateAmount2 < rateAmount) {
                            double costDiff = (double)rateAmount2 / (double)rateAmount;
                            rateCost2 *= costDiff;
                        }
                        if (rateCost2 > 0.0 && (balance = PaidGUI.this.vault.getBalance((OfflinePlayer)p)) < rateCost2) {
                            plugin.lang().MagicDust_GUI_Error_TooExpensive.replace("%cost%", (Object)NumberUT.format((double)rateCost2)).replace("%balance%", (Object)NumberUT.format((double)balance)).send((CommandSender)p);
                            MagicDustManager.this.actionsError.process((Entity)p);
                            return;
                        }
                        PlayerImproveItemSocketRateEvent event = new PlayerImproveItemSocketRateEvent(p, target, rateHas, rateHas + rateAmount2);
                        plugin.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            MagicDustManager.this.actionsError.process((Entity)p);
                            return;
                        }
                        PaidGUI.this.vault.take((OfflinePlayer)p, rateCost2);
                        inv.setItem(PaidGUI.this.itemSlot, null);
                        ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{target = MagicDustManager.this.changeItemRate(target, rateAmount2)});
                        MagicDustManager.this.openGUIPaid(p, target, true);
                    }
                });
                this.buttons.add(gi);
            }
            GuiClick click = new GuiClick(){

                public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                    if (type == ContentType.EXIT) {
                        p.closeInventory();
                    }
                }
            };
            for (String itemId : MagicDustManager.this.cfg.getSection(path + "content")) {
                GuiItem guiItem = MagicDustManager.this.cfg.getGuiItem(path + "content." + itemId, ContentType.class);
                if (guiItem == null) continue;
                if (guiItem.getType() != null) {
                    guiItem.setClick(click);
                }
                this.addButton(guiItem);
            }
        }

        public void open(@NotNull Player player, @NotNull ItemStack target) {
            this.clearUserCache(player);
            this.LOCKED_CACHE.add(player.getName());
            this.addButton(player, new JIcon(target), new int[]{this.itemSlot});
            int rateHas = ItemStats.getSocketRate(target);
            double balance = this.hasVault ? this.vault.getBalance((OfflinePlayer)player) : 0.0;
            for (GuiItem gi : this.buttons) {
                ItemStack item = gi.getItem();
                ItemMeta meta = item.getItemMeta();
                if (meta == null) continue;
                List lore = meta.getLore();
                if (lore != null) {
                    int rateAmount2;
                    int rateAmount = MagicDustManager.this.cfg.getInt("gui.paid.dust-buttons." + gi.getId() + ".rate-amount");
                    int rateCap = MagicDustManager.this.cfg.getInt("gui.paid.dust-buttons." + gi.getId() + ".rate-max");
                    double rateCost = this.hasVault ? (double)MagicDustManager.this.cfg.getInt("gui.paid.dust-buttons." + gi.getId() + ".rate-cost") : 0.0;
                    int rateDiff = rateCap - rateHas;
                    int n = rateAmount2 = rateDiff >= rateAmount ? rateAmount : rateDiff;
                    if (rateCost > 0.0 && rateAmount2 < rateAmount) {
                        double costDiff = (double)rateAmount2 / (double)rateAmount;
                        rateCost *= costDiff;
                    }
                    double rateCost2 = rateCost;
                    lore.replaceAll(str -> str.replace("%cost%", NumberUT.format((double)rateCost2)).replace("%balance%", NumberUT.format((double)balance)).replace("%rate-new%", String.valueOf(rateHas + rateAmount2)).replace("%rate-old%", String.valueOf(rateHas)));
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                }
                JIcon icon = new JIcon(item);
                icon.setClick(gi.getClick());
                for (int slot : gi.getSlots()) {
                    this.addButton(player, icon, new int[]{slot});
                }
            }
            super.open(player, 1);
        }

        protected boolean cancelClick(int slot) {
            return true;
        }

        protected boolean cancelPlayerClick() {
            return true;
        }

        protected boolean ignoreNullClick() {
            return true;
        }

        protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
        }

        protected void click(@NotNull Player player, @Nullable ItemStack item, int slot, @NotNull InventoryClickEvent e) {
            Inventory inv = e.getInventory();
            ItemStack target = inv.getItem(this.itemSlot);
            if (slot == this.itemSlot && target != null && target.getType() != Material.AIR) {
                inv.setItem(this.itemSlot, target);
                this.open(player, new ItemStack(Material.AIR));
                return;
            }
            if (slot > this.getSize() && (target == null || target.getType() == Material.AIR)) {
                if (item == null || item.getType() == Material.AIR) {
                    return;
                }
                MagicDustManager.this.openGUIPaid(player, item, true);
                return;
            }
            super.click(player, item, slot, e);
        }

        protected void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
            Inventory inv = e.getInventory();
            ItemStack target = inv.getItem(this.itemSlot);
            if (target != null && target.getType() != Material.AIR) {
                ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{target});
            }
            super.onClose(player, e);
        }
    }
}

