/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;

public class StatGUI
extends AbstractEditorGUI {
    private final EditorGUI.ItemType itemType;
    private final String path;

    public StatGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, EditorGUI.ItemType itemType, String path) {
        super(player, 1, "Editor/" + itemType.getTitle(), itemGenerator);
        this.itemType = itemType;
        this.path = path;
    }

    public void setContents() {
        this.setSlot(0, new Slot(StatGUI.createItem(Material.DROPPER, "&eChance", "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(ItemType.CHANCE.getPath(this.path)), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                StatGUI.this.sendSetMessage(ItemType.CHANCE.getTitle(), String.valueOf(StatGUI.this.itemGenerator.getConfig().getDouble(StatGUI.this.path)), s -> {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.CHANCE.getPath(StatGUI.this.path), (Object)Double.parseDouble(s));
                    StatGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.CHANCE.getPath(StatGUI.this.path), (Object)0);
                StatGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(StatGUI.createItem(Material.EXPERIENCE_BOTTLE, "&eScale by Level", "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(ItemType.SCALE_BY_LEVEL.getPath(this.path)), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                StatGUI.this.sendSetMessage(ItemType.SCALE_BY_LEVEL.getTitle(), String.valueOf(StatGUI.this.itemGenerator.getConfig().getDouble(ItemType.SCALE_BY_LEVEL.getPath(StatGUI.this.path))), s -> {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.SCALE_BY_LEVEL.getPath(StatGUI.this.path), (Object)Double.parseDouble(s));
                    StatGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.SCALE_BY_LEVEL.getPath(StatGUI.this.path), (Object)0);
                StatGUI.this.saveAndReopen();
            }
        });
        this.setSlot(2, new Slot(StatGUI.createItem(Material.BROWN_MUSHROOM, "&eMinimum Value", "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(ItemType.MIN.getPath(this.path)), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                StatGUI.this.sendSetMessage(ItemType.MIN.getTitle(), String.valueOf(StatGUI.this.itemGenerator.getConfig().getDouble(ItemType.MIN.getPath(StatGUI.this.path))), s -> {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(StatGUI.this.path), (Object)Double.parseDouble(s));
                    StatGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.MIN.getPath(StatGUI.this.path), (Object)0);
                StatGUI.this.saveAndReopen();
            }
        });
        this.setSlot(3, new Slot(StatGUI.createItem(Material.RED_MUSHROOM, "&eMaximum Value", "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(ItemType.MAX.getPath(this.path)), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                StatGUI.this.sendSetMessage(ItemType.MAX.getTitle(), String.valueOf(StatGUI.this.itemGenerator.getConfig().getDouble(ItemType.MAX.getPath(StatGUI.this.path))), s -> {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(StatGUI.this.path), (Object)Double.parseDouble(s));
                    StatGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.MAX.getPath(StatGUI.this.path), (Object)0);
                StatGUI.this.saveAndReopen();
            }
        });
        final boolean flatRange = this.itemGenerator.getConfig().getBoolean(ItemType.FLAT_RANGE.getPath(this.path));
        this.setSlot(4, new Slot(StatGUI.createItem(flatRange ? Material.STRUCTURE_VOID : Material.BARRIER, "&eFlat Range", "&bCurrent: &a" + flatRange, "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.FLAT_RANGE.getPath(StatGUI.this.path), (Object)(!flatRange ? 1 : 0));
                StatGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                StatGUI.this.itemGenerator.getConfig().set(ItemType.FLAT_RANGE.getPath(StatGUI.this.path), (Object)false);
                StatGUI.this.saveAndReopen();
            }
        });
        if (this.itemType != EditorGUI.ItemType.FABLED_ATTRIBUTES) {
            final boolean round = this.itemGenerator.getConfig().getBoolean(ItemType.ROUND.getPath(this.path));
            this.setSlot(5, new Slot(StatGUI.createItem(round ? Material.SNOWBALL : Material.SNOW_BLOCK, "&eRound", "&bCurrent: &a" + round, "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

                public void onLeftClick() {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.ROUND.getPath(StatGUI.this.path), (Object)(!round ? 1 : 0));
                    StatGUI.this.saveAndReopen();
                }

                public void onRightClick() {
                    StatGUI.this.itemGenerator.getConfig().set(ItemType.ROUND.getPath(StatGUI.this.path), (Object)false);
                    StatGUI.this.saveAndReopen();
                }
            });
        }
    }

    public static enum ItemType {
        CHANCE("chance"),
        SCALE_BY_LEVEL("scale-by-level"),
        MIN("min"),
        MAX("max"),
        FLAT_RANGE("flat-range"),
        ROUND("round");

        private final String path;

        private ItemType(String path) {
            this.path = path;
        }

        public String getPath(String rootPath) {
            return rootPath + "." + this.path;
        }

        public String getTitle() {
            return this.name().replace('_', ' ').toLowerCase();
        }
    }
}

